# 2021-02-16 Triage Log

A mostly quiet week, though with an excellent improvement in bootstrap times,
shaving off a couple percent off the total and 10% off of rustc_middle due to
changes in the code being compiled.

Triage done by **@simulacrum**.
Revision range: [ea098255f74923d69ea234ee526df6b9cecc3b9b..f1c47c79fe8438ed241630f885797eebef3a6cab](https://perf.rust-lang.org/?start=ea098255f74923d69ea234ee526df6b9cecc3b9b&end=f1c47c79fe8438ed241630f885797eebef3a6cab&absolute=false&stat=instructions%3Au)

1 Regressions, 2 Improvements, 1 Mixed

#### Regressions

Initialize BTree nodes directly in the heap [#81494](https://github.com/rust-lang/rust/issues/81494)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7e0241c63755ea28045d512b742f50b307874419&end=3c10a880eca60379343a6c6d19dd5bda38ead55d&stat=instructions:u) (up to 1.3% on `full` builds of `cargo-debug`)
- Not really expected, but this is aiming for optimizing initialization of large
  k/v pairs, so perhaps worth it. Left a nag.

#### Improvements

[experiment] remove `#[inline]` from rustc_query_system::plumbing [#81892](https://github.com/rust-lang/rust/issues/81892)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=185de5f41a64e1b790524d5873dc1f7e368f64ab&end=097bc6a84f2280a889b9ab4b544f27851a978927&stat=instructions:u) (up to -1.0% on `full` builds of `ctfe-stress-4-opt`)

directly expose copy and copy_nonoverlapping intrinsics [#81238](https://github.com/rust-lang/rust/issues/81238)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3c10a880eca60379343a6c6d19dd5bda38ead55d&end=8e54a21139ae96a2aca3129100b057662e2799b9&stat=instructions:u) (up to -2.2% on `incr-patched: u32 3072` builds of `issue-46449-debug`)
- Surprisingly large improvement from essentially removing a function wrapper,
  seems pretty unfortunate that this is the case. May have something to do with
  MIR opts not triggering on these intrinsics when they were previously wrapped.

#### Mixed

Check the result cache before the DepGraph when ensuring queries [#81855](https://github.com/rust-lang/rust/issues/81855)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9503ea19edbf01b9435e80e17d60ce1b88390116&end=d1206f950ffb76c76e1b74a19ae33c2b7d949454&stat=instructions:u) (up to 2.3% on `full` builds of `unused-warnings-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=9503ea19edbf01b9435e80e17d60ce1b88390116&end=d1206f950ffb76c76e1b74a19ae33c2b7d949454&stat=instructions:u) (up to -1.0% on `incr-unchanged` builds of `clap-rs-check`)
- Major improvement in rustc_middle compile times (10% win), but benchmarks are
  regressed across the board pretty much, and this is surprising as PR perf
  showed a decisive win. Left a nag to ask for reasons why this might be.

#### Nags requiring follow up

Investigations pending:
- https://github.com/rust-lang/rust/pull/81494#issuecomment-779938322
- https://github.com/rust-lang/rust/pull/81855#issuecomment-779950478

From last week:
- Waiting on more investigation in [#81476](https://github.com/rust-lang/rust/issues/81476).
- Need to follow up on the regressions reported this week.
