# frozen-string-literal: true

require 'minitest/autorun'
require 'specinfra'
Specinfra.configuration.backend = :exec

class TestSpecInfraOnDebian < Minitest::Test
  def test_os_info
    os_info = Specinfra::HostInventory.instance.backend.os_info
    os_info.each do |k, v|
      assert v, "expected os_info[:#{k}] to not be nil"
    end
  end

  def test_os_family
    from_dpkg = `dpkg-vendor --query Vendor`.strip.downcase
    detected = Specinfra::HostInventory.instance.backend.os_info[:family].to_s.downcase
    assert_equal from_dpkg, detected
  end
end
