---
layout: post
title: Polyglot 1.10 - melhorias no i18n_headers
lang: pt-BR
description: Lançamento do Jekyll Polyglot 1.10.0, com melhorias na geração de SEO ao usar o plugin i18n_headers
---

O Jekyll-Polyglot 1.10 já está disponível. Ele traz grandes melhorias e mudanças no plugin liquid `i18n_headers` para SEO, além de pequenos ajustes para idempotência em builds paralelos. Contribuições da comunidade e Vibe Coding ajudaram em grande parte dos recursos, testes e redação deste lançamento.

## Melhorias no i18n_headers

O plugin `i18n_headers` agora possui capacidades estendidas nesta versão:

* adiciona `<link rel="canonical" ...>` para cada idioma da página, garantindo que a indexação seja única em todos os sites.
* adiciona `<link rel="alternate" hreflang="x-default" ...>` para apontar para a versão padrão do site quando nenhum idioma correspondente é solicitado pelo navegador.
* define corretamente `<link rel="alternate" hreflang="...">` para páginas e posts em coleções com permalinks personalizados.
* a URL padrão agora incluirá `site.baseUrl` se definido.

Isso também corrige um bug que fazia com que a relativização de URLs absolutas alterasse essas tags involuntariamente.

## Contribuições vibe-coded

O uso de certas ferramentas de [vibe coding](https://en.wikipedia.org/wiki/Vibe_coding) ajudou a encontrar, medir e verificar correções e recursos para este lançamento. Essa é uma nova abordagem para o desenvolvimento de software e permitiu a criação de testes Ruby avançados para código de plugin Jekyll executado em muitos idiomas do site.

Os testes escritos com vibe coding ajudaram a manter a alta cobertura de testes e a adicionar recursos complexos com confiança. Garantir a automação dos testes permitiu que recursos complicados fossem construídos corretamente.

Além disso, as ferramentas de vibe coding ajudaram a traduzir este post do blog para muitos idiomas.

## Contribuições da comunidade

O Jekyll-Polyglot tem sido apoiado por pessoas. A documentação em linguagem humana é contribuída por pessoas que querem ver este plugin documentado em sua língua materna. Pessoas que contribuem com correções de bugs e documentação ajudaram este plugin a alcançar milhares de downloads por lançamento. A programação assistida por IA, em minhas ou suas mãos, moldará o software que usamos e os muitos idiomas em que escrevemos e falamos. 

## ruby >= 3.1 obrigatório

Atualizações contínuas de segurança das dependências de build do jekyll-polyglot exigiram uma atualização importante para ruby 3.1. Isso pode afetar sistemas de build que geram documentação com jekyll-polyglot. Agora é um bom momento para atualizar para a versão principal mais recente do ruby. Avise se essas mudanças causarem complicações nas builds do jekyll. 