module GrapePathHelpers
  # methods to extend Grape::Endpoint so that calls
  # to unknown methods will look for a route with a matching
  # helper function name
  module NamedRouteMatcher
    def method_missing(method_id, *arguments)
      return super unless method_id.to_s =~ /_path$/

      segments = arguments.first || {}

      route = Grape::API::Instance.decorated_routes.detect do |r|
        route_match?(r, method_id, segments)
      end

      if route
        route.send(method_id, *arguments)
      else
        super
      end
    end

    def respond_to_missing?(method_name, _include_private = false)
      return super unless method_name =~ /_path$/

      Grape::API::Instance.decorated_routes.detect do |route|
        return true if route.respond_to?(method_name)
      end

      super
    end

    def route_match?(route, method_name, segments)
      return false unless route.respond_to?(method_name)
      # rubocop:disable Metrics/LineLength
      raise ArgumentError, 'Helper options must be a hash' unless segments.is_a?(Hash)
      # rubocop:enable Metrics/LineLength
      requested_segments = segments.keys.map(&:to_s)
      route.uses_segments_in_path_helper?(requested_segments)
    end
  end
end
