% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\docType{data}
\name{Layout}
\alias{Layout}
\title{Layout}
\description{
The Layout class is a chaperone class discouraged for extension. The class
fulfils the following tasks. The class houses the Coord and Facet classes
and tracks their stateful parameters. In addition, it manages the position
scales for each panel. It is responsible for keeping track of panel
specifications and matching pieces of the data to scales and parameters in
panel-wise manners.
}
\details{
The Layout class is only exported for extensions that re-implement a
\code{ggplot_build()} method for their specific class of plots. It is discouraged
to subclass the Layout class and for all purposes be considered an internal
structure. It has no user-facing constructor to put an small barrier in the
way.

The class is used throughout \code{ggplot_build()}, with the notable exception of
the \code{render()} method, which is used in \code{ggplot_gtable()} instead.
}
\section{Fields}{

\describe{
\item{\code{coord,coord_params}}{A \code{\link[=Coord]{<Coord>}} ggproto object and a list
of the coordinate system's parameters. Parameters get populated by the
\code{Coord$setup_params()} method.}

\item{\code{facet,facet_params}}{A \code{\link[=Facet]{<Facet>}} ggproto object and a list
of the faceting specification's parameters. Parameters get populated by
the \code{Facet$setup_params()} method.}

\item{\code{layout}}{A data frame with a row for each panel. The data frame
contains integer columns \code{PANEL}, \code{SCALE_X}, \code{SCALE_Y}, \code{ROW} and \code{COL}
representing a panel ID, scale indices and placement locations. In addition,
the layout may contain faceting variables or other additional information.
This field gets populated by the \code{Facet$compute_layout()} method.}

\item{\code{panel_scales_x,panel_scales_y}}{A list of \code{x} and \code{y} position scales
parallel to the layout field's \code{SCALE_X} and \code{SCALE_Y} levels respectively.
This fields gets populated by the \code{Facet$init_scales()} method.}

\item{\code{panel_params}}{A named list of parameters per panel populated by the
\code{Coord$setup_panel_params()} method. Contains \verb{<ViewScale>} entries for
the \code{x} and \code{y} variables in addition to ranges and other information the
coordinate system might need to transform or render guides and grids.}

\item{\code{setup}}{\strong{Description}

A function method for setting up the relevant information for the layout
of the plot. It populates the \code{facet_params}, \code{coord_params} and \code{layout}
fields and appends a \code{PANEL} variable to the layer data.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$setup(data, plot_data, plot_env)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames with layer data.}
\item{\code{plot_data}}{The data frame in the \code{data} field of the ggplot
object.}
\item{\code{plot_env}}{The environment in the \code{plot_env} field of the
ggplot object.}
}

\strong{Value}

A list of data frames from the \code{data} argument with a \code{PANEL} variable
corresponding to rows in the \code{layout} field.
Also called for the side effects of populating fields.}

\item{\code{train_position}}{\strong{Description}

A function method for training position scales and optionally initiating
them. Implementation is via the \code{Facet$train_scales()} and
\code{Facet$init_scales()} methods.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$train_position(data, x_scale, y_scale)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames with layer data.}
\item{\code{x_scale},\code{y_scale}}{A single prototype position scale for the \code{x}
and \code{y} aesthetics respectively.}
}

\strong{Value}

Nothing, this method is called for the side effect of training scales and
optionally populating the \code{panel_scales_x} and \code{panel_scales_y} fields.}

\item{\code{map_position}}{\strong{Description}

A function method for mapping position aesthetics. For discrete scales this
converts discrete levels to a numeric representation, usually integers. For
continuous scales, this applies out-of-bounds handling.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$map_position(data)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames with layer data.}
}

\strong{Value}

A list of data frames per the \code{data} argument with mapped position
aesthetics.}

\item{\code{reset_scales}}{\strong{Description}

A function method for resetting scale ranges. After computing stats and
position adjustments, scales need to be reset and re-trained to have an
accurate measure of the data limits. This goes through the
\code{panel_scales_x} and \code{panel_scales_y} fields and invokes the
\code{Scale$reset()} method.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$reset_scales()
}\if{html}{\out{</div>}}

\strong{Value}

Nothing, it is called for the side-effect of resetting scale ranges.}

\item{\code{setup_panel_params}}{\strong{Description}

A function method for executing \code{Coord$setup_panel_params()} once per panel
with the appropriate scales. For efficiency reasons, the setup is invoked
once per unique combination of \code{x} and \code{y} scale.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$setup_panel_params()
}\if{html}{\out{</div>}}

\strong{Value}

Nothing, it is called for the side effect of populating the \code{panel_params}
field.}

\item{\code{setup_panel_guides}}{\strong{Description}

A function method for setting up and training the position guides (axes)
once per panel with the appropriate scales. For efficiency reasons,
the guides are setup once per unique  combination of \code{x} and \code{y} scale.
It calls the \code{Coord$setup_panel_guides()} and \code{Coord$train_panel_guides()}
methods.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$setup_panel_guides(guides, layers)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{guides}}{A \verb{<Guides>} ggproto object from the \code{guides} field of
the ggplot object.}
\item{\code{layers}}{A list of layers from the \code{layers} field of the ggplot
object.}
}

\strong{Value}

Nothing, it is called for the side effect of augmenting each entry of the
\code{panel_params} field with position guides.}

\item{\code{setup_panel_guides}}{\strong{Description}

A function method for setting up the \code{Facet$finish_data()} hook.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$finish_data(data)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames with layer data.}
}

\strong{Value}

A list of data frames with layer data.}

\item{\code{render}}{\strong{Description}

A function method for drawing and assembling the core plot. Mostly it
delegates tasks to the specific Facet methods for drawing components.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$render(panels, data, theme, labels)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panels}}{A list parallel to layers. Each element is another list
with grobs for each panel, generated by \code{Layer$draw_geom()}.}
\item{\code{data}}{A list of data frames with layer data.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme}.}
\item{\code{labels}}{A list of labels from the \code{labels} field of the ggplot
object.}
}

\strong{Value}

A gtable containing a plot with panels, axes, axis titles and strips.}

\item{\code{resolve_label}}{\strong{Description}

A function method for prying the axis titles from guides, scales or plot
labels.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$resolve_label(scale, labels)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{scale}}{A single scale from the \code{panel_scales_x} or
\code{panel_scales_y} fields.}
\item{\code{labels}}{A list of labels from the \code{labels} field of the ggplot
object.}
}

\strong{Value}

A named list containing a two titles named \code{"primary"} and \code{"secondary"}.}

\item{\code{render_labels}}{\strong{Description}

A function method for drawing axis title grobs. The position guides
themselves do not typically render the axis title grobs as they are
orchestrated by the layout to draw one title even for multiple axes.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$render_labels(labels, theme)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{labels}}{A named list containing an \code{x} list and a \code{y} list. The
\code{x} and \code{y} lists have \code{primary} and \code{secondary} labels. It originates
from the \code{Coord$labels()} method.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme}.}
}

\strong{Value}

A list with the same structure and names as the \code{labels} argument, but with
grobs instead of text.}

\item{\code{get_scales}}{\strong{Description}

A function method for retrieving panel specific scales. It is called in
the \code{Stat$compute_layer()} and \code{Position$compute_layer()} methods. The
\code{Geom} uses the \code{panel_params} field instead of the raw scales.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layout$get_scales(i)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{i}}{A scalar integer panel index giving the panel for which to
retrieve scales}
}

\strong{Value}

A named list of scales giving the \code{x} and \code{y} scale for the panel.}
}}

\examples{
# Some dummy layout components
facet <- facet_null()
coord <- coord_cartesian()

# Use in custom `ggplot_build()` methods
layout <- ggproto(NULL, Layout, facet = facet, coord = coord)
}
\seealso{
Other Layout components: 
\code{\link{Coord}},
\code{\link{Facet}}

Other chaperone classes: 
\code{\link{Layer-class}}
}
\concept{Layout components}
\concept{chaperone classes}
\keyword{internal}
