"""
file management functions for for dmm.
"""

import os
import pathlib
from command_runner import command_runner

# todo: add options to allow appending/replacing

def write_file(file, content):
    """
    Writes one or more lines to a file.
    """
    # Ensure that basepath exists first
    create_base_path(file)
    file = open(file, "w+")
    file.write(content)
    file.close()


def create_base_path(peth):
    """
    Ensures that a parent directory exists.
    """
    path = pathlib.Path(file).parent
    path.mkdir(parents=True, exist_ok=True)


def delete_path(path):
    print("Removing %s" % path)
    ecode, result = command_runner("rm -rf %s" % path)
    return ecode, result


def create_sparse_file(size, destination):
    """
    Create an empty sparse file.
    """
    ecode, result = command_runner("fallocate -l %s %s" % (size, destination))
    return ecode, result
