# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dataprotection import DataProtectionMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataProtectionMgmtBackupInstancesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataProtectionMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_get_backup_instance_operation_result(self, resource_group):
        response = self.client.backup_instances.get_backup_instance_operation_result(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
            operation_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_list(self, resource_group):
        response = self.client.backup_instances.list(
            resource_group_name=resource_group.name,
            vault_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_validate_for_backup(self, resource_group):
        response = self.client.backup_instances.begin_validate_for_backup(
            resource_group_name=resource_group.name,
            vault_name="str",
            parameters={
                "backupInstance": {
                    "dataSourceInfo": {
                        "resourceID": "str",
                        "datasourceType": "str",
                        "objectType": "str",
                        "resourceLocation": "str",
                        "resourceName": "str",
                        "resourceProperties": "base_resource_properties",
                        "resourceType": "str",
                        "resourceUri": "str",
                    },
                    "objectType": "str",
                    "policyInfo": {
                        "policyId": "str",
                        "policyParameters": {
                            "backupDatasourceParametersList": ["backup_datasource_parameters"],
                            "dataStoreParametersList": ["data_store_parameters"],
                        },
                        "policyVersion": "str",
                    },
                    "currentProtectionState": "str",
                    "dataSourceSetInfo": {
                        "resourceID": "str",
                        "datasourceType": "str",
                        "objectType": "str",
                        "resourceLocation": "str",
                        "resourceName": "str",
                        "resourceProperties": "base_resource_properties",
                        "resourceType": "str",
                        "resourceUri": "str",
                    },
                    "datasourceAuthCredentials": "auth_credentials",
                    "friendlyName": "str",
                    "identityDetails": {"useSystemAssignedIdentity": bool, "userAssignedIdentityArmUrl": "str"},
                    "protectionErrorDetails": {
                        "code": "str",
                        "details": [...],
                        "innerError": {"additionalInfo": {"str": "str"}, "code": "str", "embeddedInnerError": ...},
                        "isRetryable": bool,
                        "isUserError": bool,
                        "message": "str",
                        "properties": {"str": "str"},
                        "recommendedAction": ["str"],
                        "target": "str",
                    },
                    "protectionStatus": {
                        "errorDetails": {
                            "code": "str",
                            "details": [...],
                            "innerError": {"additionalInfo": {"str": "str"}, "code": "str", "embeddedInnerError": ...},
                            "isRetryable": bool,
                            "isUserError": bool,
                            "message": "str",
                            "properties": {"str": "str"},
                            "recommendedAction": ["str"],
                            "target": "str",
                        },
                        "status": "str",
                    },
                    "provisioningState": "str",
                    "resourceGuardOperationRequests": ["str"],
                    "validationType": "str",
                }
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_get(self, resource_group):
        response = self.client.backup_instances.get(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_create_or_update(self, resource_group):
        response = self.client.backup_instances.begin_create_or_update(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "properties": {
                    "dataSourceInfo": {
                        "resourceID": "str",
                        "datasourceType": "str",
                        "objectType": "str",
                        "resourceLocation": "str",
                        "resourceName": "str",
                        "resourceProperties": "base_resource_properties",
                        "resourceType": "str",
                        "resourceUri": "str",
                    },
                    "objectType": "str",
                    "policyInfo": {
                        "policyId": "str",
                        "policyParameters": {
                            "backupDatasourceParametersList": ["backup_datasource_parameters"],
                            "dataStoreParametersList": ["data_store_parameters"],
                        },
                        "policyVersion": "str",
                    },
                    "currentProtectionState": "str",
                    "dataSourceSetInfo": {
                        "resourceID": "str",
                        "datasourceType": "str",
                        "objectType": "str",
                        "resourceLocation": "str",
                        "resourceName": "str",
                        "resourceProperties": "base_resource_properties",
                        "resourceType": "str",
                        "resourceUri": "str",
                    },
                    "datasourceAuthCredentials": "auth_credentials",
                    "friendlyName": "str",
                    "identityDetails": {"useSystemAssignedIdentity": bool, "userAssignedIdentityArmUrl": "str"},
                    "protectionErrorDetails": {
                        "code": "str",
                        "details": [...],
                        "innerError": {"additionalInfo": {"str": "str"}, "code": "str", "embeddedInnerError": ...},
                        "isRetryable": bool,
                        "isUserError": bool,
                        "message": "str",
                        "properties": {"str": "str"},
                        "recommendedAction": ["str"],
                        "target": "str",
                    },
                    "protectionStatus": {
                        "errorDetails": {
                            "code": "str",
                            "details": [...],
                            "innerError": {"additionalInfo": {"str": "str"}, "code": "str", "embeddedInnerError": ...},
                            "isRetryable": bool,
                            "isUserError": bool,
                            "message": "str",
                            "properties": {"str": "str"},
                            "recommendedAction": ["str"],
                            "target": "str",
                        },
                        "status": "str",
                    },
                    "provisioningState": "str",
                    "resourceGuardOperationRequests": ["str"],
                    "validationType": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_delete(self, resource_group):
        response = self.client.backup_instances.begin_delete(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_adhoc_backup(self, resource_group):
        response = self.client.backup_instances.begin_adhoc_backup(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
            parameters={"backupRuleOptions": {"ruleName": "str", "triggerOption": {"retentionTagOverride": "str"}}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_validate_for_modify_backup(self, resource_group):
        response = self.client.backup_instances.begin_validate_for_modify_backup(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
            parameters={
                "backupInstance": {
                    "dataSourceInfo": {
                        "resourceID": "str",
                        "datasourceType": "str",
                        "objectType": "str",
                        "resourceLocation": "str",
                        "resourceName": "str",
                        "resourceProperties": "base_resource_properties",
                        "resourceType": "str",
                        "resourceUri": "str",
                    },
                    "objectType": "str",
                    "policyInfo": {
                        "policyId": "str",
                        "policyParameters": {
                            "backupDatasourceParametersList": ["backup_datasource_parameters"],
                            "dataStoreParametersList": ["data_store_parameters"],
                        },
                        "policyVersion": "str",
                    },
                    "currentProtectionState": "str",
                    "dataSourceSetInfo": {
                        "resourceID": "str",
                        "datasourceType": "str",
                        "objectType": "str",
                        "resourceLocation": "str",
                        "resourceName": "str",
                        "resourceProperties": "base_resource_properties",
                        "resourceType": "str",
                        "resourceUri": "str",
                    },
                    "datasourceAuthCredentials": "auth_credentials",
                    "friendlyName": "str",
                    "identityDetails": {"useSystemAssignedIdentity": bool, "userAssignedIdentityArmUrl": "str"},
                    "protectionErrorDetails": {
                        "code": "str",
                        "details": [...],
                        "innerError": {"additionalInfo": {"str": "str"}, "code": "str", "embeddedInnerError": ...},
                        "isRetryable": bool,
                        "isUserError": bool,
                        "message": "str",
                        "properties": {"str": "str"},
                        "recommendedAction": ["str"],
                        "target": "str",
                    },
                    "protectionStatus": {
                        "errorDetails": {
                            "code": "str",
                            "details": [...],
                            "innerError": {"additionalInfo": {"str": "str"}, "code": "str", "embeddedInnerError": ...},
                            "isRetryable": bool,
                            "isUserError": bool,
                            "message": "str",
                            "properties": {"str": "str"},
                            "recommendedAction": ["str"],
                            "target": "str",
                        },
                        "status": "str",
                    },
                    "provisioningState": "str",
                    "resourceGuardOperationRequests": ["str"],
                    "validationType": "str",
                }
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_trigger_rehydrate(self, resource_group):
        response = self.client.backup_instances.begin_trigger_rehydrate(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
            parameters={"recoveryPointId": "str", "rehydrationRetentionDuration": "str", "rehydrationPriority": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_trigger_restore(self, resource_group):
        response = self.client.backup_instances.begin_trigger_restore(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
            parameters={
                "objectType": "AzureBackupRestoreWithRehydrationRequest",
                "recoveryPointId": "str",
                "rehydrationPriority": "str",
                "rehydrationRetentionDuration": "str",
                "restoreTargetInfo": "restore_target_info_base",
                "sourceDataStoreType": "str",
                "identityDetails": {"useSystemAssignedIdentity": bool, "userAssignedIdentityArmUrl": "str"},
                "resourceGuardOperationRequests": ["str"],
                "sourceResourceId": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_resume_backups(self, resource_group):
        response = self.client.backup_instances.begin_resume_backups(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_resume_protection(self, resource_group):
        response = self.client.backup_instances.begin_resume_protection(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_stop_protection(self, resource_group):
        response = self.client.backup_instances.begin_stop_protection(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_suspend_backups(self, resource_group):
        response = self.client.backup_instances.begin_suspend_backups(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_sync_backup_instance(self, resource_group):
        response = self.client.backup_instances.begin_sync_backup_instance(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
            parameters={"syncType": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_validate_for_restore(self, resource_group):
        response = self.client.backup_instances.begin_validate_for_restore(
            resource_group_name=resource_group.name,
            vault_name="str",
            backup_instance_name="str",
            parameters={"restoreRequestObject": "azure_backup_restore_request"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_trigger_cross_region_restore(self, resource_group):
        response = self.client.backup_instances.begin_trigger_cross_region_restore(
            resource_group_name=resource_group.name,
            location="str",
            parameters={
                "crossRegionRestoreDetails": {"sourceBackupInstanceId": "str", "sourceRegion": "str"},
                "restoreRequestObject": "azure_backup_restore_request",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_instances_begin_validate_cross_region_restore(self, resource_group):
        response = self.client.backup_instances.begin_validate_cross_region_restore(
            resource_group_name=resource_group.name,
            location="str",
            parameters={
                "crossRegionRestoreDetails": {"sourceBackupInstanceId": "str", "sourceRegion": "str"},
                "restoreRequestObject": "azure_backup_restore_request",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
