# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import ConnectedVMwareMgmtClientConfiguration
from .operations import (
    ClustersOperations,
    DatastoresOperations,
    HostsOperations,
    InventoryItemsOperations,
    Operations,
    ResourcePoolsOperations,
    VCentersOperations,
    VMInstanceGuestAgentsOperations,
    VirtualMachineInstancesOperations,
    VirtualMachineTemplatesOperations,
    VirtualNetworksOperations,
    VmInstanceHybridIdentityMetadataOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class ConnectedVMwareMgmtClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Self service experience for VMware.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.connectedvmware.aio.operations.Operations
    :ivar resource_pools: ResourcePoolsOperations operations
    :vartype resource_pools: azure.mgmt.connectedvmware.aio.operations.ResourcePoolsOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.connectedvmware.aio.operations.ClustersOperations
    :ivar hosts: HostsOperations operations
    :vartype hosts: azure.mgmt.connectedvmware.aio.operations.HostsOperations
    :ivar datastores: DatastoresOperations operations
    :vartype datastores: azure.mgmt.connectedvmware.aio.operations.DatastoresOperations
    :ivar vcenters: VCentersOperations operations
    :vartype vcenters: azure.mgmt.connectedvmware.aio.operations.VCentersOperations
    :ivar virtual_machine_templates: VirtualMachineTemplatesOperations operations
    :vartype virtual_machine_templates:
     azure.mgmt.connectedvmware.aio.operations.VirtualMachineTemplatesOperations
    :ivar virtual_networks: VirtualNetworksOperations operations
    :vartype virtual_networks: azure.mgmt.connectedvmware.aio.operations.VirtualNetworksOperations
    :ivar inventory_items: InventoryItemsOperations operations
    :vartype inventory_items: azure.mgmt.connectedvmware.aio.operations.InventoryItemsOperations
    :ivar virtual_machine_instances: VirtualMachineInstancesOperations operations
    :vartype virtual_machine_instances:
     azure.mgmt.connectedvmware.aio.operations.VirtualMachineInstancesOperations
    :ivar vm_instance_hybrid_identity_metadata: VmInstanceHybridIdentityMetadataOperations
     operations
    :vartype vm_instance_hybrid_identity_metadata:
     azure.mgmt.connectedvmware.aio.operations.VmInstanceHybridIdentityMetadataOperations
    :ivar vm_instance_guest_agents: VMInstanceGuestAgentsOperations operations
    :vartype vm_instance_guest_agents:
     azure.mgmt.connectedvmware.aio.operations.VMInstanceGuestAgentsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The Subscription ID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2023-10-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = ConnectedVMwareMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.resource_pools = ResourcePoolsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.clusters = ClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.hosts = HostsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.datastores = DatastoresOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vcenters = VCentersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_templates = VirtualMachineTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.inventory_items = InventoryItemsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_instances = VirtualMachineInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vm_instance_hybrid_identity_metadata = VmInstanceHybridIdentityMetadataOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vm_instance_guest_agents = VMInstanceGuestAgentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "ConnectedVMwareMgmtClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
