.\" Copyright (c) 1999 Ottavio G. Rizzo <rizzo@pluto.linux.it>
.\"
.\" Traducido por Benjamn Albiana <benalb@escomposlinux.org>
.\"
.\" This is free documentation; you can redistribute it and/or
.\" modify it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; either version 2 of
.\" the License, or (at your option) any later version.
.\"
.\" The GNU General Public License's references to "object code"
.\" and "executables" are to be interpreted as the output of any
.\" document formatting or typesetting system, including
.\" intermediate and printed output.
.\"
.\" This manual is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public
.\" License along with this manual; if not, write to the Free
.\" Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
.\" USA.
.\"
.TH MAKEWHATIS 8 "Septiembre 19 2005"
.SH NOMBRE
makewhatis \- Crea la base de datos de whatis
.SH SINOPSIS
.BI "makewhatis [-u] [-v] [-w] [-s " secciones "  ] [-c [" catpath "]] [" manpath "]"
.SH DESCRIPCIN
.B makewhatis
lee todas las pginas del manual contenidas en las
.IR secciones " de " manpath 
dadas o de las pginas preformateadas contenidas en las
.IR secciones " de " catpath
dadas.
Por cada pgina, escribe una lnea en la base de datos de whatis; cada 
lnea contiene el nombre de la pgina y una breve descripcin, 
separadas por una guin. La descripcin se obtiene del contenido de
la seccin NOMBRE de la pgina del manual.
.LP
Ya que otros idiomas usan trminos diferentes para la seccin NOMBRE, 
.B makewhatis
reconoce los trminos equivalentes en checo, italiano, finlands, francs,
alemn y espaol.
.LP
Si no se da el argumento
.I manpath
se asume por defecto
.I /usr/man
.SH OPCIONES
.TP
.B -u
Actualiza la base de datos con pginas nuevas.
.TP
.B -v
Salida prolija
.TP
.B -w
Usa la ruta de `man --path`
.TP
.BI -s " secciones "
Mira en las
.I secciones
de
.IR manpath " o " catpaht.
Si no existe la opcin, se asume el valor
.I  \'1 2 3 4 5 6 7 8 9 n l\'
.TP
.BI -c " catpath"
Se exploran la pginas del manual preformateadas en
.I catpath
Si no se da el argumento, se asume que ser el primer directorio
existente entre
.IR /usr/man/preformat " y " /usr/man .
.SH EJEMPLOS
.PP
Para rehacer slo
.IR /usr/X11R6/man/whatis " y " /usr/local/man/whatis
.IP
makewhatis /usr/X11R6/man /usr/local/man
.PP
Para reconstruir todas las bases de datos, incluyendo las traducciones
al finlands, francs e italiano
.IP
LANGUAGE=fi:fr:it makewhatis -w
.SH FALLOS
.B makewhatis
puede que no maneje bien pginas del manual hechas con macros troff
no estndar, como las pginas de Tcl/Tk.
.PP
.B makewhatis
no funciona con traducciones preformateadas
.SH AUTOR
John W. Eaton fue el autor original de
.BR "man" .
Zeyd M. Ben-Halim lanz man 1.2, y Andries Brouwer continu con 
las versiones 1.3 a 1.5p.
Federico Lucifredi <flucifredi@acm.org> es el encargado actual.
.SH TRADUCCIN
Benjamn Albiana, 2006
.SH VASE TAMBIN
.BR apropos (1),
.BR man (1),
.BR whatis (1)



