# Formats

[![Go Reference](https://pkg.go.dev/badge/github.com/transparency-dev/formats.svg)](https://pkg.go.dev/github.com/transparency-dev/formats)
[![Go Report Card](https://goreportcard.com/badge/github.com/transparency-dev/formats)](https://goreportcard.com/report/github.com/transparency-dev/formats)
[![OpenSSF Scorecard](https://api.securityscorecards.dev/projects/github.com/transparency-dev/formats/badge)](https://securityscorecards.dev/viewer/?uri=github.com/transparency-dev/formats)
[![codecov](https://codecov.io/gh/transparency-dev/formats/branch/main/graph/badge.svg?token=BBCRAMOBY2)](https://codecov.io/gh/transparency-dev/formats)
[![Slack Status](https://img.shields.io/badge/Slack-Chat-blue.svg)](https://transparency-dev.slack.com/)

## Overview

This repository contains descriptions and supporting implementations for some
reusable formats related to transparent logs.

While it's not in any way a requirement that transparent systems use these formats,
adopting them will enable a certain amount of interoperability and shared infrastructure
for basic tooling such as logs and witnesses.

## Formats

The following formats are described in this repository, more detailed information is
provided in the respective directories:
### Log Checkpoint

The [`log checkpoint`](./log/README.md#checkpoint-format) represents a commitment to the
state of a transparent log.

## Support
* Mailing list: https://groups.google.com/forum/#!forum/trillian-transparency
- Slack: https://transparency-dev.slack.com/ ([invitation](https://join.slack.com/t/transparency-dev/shared_invite/zt-27pkqo21d-okUFhur7YZ0rFoJVIOPznQ))
