/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.jaxp;

import com.thaiopensource.datatype.xsd.DatatypeLibraryFactoryImpl;
import com.thaiopensource.datatype.xsd.regex.java.RegexEngineImpl;
import com.thaiopensource.relaxng.jaxp.SchemaImpl;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.pattern.AnnotationsImpl;
import com.thaiopensource.relaxng.pattern.CommentListImpl;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.xml.ls.LS;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.validation.Schema2;
import com.thaiopensource.validation.SchemaFactory2;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaFactoryImpl
extends SchemaFactory2 {
    private DatatypeLibraryFactory datatypeLibraryFactory = null;
    private boolean defaultDatatypeLibraryFactory = true;
    public static final String PROPERTY_DATATYPE_LIBRARY_FACTORY = "http://relaxng.org/properties/datatype-library-factory";

    protected SchemaFactoryImpl() {
    }

    @Override
    public Schema2 newSchema(SAXSource sAXSource) throws SAXException {
        Resolver resolver2 = null;
        LSResourceResolver lSResourceResolver = this.getResourceResolver();
        if (lSResourceResolver != null) {
            resolver2 = LS.createResolver(lSResourceResolver);
        }
        SAXResolver sAXResolver = new SAXResolver(resolver2);
        ErrorHandler errorHandler = this.getErrorHandler();
        if (errorHandler == null) {
            errorHandler = new DraconianErrorHandler();
        }
        Parseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> parseable = this.createParseable(sAXSource, sAXResolver, errorHandler);
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        try {
            return new SchemaImpl(this, schemaPatternBuilder, SchemaBuilderImpl.parse(parseable, errorHandler, this.getDatatypeLibraryFactory(), schemaPatternBuilder, false));
        }
        catch (IOException iOException) {
            SAXParseException sAXParseException = new SAXParseException(iOException.getMessage(), null, iOException);
            errorHandler.fatalError(sAXParseException);
            throw sAXParseException;
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new SAXException("invalid schema");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (PROPERTY_DATATYPE_LIBRARY_FACTORY.equals(string)) {
            if (!(object instanceof DatatypeLibraryFactory)) throw new SAXNotSupportedException("value of \"http://relaxng.org/properties/datatype-library-factory\" property does not implement org.relaxng.datatype.DatatypeLibraryFactory");
            this.datatypeLibraryFactory = (DatatypeLibraryFactory)object;
            this.defaultDatatypeLibraryFactory = false;
            return;
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (PROPERTY_DATATYPE_LIBRARY_FACTORY.equals(string)) {
            return this.getDatatypeLibraryFactory();
        }
        return super.getProperty(string);
    }

    private DatatypeLibraryFactory getDatatypeLibraryFactory() {
        if (this.defaultDatatypeLibraryFactory) {
            this.datatypeLibraryFactory = new DatatypeLibraryFactoryImpl(new RegexEngineImpl());
            this.defaultDatatypeLibraryFactory = false;
        }
        return this.datatypeLibraryFactory;
    }

    protected abstract Parseable<Pattern, NameClass, Locator, VoidValue, CommentListImpl, AnnotationsImpl> createParseable(SAXSource var1, SAXResolver var2, ErrorHandler var3) throws SAXException;
}

