# patch_win_main.tcl
#
#       Patches the win/winMain.c in Tk distribution so that it can be
#       used by the GUI-base tixwish .exe file.
#
#       This patching is no really necessary with Tk 8.3+, but we want
#       to work with TK 8.0-8.2, too.
#
# Copyright (c) 1993-1999 Ioi Kim Lam.
# Copyright (c) 2000-2001 Tix Project Group.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# $Id: patch_win_main.tcl,v 1.2 2001/01/04 09:25:17 ioilam Exp $

if {[llength $argv] != 2} {
    puts "usage: $argv0 ../../tk8.3.2/win/winMain.c winMain_patch.c"
    exit -1
}

set fd [open [lindex $argv 0] RDONLY]
set data [read $fd]
close $fd

regsub {Tcl_AppInit[(]interp[)]} $data "DONT_WANT_Tcl_AppInit(interp)" data
set fd [open [lindex $argv 1] {WRONLY CREAT TRUNC}]
puts $fd $data
close $fd
