# pkgIndex.tcl --
#
#       !!! THIS IS A TEST FILE. SHOULD NOT APPEAR IN TIX BINARY
#       !!! INSTALLATION
#
#       This file is used during the development of Tix to load
#       the Tix package from the source directory. It should never
#       be copied to the installation directory.
#
#       The unix/ and win/ Makefiles should be used to generate a
#       pkgIndex.tcl file suitable for use in the instalaltion
#       directory
#
#       To load the Tix from the source directory, on Unix, do this:
#
#               $ setenv TCLLIBPATH /home/you/src/tix8.2
#               $ wish
#               % package require Tix
#
#       On Windows (must use / instead of \ in TCLLIBPATH):
#
#               set TCLLIBPATH=c:/tix8.2
#               wish.exe
#               (in Tk console) package require Tix
#       
# Copyright (c) 1993-1999 Ioi Kim Lam.
# Copyright (c) 2000-2001 Tix Project Group.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# $Id: pkgIndex.tcl,v 1.2 2001/01/04 06:48:53 ioilam Exp $

namespace eval _tixtmp {
    global tcl_platform

    set tix_version 8.2
    set tix_patchLevel 8.2.0

    regsub {[.]} $tix_version "" nodot_version

    switch -- $tcl_platform(platform) {
        "unix" {
            set libname   libtix$tix_version[info sharedlibextension]
            set libname_g libtix${tix_version}g[info sharedlibextension]
            set old [pwd]
            catch {
                catch {
                    cd [file join [file dirname [info script]] .. unix]
                }
                if {[file exists $libname_g]} {
                    set found [file join [pwd] $libname_g]
                    break
                }

                catch {
                    cd [file join [file dirname [info script]] .. unix]
                }
                if {[file exists $libname]} {
                    set found [file join [pwd] $libname]
                    break
                }
            }
            catch {
                cd $old
            }
            if {[info exists found]} {
                package ifneeded Tix $tix_version [list load $found Tix]
            } else {
                puts "[info script] failed to find $libname_g or $libname"
            }
        }
        "windows" {            
            set libname tix${nodot_version}.dll
            set libname_d tix${nodot_version}d.dll
            set old [pwd]

            catch {
                catch {
                    cd [file join [file dirname [info script]] .. win Debug]
                }
                if {[file exists $libname_d]} {
                    set found [file join [pwd] $libname_d]
                    break
                }

                catch {
                    cd [file join [file dirname [info script]] .. win Release]
                }
                if {[file exists $libname]} {
                    set found [file join [pwd] $libname]
                    break
                }
            }
            catch {
                cd $old
            }
            if {[info exists found]} {
                package ifneeded Tix $tix_version [list load $found Tix]
            } else {
                puts "[info script] failed to find $libname_d or $libname"
            }
        }
    }
}

namespace delete _tixtmp 
