
defwidget SimpleSelector

defmethod SimpleSelector new {name args} {
  global data

  args	initmethod init label actions title {titlefont bold} wait buttons \
	layout {inputlabel {New Name}} {textfont text} {sorted true}

  set stuff [app(get) $initmethod $init]
  if { [streq $sorted "true"] } {
    set stuff [lsort $stuff]
  }
  set actions [$self buildActions $actions $name]

  Toplevel new $name -title ${title} \
	-resizable true \
	-buttons $buttons \
	-handler [list $name _button] \
	-actions [concat $actions [list [list Help {} Library/simpleselector]]]
  defsuper $name SimpleSelector

  Corner new $name.c1 -layout {left}
  Corner new $name.c2 -layout {right}

  Listbox new $name.sel -layout {top expand fill} \
	-textfont $textfont \
	-action [list $name _mouse [assoc Mouse $actions]] \
	-double [list $name _mouse [assoc Double $actions]]
 
  $name slot _list	$stuff
  $name slot _value	{}
  $name slot _index	-1
  $name.sel set $stuff

  $name layout $layout
}

defmethod SimpleSelector _mouse {action listbox isel sel} {

  $self slot _value $sel
  $self slot _index $isel

  $listbox xview 0

  if { ![streq $action ""] } {
    uplevel #0 [concat $action [list $isel $sel]]
  }
}

defmethod SimpleSelector _button {button action} {

  case $button {
  {Dismiss} {
	$self Dismiss
    }
  {Help} {
	$self Help $action
    }
  default {
	uplevel #0 $action
    }
  }
}

defmethod SimpleSelector current {} {

  $self slot _index
}

defmethod SimpleSelector get {} {

  $self slot _list
}

defmethod SimpleSelector set {list} {

  $self slot _list $list
  $self.sel set $list
  return $list
}

defmethod SimpleSelector delete {n} {

  set list [$self slot _list]
  if { ![catch {set list [lreplace $list $n $n]}] } {
    $self slot _list $list
    $self.sel set $list
  }
  return $list
}

defmethod SimpleSelector insert {n item} {

  set list [$self slot _list]
  if { ![catch {set list [linsert $list $n $item]}] } {
    $self slot _list $list
    $self.sel set $list
  }
  return $list
}

Window addDemo SimpleSelector

defmethod SimpleSelector demo {} {

  SimpleSelector new * \
	-layout center \
	-buttons {New Delete Ok} \
	-actions {{New Neu - demoNew}
		  {Delete Loeschen - demoDelete} 
		  {Ok {} - demoOk}}
}

defmethod SimpleSelector demoNew {} {

  set pos [$self current]
  if { ![streq $pos ""] } {
    $self insert $pos [exec date]
  }
}

defmethod SimpleSelector demoDelete {} {

  set pos [$self current]
  if { ![streq $pos ""] } {
    $self delete $pos
  }
}

defmethod SimpleSelector demoOk {} {

  set list [$self get]
  puts stdout "List: $list"
}
