
defwidget Menu

defmethod Menu new {name args} {

  args

  menu $name \
	-background [Color slot bg] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled] \
	-font [Font slot menu]
  Menu instantiate $name {}

  $name bindings

  bind $name <Any-Enter> {%W _enter @%y}
  bind $name <Any-Leave> {%W _leave}
  bind $name <Any-Motion> {%W _motion @%y}

  bind $name <B1-ButtonRelease> {%W _invoke}
  bind $name <B3-ButtonRelease> {%W _invoke}

  return $name
}

defmethod Menu addItem {args} {

  args	text action {textfont bold}

  $self! add command -label $text \
	-command [$self buildAction $action] \
	-font [Font slot $textfont]
  return $self
}

defmethod Menu addSubmenu {args} {

  args	text submenu {textfont bold}

  $self! add cascade -label $text -accelerator "=>" -menu $submenu \
	-font [Font slot $textfont]
  return $self
}

defmethod Menu addSeparator {args} {

  args	

  $self! add separator
  return $self
}

defmethod Menu addOptions {args} {

  args	list {textfont bold} variable action

  if { [streq $variable ""] } {
    set variable option
  }

  foreach text $list {
    $self! add radiobutton \
	-command [concat [$self buildAction $action] [list $text]] \
	-font [Font slot $textfont] \
	-label $text \
	-variable $variable
  }
}

defmethod Menu bindings {} {

  bind $self <2> {
    set system(_x) %x
    set system(_y) %y
  }
  bind $self <B2-Motion> {
    if { $system(_posted) != {} } {
      %W _post [expr %X-$system(_x)] [expr %Y-$system(_y)]
    }
  }
  bind $self <B2-Leave> {}
  bind $self <B2-Enter> {}

  bind $self <Escape> {tk_mbUnpost}
  bind $self <Left> {tk_nextMenu -1}
  bind $self <Right> {tk_nextMenu 1}
  bind $self <Up> {tk_nextMenuEntry -1}
  bind $self <Down> {tk_nextMenuEntry 1}
  bind $self <Return> {tk_invokeMenu %W}
}

#---------------------------------------------------------------------------

set system(_inMenu) {}
set system(_posted) {}

defmethod Menu _post {x y {grabp 1}} {
  global system

  set system(_inMenu) $self
  set system(_posted) $self
  set system(_x) $x
  set system(_y) $y
  $self! post $x $y
  $self! activate @$y
  if { $grabp } {
    $self grab
  }
}

defmethod Menu _unpost {} {
  global system

  set system(_inMenu) {}
  set system(_posted) {}
  $self ungrab
  $self! unpost

  set parent [$self slot _parent]
  if { $parent != {} } {
    $parent _unpost
  }
}

defmethod Menu _enter {y} {
  global system

  set system(_inMenu) $self
  $self! activate $y
}

defmethod Menu _leave {} {
  global system

  set system(_inMenu) {}
  $self! activate none
}

defmethod Menu _motion {y} {
  global system

  if { $system(_inMenu) != {} } {
    $self! activate $y
  }
}

defmethod Menu _invoke {} {
  global system

  if { $system(_inMenu) == "" } {
    set i "none"
  } {
    set i [$self! index active]
  }
  $self _unpost
  update idletasks

  set system(_inMenuButton) {}
  set system(_button) {}

  if { $i != "none" } {
    $self! invoke $i
  }
}

#---------------------------------------------------------------------------

defwidget Popup Menu

## proc new(popup) {name}
##	Create a new popup menu attached to "name".
##
defmethod Popup new {name args} {

  args	parent

  Menu new $name
  defsuper $name Popup

  if { $parent == {} } {
    set $parent [winfo parent $name]
  }

  bind $parent <3> [list $name _post %X %Y]

  return $name
}
