
#---------------------------------------------------------------------------
#
#	File: the-env.tcl
#
#---------------------------------------------------------------------------
#

global env system

# var system(printer)
#	The name of the default printer.
#
if { [info exists env(PRINTER)] } {
  set system(printer)	$env(PRINTER)
} {
  set system(printer)	"lp"
}

# var system(papersize)
#	The preferred papersize for printing.
#
if { [info exists env(PAPERSIZE)] } {
  set system(papersize)	$env(PAPERSIZE)
} {
  set system(papersize)	"A4"
}
set system(papersizes)	{
	{A4 16.0 25.0}
	{A3 24.6 35.0}
	{Letter 18.0 20.0}
	}

#---------------------------------------------------------------------------
#
#	The full name of the given user or the argument (if there is
#	no such user in the password file.
#
defmethod env fullname {{user ""}} {
  global env

  if { $user == "" } {
    set user $env(USER)
  }

  set fp [open /etc/passwd r]
  while { [gets $fp line] > -1 } {
    set list [split $line ":"]
    if { [lindex $list 0] == $user && [lindex $list 4] != {} } {
      set user [lindex $list 4]
      break
    }
  }
  close $fp
  return $user
}

# var system(user)
#	The full name of the user this process runs under.
#
set system(user) [env fullname]

#---------------------------------------------------------------------------
#
#	Select a printer for all further output operations
#
#---------------------------------------------------------------------------

#	Allow the user to select amoung various alternatives for a given
#	system resource "what". "what" may be one of "printer" (the default
#	printer).
#	-action - An action invoked on the new system resource when set.
#
defmethod env printer {what args} {
  global system

  case $what in {
  {get} {
      return $system(printer)
    }
  {set} {
      set system(printer) [lindex $args 0]
      return
    }
  {_set} {
      set system(printer) [lindex $args 1]
      set action [lindex $args 0]
      if { $action != {} } {
	eval [concat $action [list $system(printer)]]
      }
      return
    }
  {select} {
      args	action

      Selector new * \
	-layout		center \
	-title		"Available Printers" \
	-initmethod	list \
	-init		[app(getoutput) "[the(command) printers]"] \
	-actions	[list	{Help {} Library/printers} \
				[list Select {} env printer _set $action] \
			]
    }
  }
}

#---------------------------------------------------------------------------
#
#	Select a paper size for all further output operations
#
#---------------------------------------------------------------------------

#	-action - An action invoked on the new system resource when set.
#
defmethod env papersize {what args} {
  global system

  case $what in {
  {get} {
      return $system(papersize)
    }
  {set} {
      set system(papersize) [lindex $args 0]
      return
    }
  {_set} {
      set system(papersize) [lindex $args 1]
      set action [lindex $args 0]
      if { $action != {} } {
	eval [concat $action [list $system(papersize)]]
      }
      return
    }
  {select} {
      args	action

      set sizes {}
      foreach i $system(papersizes) {
	lappend sizes [lindex $i 0]
      }

      Selector new * \
	-layout		center \
	-title		"Available Paper Sizes" \
	-initmethod	list \
	-init		$sizes \
	-actions	[list	{Help {} Library/papersizes} \
				[list Select {} env papersize _set $action] \
			]
    }
  }
}

#---------------------------------------------------------------------------

Window addDemo env

defmethod env demo {} {

  env printer select
}
