
#---------------------------------------------------------------------------
#
#	Button Creation
#
#---------------------------------------------------------------------------

defwidget Button Label
defwidget MultiButton Button

defmethod Button new {name args} {

  args	text bitmap action {textfont bold} {width 12} layout symbolic \
	{relief flat} height

  if { $bitmap != {} } then {
    set bd [expr { ($relief == "flat") ? 0 : 3 }]
    button ${name} -bitmap ${bitmap} \
	-borderwidth $bd -relief $relief -command ${action} \
	-foreground [Color slot fg] \
	-background [Color slot bg] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled]
    Button instantiate $name $layout [list [list symbolic $symbolic]]
  } elseif { $height == {} || $height == 1 } {
    button ${name} -text $text -font [Font slot $textfont] \
	-borderwidth 3 -width $width -command ${action} \
	-relief raised \
	-foreground [Color slot fg] \
	-background [Color slot bg,button] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled]
    Button instantiate $name $layout [list [list symbolic $symbolic]]
  } {
    if { $height == 0 } {
      Message new $name -relief raised -text $text \
	-textfont $textfont -layout $layout
      $name configure -justify center -padx 2 -pady 2
    } {
      Textlabel new $name -relief raised -text $text -width $width \
	-height $height -textfont $textfont -layout $layout
      $name configure -padx 0 -pady 0
    }
    foreach i {	<Any-KeyPress> <1> <Double-1> <Triple-1> <B1-Motion> 
		<Shift-1> <Shift-B1-Motion> <2> <B2-Motion> } {
      bind $name $i nil
    }
    $name configure \
	-borderwidth 3 \
	-foreground [Color slot fg] \
	-background [Color slot bg,button]
    defsuper $name MultiButton
    $name slot symbolic $symbolic
    $name slot action $action
  }

  $name bindings

  return $name
}

set system(_relief) flat

defmethod Button get {} {

  lindex [$self! configure -text] 4
}

defmethod Button set {text} {

  $self! configure -text $text
}

defmethod Button _activate {} {
  global system

  if {[lindex [$self! config -state] 4] != "disabled"} {
    $self! config -state active
    set system(button) $self
  }
}

defmethod MultiButton _activate {} {
  global system

  $self! config \
	-background [Color slot bg,active] \
	-foreground [Color slot fg,active]
  set system(button) $self
}

defmethod Button _deactivate {} {
  global system

  set system(button) ""
  if {[lindex [$self! config -state] 4] != "disabled"} {
    $self! config -state normal
  }
  set system(window) ""
}

defmethod MultiButton _deactivate {} {
  global system

  $self! config \
	-background [Color slot bg,button] \
	-foreground [Color slot fg]
  set system(button) $self
}

defmethod Button _down {} {
  global system

  if {[lindex [$self! config -state] 4] != "disabled"} {
    set system(_relief) [lindex [$self! config -relief] 4]
    $self! config -relief sunken
  }
}

defmethod MultiButton _down {} {
  global system

  set system(_relief) [lindex [$self! config -relief] 4]
  $self! config -relief sunken
}

defmethod Button _up {} {
  global system

  $self! config -relief $system(_relief)
  if {	[lindex [$self! config -state] 4] != "disabled" &&
	$system(button) != "" } {
    $self! invoke
  }
}

defmethod MultiButton _up {} {
  global system

  $self! config -relief $system(_relief)
  set action [$self slot action]
  if { $action != {} } {
    uplevel #0 $action
  }
}

defmethod Button bindings {} {

  bind $self <Any-Enter> {%W _activate}
  bind $self <Any-Leave> {%W _deactivate}
  bind $self <1> {%W _down}
  bind $self <ButtonRelease-1> {%W _up}
}

# We can't bind the button up event to a method because Tcl/Tk doesn't like
# the destruction of a parent via Dismiss that way. Dismiss also releases
# the method code, so returns from the Dismiss handler will return into
# nowhere.
#
#bind Button <ButtonRelease-1> {
#  global tk_priv
#
#  %W! config -relief $tk_priv(relief)
#  if { ("%W" == $tk_priv(window))
#	&& ([lindex [%W! config -state] 4] != "disabled")} {
#    %W! invoke
#  }
#}

#---------------------------------------------------------------------------

defwidget Checkbutton Button

defmethod Checkbutton new {name args} {

  args	text bitmap action {textfont bold} {width 12} layout variable \
	symbolic

  set options [list \
	-relief flat \
	-command $action \
	-foreground [Color slot fg] \
	-background [Color slot bg,button] \
	-selector [Color slot fg,active] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled] \
	]

  if { $bitmap == {} } then {
    lappend options \
	-text $text -font [Font slot $textfont] \
	-anchor w -padx 3 -pady 3 \
	-borderwidth 3 -width $width
  } else {
    lappend options \
	-bitmap ${bitmap} \
	-anchor c \
	-borderwidth 0
  }

  if { $variable != {} } {
    lappend options -variable [slot-variable $name $variable]
  } 

  eval [concat [list checkbutton $name] $options]
  Checkbutton instantiate $name $layout [list [list symbolic $symbolic]]

  $name bindings

  return $name
}

#---------------------------------------------------------------------------
#--not complete yet...

defwidget Cyclebutton Button

defmethod Cyclebutton new {name args} {

}

#---------------------------------------------------------------------------
#--not complete yet...

defwidget Radiobutton Button

defmethod Radiobutton new {name args} {

  args	text bitmap action {textfont bold} {width 12} layout variable \
	symbolic

  set options [list \
	-relief flat \
	-command $action \
	-foreground [Color slot fg] \
	-background [Color slot bg,button] \
	-selector [Color slot fg,active] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled] \
	]

  if { [streq $bitmap {}] } then {
    lappend options \
	-text $text -font [Font slot $textfont] \
	-anchor w -padx 3 -pady 3 \
	-borderwidth 3 -width $width
  } else {
    lappend options \
	-bitmap ${bitmap} \
	-anchor c \
	-borderwidth 0
  }

  if { ![streq $variable {}] } {
    lappend options -variable $variable
  } 

  eval [concat [list radiobutton $name] $options]
  Radiobutton instantiate $name $layout [list [list symbolic $symbolic]]

  $name bindings

  return $name
}
