#---------------------------------------------------------------------------
#
#	Application Window Setup
#
#---------------------------------------------------------------------------

global system

wm title	. "$system(system) Toplevel (Version $system(version))"
wm iconposition	. 10 10
wm iconname	. [wm title .]
# wm iconbitmap	. @[the(image) icon-$system(system)]

default system	app		.
default system	geometry	+10+10

defwidget Application

defmethod Application new {name} {
  global system

  set win [anon]
  set system(project)	{}
  set system(application) $name
  set system(app)	$win

  Application clone $name
  $name slot window $win

  wm iconify .

  Toplevel new $win \
	-info true \
	-windowtitle \
	  "$system(system) $system(application) (Version $system(version))" \
	-icon icon-$system(system) \
	-logos application

  Help new $win.message \
	-layout {bottom fillx} -embedded true \
	-help app-help

  $win layout $system(geometry)

  defmethod $name prolog {} {return}
  defmethod $name epilog {} {return}
  load(app) application
  set status [app(send) "(:application |$name|)"]

  if { $status != {} } {
    defmethod $name prolog {} {return}
    defmethod $name epilog {} {return}
    $name Dismiss
    $self Help new [list Library/bad-application $name]
    return
  } {
    $name prolog
  }

  return $name
}

defmethod Application prolog {} {

  return
}

defmethod Application epilog {} {

  return
}

defmethod Application Dismiss {} {
  global system

  if { [$self epilog] == {} } {
    $self restart
    wm deiconify .
    [$self slot window] Dismiss
    set system(application) {}
    $self reclaim
  }
}

#--	send a single string to the application
#
proc app(write) {what} {
  puts stdout "\001${what}\n\002${what}"
  flush stdout
}

#--	send a single string to the application
#	wait for and read acknowledgement
#
proc app(send) {what {arg {}}} {
  global system

  app(write) $what
  set status [app(getstatus)]
  if { $status != {} && $arg != {} } {
    Dialog new * -help [list Library/failed $arg]
  }
  return $status
}

#--	send a single string to the application
#	read a list of items from the application
#	wait for and read acknowledgement
#
proc app(list) {what {arg {}}} {
  global system

  app(write) $what
  set list [app(getlist)]
  set status [app(getstatus)]
  if { $status != {} && $arg != {} } {
    set list {}
    Dialog new * -help [list Library/failed $arg]
  }
  return $list
}

proc app(item) {what {arg {}}} {
  global system

  app(write) $what
  set item [app(getitem)]
  set status [app(getstatus)]
  if { $status != {} && $arg != {} } {
    set item {}
    Dialog new * -help [list Library/failed $arg]
    return
  }
  return $item
}

proc app(expr) {what {arg {}}} {
  global system

  app(write) $what
  set item [app(getexpr)]
  set status [app(getstatus)]
  if { $status != {} && $arg != {} } {
    set item {}
    Dialog new * -help [list Library/failed $arg]
    return
  }
  return $item
}

defmethod Application restart {} {
  puts stdout "\005"
  flush stdout
}

#---------------------------------------------------------------------------
#
#	Exchange spaces for underlines and vice versa
#
#---------------------------------------------------------------------------

proc space(replace) {string} {
  set result $string
  regsub -all " " $string "_" result
  return $result
}

proc space(restore) {string} {
  set result $string
  regsub -all "_" $string " " result
  return $result
}

#---------------------------------------------------------------------------
#
#	Read a list from a file
#
#---------------------------------------------------------------------------

proc app(getitem) {{f stdin}} {
  if {[gets $f line] == -1} {
    return {}
  }
  return [space(restore) $line]
}

proc app(getlist) {{f stdin}} {
  set items {}
  while {1} {
    if {[gets $f line] == -1} {
      return {}
    }
    if { $line == "META begin" } {
      break;
    }
  }
  while {1} {
    if {[gets $f line] == -1} {
      break;
    }
    if { $line == "META end" } {
      break;
    }
    eval "lappend items {[space(restore) ${line}]}"
  }
  return $items
}

proc app(getexpr) {{f stdin}} {
  set items {}
  while {1} {
    if {[gets $f line] == -1} {
      return {}
    }
    if { $line == "META begin" } {
      break;
    }
  }
  while {1} {
    if {[gets $f line] == -1} {
      break;
    }
    if { $line == "META end" } {
      break;
    }
    append items "\n" [space(restore) ${line}]
  }
  return $items
}

proc app(get) {init initargs {sortp {}}} {
  case $init in {
  {form} {
	set list [uplevel #0 $initargs]
    }
  {expr} {
	set list [app(expr) $initargs]
    }
  {list} {
	set list $initargs
    }
  {file} {
	set list [app(getlines) $initargs]
    }
  {command} {
	set list [app(getoutput) $initargs]
    }
  {application} {
	set list [app(list) $initargs]
    }
  default {
	set list {}
    }
  }

  if { $sortp == {} } {
    return $list
  } {
    return [lsort $list]
  }
}

proc app(getoutput) {command} {
  app(getlines) "| $command"
}

proc app(getlines) {command} {
  set items {}
  set fp [open "$command"]
  while { [gets $fp line] > -1 } {
    lappend items $line
  }
  close $fp
  return $items
}

proc app(getfile) {command} {
  set items ""
  set fp [open "$command"]
  while { [gets $fp line] > -1 } {
    append items $line "\n"
  }
  close $fp
  return $items
}

proc app(getstatus) {{f stdin}} {
  set line {}
  while {1} {
    if {[gets $f line] == -1} {
      return "eof"
    }
    if { $line == "META success" } {
      return {}
    }
    if { $line == "META failure" } {
      return "failed"
    }
  }
}

set system(synccount) 0

proc synchronize {{f stdin}} {
  global system

  set id [incr system(synccount)]

  $self write "(:sync $id)"

  set line {}
  while {1} {
    if {[gets $f line] == -1} {
      return "eof"
    }
    if { $line == "META sync $id" } {
      return {}
    }
  }
}
