#
# stripchart.t, an example tclVogle script which implments a strip chart
# graphic
#

proc legendObject {title} {
    g_makeobj [set obj [g_genobj]]
      g_pushmatrix
	g_font small
	# to keep vogle from scaling the text
	g_viewport -100 100 -100 100
	g_move -0.01 -0.0097
        g_drawstr $title
      g_popmatrix
    g_closeobj
    return $obj
}

set NIL ","

proc stripchartObject {objID data {minVal ""} {maxVal ""}} {
    global NIL

    # if not supplied, determine the range to use for the y axis
    if {$minVal=="" || $maxVal==""} {
	set minVal [set maxVal 0.0]
	foreach p $data {
	    if {$p=="$NIL"} {continue}
	    if {$p<$minVal} {set minVal $p}
	    if {$p>$maxVal} {set maxVal $p}
	}
    }

    if {[set yScale [expr $maxVal-$minVal]]==0.0} {
	set yScale 1.0
    } else {
	set yScale [expr 1.0/$yScale]
    }
    set xScale [expr 1.0/([llength $data]-1)]

    # build an object out of the data points

    if {$objID != "-"} { g_makeobj $objID }
    g_pushmatrix
	g_translate -1.0 -1.0
	g_scale [expr 2*$xScale] [expr 2*$yScale]
	g_translate .0 [expr .0-$minVal]
	g_move 0 0
	set x 0
	foreach p $data {
	    if {$p!="$NIL"} {
		g_draw $x $p
		incr x
	    }
	}
    g_popmatrix
    if {$objID != "-"} { g_closeobj }
    return $objID
}
