\documentstyle{article}
\begin{document}
\title{Notes on implementing a {\sc vogle} driver}
\author{Mike Hoegeman}
\date{}
\maketitle

\parindent 0pt
\parskip 6pt

\section{X11 based drivers}

\subsection{The init driver function}

    The vogle library depends on the driver to initialize the color
    attribute {\bf vdevice.attr->color}. Otherwise it is garbage.  If
    this initialization is not done it wreaks havoc in cases like the
    example below

\begin{verbatim}
	# tclvogle script
	proc doit {} {
	    g_pushattributes
	    g_color black
	    g_clear
	    g_popattributes; # yow! now the current color is garbage
	    g_clear
	}
	graphic .top -geometry 100x100 -command {doit}
	pack append . .top {top fill expand}
\end{verbatim}

\subsection{Using XSync()}

    If you are basing a vogle driver off the sample X11.c driver
    supplied in the vogle package note that {\bf XSync()} is called in
    some of the {\tt X11.c} driver funtions.

    Care must be taken when using {\bf XSync()}. {\bf XSync()}
    allocates X resources into your clients event queue.  If you are
    not processing any events this will lead to your clients event
    queue getting backed up with more and more events. Eventually, all
    all memory will be exhausted.

    An example which demonstrates this behavior is in the examples/cube
    demo when using the sample X11.c driver.

\end{document}
