/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* File: ipcHandles.h
 *      This is public interface to the routines that manage the 
 *      ipc handle table.
 *
 * Created: K. Gillies 26 June 1992
 * SCCS INFO
 *      @(#)ipcHandles.h	1.1 9/11/92
 */

/* Structures for the handle table and its entry contents */

#define ENTRYNAMESIZE 32                 /* Names are limited! */
typedef struct _sendTableEntryRecord {
  char s_hostname[ENTRYNAMESIZE];
  char s_program[ENTRYNAMESIZE];
  Sender s_sender;                       /* A sender _or_ receiver */
  Receiver s_receiver;                   /* will be non-NULL */
} sendTableEntryRecord, *sendTableEntry;

/* Public functions */
/* Initialize the handle table */
void ipcHandleTableInit _ANSI_ARGS_((int commandcount));

/* Add a handle table entry */
char *ipcHandleAddEntry _ANSI_ARGS_((Sender sender, Receiver receiver,
  		        char *hostname, char *program));

/* Remove and destroy the entry for handleName */
int ipcHandleDestroy _ANSI_ARGS_((Tcl_Interp *interp, char *handleName));

/* Fetch the table entry that goes with handleName */
sendTableEntry ipcHandleGet _ANSI_ARGS_((Tcl_Interp *interp, 
					 char *handleName));

/* Return a pointer to the interpreter that goes with port portIn */
int tclipcGetInterp _ANSI_ARGS_((int portIn, Tcl_Interp **interp));

/* Dump the ipc handle table */
int ipcHandleDump _ANSI_ARGS_((Tcl_Interp *interp));
