/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* file: cmdsend.c
 *      This file contains the send a command function.
 *      There is an ANSI C version and a standard C version (as far as
 *      I can tell).
 *
 * Created: K. Gillies 26 June 1992
 * SCCS INFO
 *      @(#)cmdsend.c	1.1 9/11/92
 *
 */
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#if defined (__STDC__)
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include "tcl.h"
#include "tclIPC.h"
#include "tclipcP.h"
#include "tclipc.h"

/* This arbitrary--could be bigger! */
#define SENDBUFFERSIZE 1024

/* The command send buffer */
static char cmdbuffer[SENDBUFFERSIZE];
/* A static command so it isn't always being malloc'ed */
static cmdType cmd = { 0, cmdbuffer };

/*
 *--------------------------------------------------------------
 *
 * ipcRemoteSend (ANSI-C version)
 *
 *      Format the command and send it to the specified
 *      Sender destination.
 *
 * Results:
 *      TCL_ERROR or TCL_OK  result is set in interp->result
 *--------------------------------------------------------------
 */
#if defined(__STDC__)
int ipcRemoteSend(Sender sender, const char *fmt, ...) 
{
  static evalcmd_res *result = NULL;
  int sresult;
  va_list args;

  /* Format the command string */
  va_start(args, fmt);
  vsprintf(cmd.cmd, fmt, args);
  va_end(args);
#else
int ipcRemoteSend(sender, fmt, va_alist) 
Sender sender;
char *fmt;
va_dcl
{
  static evalcmd_res *result = NULL;
  int sresult;
  va_list args; 

  /* Format the command */
  va_start(args);
  vsprintf(cmd.cmd, fmt, args);
  va_end(args);
#endif

  /* ------- Here starts the common code ------- */
  if (result != NULL && result->text != NULL) {
#ifdef DEBUG
    fprintf(stderr, "Freeing\n");
#endif
    xdr_free(xdr_evalcmd_res, result);
  } 
#ifdef DEBUG
else fprintf(stderr, "Not freeing\n");
#endif

  /* Save the destination port for de-multiplexing */
  cmd.destinationPort = sender->portNumber;
#ifdef DEBUG  
  fprintf(stderr, "Send to port: %d\n", cmd.destinationPort);
  fprintf(stderr, "Send to text: %s\n", cmd.cmd);
#endif
  if (sender->localReceiver != NULL) {
    /* Set result to Null so I don't free the result next time */

    result = NULL; 
    /* Check to see if source and destination interpreter are the same */
    if (sender->localReceiver->interp == sender->interp) {
      /* They are the same so do simple eval */
      sresult = Tcl_GlobalEval(sender->interp, cmd.cmd);
    } else {
      char *oldResultString;
      Tcl_FreeProc *oldFreeProc;
      Tcl_Interp *rInterp;

      /* They are not the same so do simple eval */
      rInterp = sender->localReceiver->interp;
      oldResultString = rInterp->result;
      oldFreeProc = rInterp->freeProc;
      rInterp->freeProc = 0;
      sresult = Tcl_GlobalEval(rInterp, cmd.cmd);
      if (rInterp->freeProc != 0) {
        Tcl_SetResult(sender->interp, rInterp->result,
                      rInterp->freeProc);
      } else {
        Tcl_SetResult(sender->interp, rInterp->result, TCL_VOLATILE);
      }
      rInterp->result = oldResultString;
      rInterp->freeProc = oldFreeProc;
    }
  } else {
    /* It isn't local so send it */
    if ((result = cmdsend_4(&cmd, sender->clientPtr)) == NULL) {
      sresult = TCL_ERROR;
    } else {
      /* Set the result.  It will be free'ed next time here */
      /* Tell TCL it's static because it belongs to RPC lib */
      Tcl_SetResult(sender->interp, result->text, TCL_STATIC);
      sresult = result->errno;
    }
  }
  return sresult;
}
