# 
# This init file redefines the "unknown" command so that
# it will use pattern-matching like that of Xt for commands.
# This allows use of shorter widget names e.g. *myBtn
# Commands that are not abbreviations this way are passed
# onto the old unknown. To allow for a stack of "unknown"
# commands, unknowns are relabelled unknown.old, unknown.old.old, etc
#

global tclMotif_unknown

set tclMotif_unknown "unknown"

while {[info commands $tclMotif_unknown] != ""} {
    set tclMotif_unknown $tclMotif_unknown.old
}

rename unknown $tclMotif_unknown

proc unknown {name args} {
    global tclMotif_unknown

    set cmds [info commands $name]
    set len [llength $cmds]
    if {$len == 0} {
	# no match, pass to old unknown
	set cmd "uplevel 1 $tclMotif_unknown $name $args"
	eval $cmd
    }
    if {$len > 1} {
	error "non-unique command \"$name\" matches \"$cmds\""
    }

    # unique abbreviation:
    return [uplevel $cmds $args]
}
