/*
 * tmSubResources.c --
 *	This module implements the interface to the
 *	subresources of widgets such as Text.
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <Xm/BaseClassP.h>
#ifdef DEBUG_MALLOC
#include <dbmalloc.h>
#endif

/*
 *--------------------------------------------------------------
 *
 * Tm_GetSecondaryResources --
 *
 *	Get the list of secondary resources from a widget class
 *
 * Results:
 *
 *	returns the list and number in "sub_resources" and
 *	"num_sub_resources"
 *
 * Side effects:
 *
 *	none
 *--------------------------------------------------------------
 */

void
Tm_GetSecondaryResources(class, sub_resources, num_sub_resources)
    WidgetClass class;
    XmSecondaryResourceData **sub_resources;
    Cardinal *num_sub_resources;
{
    XtPointer extension;
    XtResourceList rl;


    *num_sub_resources = 
	((XmBaseClassExtRec *) extension)->getSecResData(class, sub_resources);
}
