/*
 * tmExpand.c --
 *	This module handles % expansions of callback data
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "tm.h"

#include <Xm/ArrowB.h>
#include <Xm/Command.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#ifndef MOTIF11
#include <Xm/DragDrop.h>
#endif

/*
 *--------------------------------------------------------------
 *
 * getValue --
 *
 *	Get the value of a field from out of the callback data.
 *
 * Results:
 *
 *	places the string value in "value"
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static char *
getValue(pathName, w, event, call_data, value, length)
    char *pathName;
    Widget w;
    XEvent *event;
    XtPointer call_data;
    char *value;
    int length;
{
    char *result;
    XrmValue from, to;
    static char buf[32];
    WidgetClass class;

    if (length == strlen("w") &&
	    strncmp(value, "w", length) == 0) {
	return pathName;
    }

    if (length == strlen("dragContext") &&
	    strncmp(value, "dragContext", length) == 0) {
	return pathName;
    }

    if (length == strlen("event") &&
	    strncmp(value, "event", length) == 0) {
	sprintf(buf, "event-%lu", (long) event);
	return buf;
    }

    /* the reasons are widget specific, but get them over with at
       the start all at once anyway since they overlap a lot
     */
    if (length == strlen("reason") &&
	    strncmp(value, "reason", length) == 0) {
	XmAnyCallbackStruct *c_data = (XmAnyCallbackStruct *) call_data;

	switch (c_data->reason) {
	    case XmCR_NONE:			return "none";
	    case XmCR_HELP:			return "help";
	    case XmCR_VALUE_CHANGED:		return "value_changed";
	    case XmCR_INCREMENT:		return "increment";
	    case XmCR_DECREMENT:		return "decrement";
	    case XmCR_PAGE_INCREMENT:		return "page_increment";
	    case XmCR_PAGE_DECREMENT:		return "page_decrement";
	    case XmCR_TO_TOP:			return "to_top";
	    case XmCR_TO_BOTTOM:		return "to_bottom";
	    case XmCR_DRAG:			return "drag";
	    case XmCR_ACTIVATE:			return "activate";
	    case XmCR_ARM:			return "arm";
	    case XmCR_DISARM:			return "disarm";
	    case XmCR_MAP:			return "map";
	    case XmCR_UNMAP:			return "unmap";
	    case XmCR_FOCUS:			return "focus";
	    case XmCR_LOSING_FOCUS:		return "losing_focus";
	    case XmCR_MODIFYING_TEXT_VALUE:	return "modifying_text_value";
	    case XmCR_MOVING_INSERT_CURSOR:	return "moving_insert_cursor";
	    case XmCR_EXECUTE:			return "execute";
	    case XmCR_SINGLE_SELECT:		return "single_select";
	    case XmCR_MULTIPLE_SELECT:		return "multiple_select";
	    case XmCR_EXTENDED_SELECT:		return "extended_select";
	    case XmCR_BROWSE_SELECT:		return "browse_select";
	    case XmCR_DEFAULT_ACTION:		return "default_action";
	    case XmCR_CLIPBOARD_DATA_REQUEST:	return "clipboard_data_request";
	    case XmCR_CLIPBOARD_DATA_DELETE:	return "clipboard_data_delete";
	    case XmCR_CASCADING:		return "cascading";
	    case XmCR_OK:			return "ok";
	    case XmCR_CANCEL:			return "cancel";
	    case XmCR_APPLY:			return "apply";
	    case XmCR_NO_MATCH:			return "no_match";
	    case XmCR_COMMAND_ENTERED:		return "command_entered";
	    case XmCR_COMMAND_CHANGED:		return "command_changed";
	    case XmCR_EXPOSE:			return "expose";
	    case XmCR_RESIZE:			return "resize";
	    case XmCR_INPUT:			return "input";
	    case XmCR_GAIN_PRIMARY:		return "gain_primary";
	    case XmCR_LOSE_PRIMARY:		return "lose_primary";
	    case XmCR_CREATE:			return "create";
	    case XmCR_TEAR_OFF_ACTIVATE:	return "tear_off_activate";
	    case XmCR_TEAR_OFF_DEACTIVATE:	return "tear_off_deactivate";
	    case XmCR_OBSCURED_TRAVERSAL:	return "obscured_traversal";
	    default: 				return "none";
	}
    }

    class = XtClass(w);
    if (XtIsSubclass(w, xmArrowButtonWidgetClass)) {
	XmArrowButtonCallbackStruct *c_data = (XmArrowButtonCallbackStruct *) call_data;

	if (length == strlen("click_count") &&
		strncmp(value, "click_count", length) == 0) {
	    sprintf(buf, "%d", c_data->click_count);
	    return buf;
	} else {
	    return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmCommandWidgetClass)) {
	XmCommandCallbackStruct *c_data = (XmCommandCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    XmStringGetLtoR(c_data->value, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
/*
	    from.addr = c_data->value;
	    from.size = sizeof(XmString);
	    to.addr = NULL;
	    Tm_CvtXmStringToString(NULL, NULL, 0, &from, &to, NULL);
	    return *(char **)to.addr;
*/
	} else
	if (length == strlen("length") &&
		strncmp(value, "length", length) == 0) {
	    sprintf(buf, "%d", c_data->length);
	    return buf;
	} else {
	    return "ERROR in substitution";
	}
    } else

#ifndef MOTIF11
    if (XtIsSubclass(w, xmDragContextClass)) {
	if (length == strlen("type") &&
		strncmp(value, "type", length) == 0) {
	    return TM_CONVERT_TYPE;
	} else
	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    return TM_CONVERT_VALUE;
	} else {
	    return "ERROR in substitution";
	}	
    } else
#endif

    if (XtIsSubclass(w, xmDrawnButtonWidgetClass)) {
	XmDrawnButtonCallbackStruct *c_data = (XmDrawnButtonCallbackStruct *) call_data;

	if (length == strlen("click_count") &&
		strncmp(value, "click_count", length) == 0) {
	    sprintf(buf, "%d", c_data->click_count);
	    return buf;
	} else {
	    return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmFileSelectionBoxWidgetClass)) {
	XmFileSelectionBoxCallbackStruct *c_data =
			(XmFileSelectionBoxCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    XmStringGetLtoR(c_data->value, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("length") &&
		strncmp(value, "length", length) == 0) {
	    sprintf(buf, "%d", c_data->length);
	    return buf;
	} else
	if (length == strlen("mask") &&
		strncmp(value, "mask", length) == 0) {
	    XmStringGetLtoR(c_data->mask, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("mask_length") &&
		strncmp(value, "mask_length", length) == 0) {
	    sprintf(buf, "%d", c_data->mask_length);
	    return buf;
	} else
	if (length == strlen("dir") &&
		strncmp(value, "dir", length) == 0) {
	    XmStringGetLtoR(c_data->dir, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("dir_length") &&
		strncmp(value, "dir_length", length) == 0) {
	    sprintf(buf, "%d", c_data->dir_length);
	    return buf;
	} else
	if (length == strlen("pattern") &&
		strncmp(value, "pattern", length) == 0) {
	    XmStringGetLtoR(c_data->pattern, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("pattern_length") &&
		strncmp(value, "pattern_length", length) == 0) {
	    sprintf(buf, "%d", c_data->pattern_length);
	    return buf;
	} else {
	    return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmListWidgetClass)) {
	XmListCallbackStruct *c_data = (XmListCallbackStruct *) call_data;

	if (length == strlen("item") &&
		strncmp(value, "item",length) == 0) {
            XmStringGetLtoR(c_data->item, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("item_length") &&
		strncmp(value, "item_length", length) == 0) {
	    sprintf(buf, "%d", c_data->item_length);
	    return buf;
	} else
	if (length == strlen("item_position") &&
		strncmp(value, "item_position", length) == 0) {
	    sprintf(buf, "%d", c_data->item_position);
	    return buf;
	} else
	if (length == strlen("selected_items") &&
		strncmp(value, "selected_items", length) == 0) {
	    if (c_data->reason == XmCR_MULTIPLE_SELECT ||
	    	c_data->reason == XmCR_EXTENDED_SELECT) {
		String *items;
		static String items_list = NULL;
		static int items_list_len = 0;
		int n, len;
		char *p, *end;

		items = (char **) XtMalloc(sizeof(char *) *
					c_data->selected_item_count);
		len= 0;
		for (n = 0; n < c_data->selected_item_count; n++) {
		    XmStringGetLtoR(c_data->selected_items[n],
					XmFONTLIST_DEFAULT_TAG, items + n);
		    len += strlen(items[n]) + 2; /* for , */
		}

		/* reuse the static space we malloc for this list */
		if (items_list == NULL) {
		    items_list = XtMalloc(len + 1); /* we overshoot by 1 */
		    items_list_len = len + 1;
		} else
		if (items_list_len < len) {
		   items_list = XtRealloc(items_list, len + 1);
		   items_list_len = len + 1;
		}

		if (len == 0) {
		    *items_list = '\0';
		    return items_list;
		}
#ifdef TM_MOTIF_XMSTRINGTABLE
		end = items_list;
		for (n = 0; n < c_data->selected_item_count; n++) {
		    p = items[n];
		    while (*end++ = *p++)
			;
		    *(end - 1) = ',';
		    *end++ = ' ';
		    XtFree(items[n]);
		}
		*(end - 2) = '\0';
#else
		items_list = Tcl_Merge(c_data->selected_item_count, items);
                for (n = 0; n < c_data->selected_item_count; n++) {
                    XtFree(items[n]);
                }
#endif
		XtFree((char *) items);
		return items_list;
	    }
	} else
	if (length == strlen("selection_type") &&
		strncmp(value, "selection_type", length) == 0) {
	    switch (c_data->selection_type) {
		case XmINITIAL:		return "initial";
		case XmMODIFICATION:	return "modification";
		case XmADDITION:	return "addition";
		default:		return "ERROR!";
	    }
	} else
	if (length == strlen("selected_item_count") &&
		strncmp(value, "selected_item_count", length) == 0) {
	    sprintf(buf, "%d", c_data->selected_item_count);
	    return buf;
	} else {
	    return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmPushButtonWidgetClass)) {
        XmPushButtonCallbackStruct *c_data = (XmPushButtonCallbackStruct *) call_data;

        if (length == strlen("click_count") &&
                strncmp(value, "click_count", length) == 0) {
            sprintf(buf, "%d", c_data->click_count);
            return buf;
        } else {
            return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmScaleWidgetClass)) {
	XmScaleCallbackStruct *c_data = (XmScaleCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    sprintf(buf, "%d", c_data->value);
	    return buf;
	} else {
	    return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmScrollBarWidgetClass)) {
	XmScrollBarCallbackStruct *c_data = (XmScrollBarCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    sprintf(buf, "%d", c_data->value);
	    return buf;
	} else {
	    return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmTextWidgetClass)) {
	XmTextVerifyCallbackStruct *c_data =
			(XmTextVerifyCallbackStruct *) call_data;

	if (length == strlen("doit") &&
		strncmp(value, "doit", length) == 0) {
		return TM_TEXT_DOIT;
	} else
	if (length == strlen("currInsert") &&
		strncmp(value, "currInsert", length) == 0) {
	    sprintf(buf, "%d", c_data->currInsert);
	    return buf;
	} else
	if (length == strlen("newInsert") &&
		strncmp(value, "newInsert", length) == 0) {
	    sprintf(buf, "%d", c_data->newInsert);
	    return buf;
	} else
	if (length == strlen("startPos") &&
		strncmp(value, "startPos", length) == 0) {
		return TM_TEXT_STARTPOS;
	} else
	if (length == strlen("endPos") &&
		strncmp(value, "endPos", length) == 0) {
		return TM_TEXT_ENDPOS;
	} else
	if (length == strlen("ptr") &&
		strncmp(value, "ptr", length) == 0) {
		return TM_TEXT_PTR;
	} else
	if (length == strlen("length") &&
		strncmp(value, "length", length) == 0) {
		return TM_TEXT_LENGTH;
	} else {
	    return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmSelectionBoxWidgetClass)) {
	XmSelectionBoxCallbackStruct *c_data =
			(XmSelectionBoxCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value",length) == 0) {
	    XmStringGetLtoR(c_data->value, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("length") &&
		strncmp(value, "length", length) == 0) {
	    sprintf(buf, "%d", c_data->length);
	    return buf;
	} else {
	    return "ERROR in substitution";
	}
    } else

    if (XtIsSubclass(w, xmToggleButtonWidgetClass)) {
	XmToggleButtonCallbackStruct *c_data =
			(XmToggleButtonCallbackStruct *) call_data;

	if (length == strlen("set") &&
		strncmp(value, "set", length) == 0) {
	    if (c_data->set) {
		return "true";
	    } else {
		return "false";
	    }
	} else {
	    return "ERROR in substitution";
	}
    } else
#ifndef MOTIF11
    if (XtIsSubclass(w, xmDropTransferObjectClass)) {
	Tm_TransferStruct *c_data =
			(Tm_TransferStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    return c_data->value;
	} else
	if (length == strlen("closure") &&
	 	strncmp(value, "closure", length) == 0) {
	    return c_data->closure;
	} else {
	    return "ERROR in substitution";
	}
    }
#endif
    return "ERROR in substitution";
}


/*
 *--------------------------------------------------------------
 *
 * addChars --
 *
 *	add a list of characters to a string.
 *	grows space if neccessary
 *
 * Results:
 *
 *	"from" as appended to "after"
 *
 * Side effects:
 *
 *	may reallocate memory
 *--------------------------------------------------------------
 */

static char *
addChars(after, afterSize, end, spaceLeft, fromSize, from)
    char *after;
    int *afterSize;
    char **end;
    int *spaceLeft;
    int fromSize;
    char *from;
{
    char *newSpace;
    int extra;

    if (*spaceLeft < fromSize) {
	if (fromSize > *afterSize) {
	    extra = fromSize + 50;
	} else {
	    extra = *afterSize;
	}
	newSpace = XtRealloc(after, *afterSize + extra);
	*spaceLeft += extra;
	*afterSize += extra;
	*end = newSpace + (*end - after);
	after = newSpace;
    }
    *spaceLeft -= fromSize;

    while (fromSize) {
	**end = *from;
	from++;
	(*end)++;
	fromSize--;
    }
    return after;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_ExpandPercents --
 *
 *	expand out the %field in patterns by their callback values
 *
 * Results:
 *
 *	A new string with the expansions is returned
 * Side effects:
 *
 *	none.
 *--------------------------------------------------------------
 */

char *
Tm_ExpandPercents(pathName, w, event, call_data, before)
    char *pathName;
    Widget w;
    XEvent *event;
    XtPointer call_data;
    char *before;
{
    char *after, *end;
    char *value;
#   define TM_STR_SIZE 128
    int afterSize = TM_STR_SIZE;
    int spaceLeft = TM_STR_SIZE;
    int wordSize;

    if (strchr(before, '%') == NULL) {
	after = XtNewString(before);
	return after;
    }

    end = after = XtMalloc(TM_STR_SIZE);

    while (*before != 0) {
	if (*before != '%') {
	    after = addChars(after, &afterSize, &end, &spaceLeft, 1, before);
	    before++;
	} else {
	    before++;
	    wordSize = 0;
	    while (isalpha(before[wordSize]) || before[wordSize] == '_') {
		wordSize++;
	    }
	    if (wordSize == 0) {
	        after = addChars(after, &afterSize, &end, &spaceLeft, 1, "%");
	    } else {
		value = getValue(pathName, w,
				event, call_data, before, wordSize);
		after = addChars(after, &afterSize, &end, &spaceLeft,
				 strlen(value), value);
		before += wordSize;
	    }
	}
    }
    *end = '\0';

    return after;
}
