/*
 * A Motif program to write a list of all interpreters registered,
 * using the "interps" commands.
 */

#include <stdio.h>
#include <Xm/Label.h>
#include "../tclXtSend.h"

int
main(argc, argv)
    int argc;
    char **argv;
{
    Widget toplevel;
    Widget rc;
    Widget button;
    Widget label;
    Tcl_Interp *interp1, *interp2, *interp3;
    XtAppContext app;

    toplevel = XtAppInitialize(&app, "XmSend", NULL, 0, &argc, argv,
				NULL, NULL, 0);

    interp1 = Tcl_CreateInterp();
    interp2 = Tcl_CreateInterp();
    interp3 = Tcl_CreateInterp();

    if (TclXtSend_RegisterInterp(interp1, "xmSend6.1", toplevel) == TCL_ERROR) {
	fprintf(stderr, "couldn't register interpreter 6.1\n");
	exit(1);
    }

    if (TclXtSend_RegisterInterp(interp2, "xmSend6.2", toplevel) == TCL_ERROR) {
	fprintf(stderr, "couldn't register interpreter 6.2\n");
	exit(1);
    }

    if (TclXtSend_RegisterInterp(interp3, "xmSend6.3", toplevel) == TCL_ERROR) {
	fprintf(stderr, "couldn't register interpreter 6.3\n");
	exit(1);
    }


    label = XmCreateLabel(toplevel, "a label", NULL, 0);
    XtManageChild(label);

    XtRealizeWidget(toplevel);

    /*
     * list interps running:
     */
    if (Tcl_Eval(interp1, "puts stdout [interps]") != TCL_OK)
	fprintf(stderr, "Error in interps: %s\n", interp1->result);

    XtAppMainLoop(app);
}
