*** tk3.2-jp.OLD/tk.h	Wed Jan 12 14:27:35 1994
--- tk3.2-jp.NEW/tk.h	Wed Jan 12 14:45:35 1994
***************
*** 172,182 ****
  #define TK_CONFIG_MM		19
  #define TK_CONFIG_WINDOW	20
  #define TK_CONFIG_CUSTOM	21
  #ifdef KANJI
! #define TK_CONFIG_WSTRING	22
! #define TK_CONFIG_END		23
  #else
! #define TK_CONFIG_END		22
  #endif /* KANJI */
  
  /*
--- 172,183 ----
  #define TK_CONFIG_MM		19
  #define TK_CONFIG_WINDOW	20
  #define TK_CONFIG_CUSTOM	21
+ #define TK_CONFIG_PIXMAP	22
  #ifdef KANJI
! #define TK_CONFIG_WSTRING	23
! #define TK_CONFIG_END		24
  #else
! #define TK_CONFIG_END		23
  #endif /* KANJI */
  
  /*
***************
*** 500,505 ****
--- 501,511 ----
  			    unsigned int height));
  extern void		Tk_DefineCursor _ANSI_ARGS_((Tk_Window window,
  			    Cursor cursor));
+ extern int		Tk_DefinePixmap _ANSI_ARGS_((Tcl_Interp *interp,
+ 			    Tk_Uid name, Tk_Window tkwin, Pixmap pixmap,
+ 			    Pixmap clipMask, char *source,
+ 			    unsigned int width, unsigned int height,
+ 			    unsigned int depth, char *format));
  extern void		Tk_DeleteAllBindings _ANSI_ARGS_((
  			    Tk_BindingTable bindingTable, ClientData object));
  extern int		Tk_DeleteBinding _ANSI_ARGS_((Tcl_Interp *interp,
***************
*** 519,524 ****
--- 525,532 ----
  			    Atom target));
  extern void		Tk_DeleteTimerHandler _ANSI_ARGS_((
  			    Tk_TimerToken token));
+ extern int		Tk_DepthOfPixmap _ANSI_ARGS_((Display *display,
+ 			    Pixmap pixmap));
  extern void		Tk_DestroyWindow _ANSI_ARGS_((Tk_Window tkwin));
  extern char *		Tk_DisplayName _ANSI_ARGS_((Tk_Window tkwin));
  extern int		Tk_DoOneEvent _ANSI_ARGS_((int flags));
***************
*** 551,556 ****
--- 559,566 ----
  extern void		Tk_FreeFontStruct _ANSI_ARGS_((
  			    XFontStruct *fontStructPtr));
  extern void		Tk_FreeGC _ANSI_ARGS_((Display *display, GC gc));
+ extern void		Tk_FreePixmap _ANSI_ARGS_((Display *display,
+ 			    Pixmap bitmap));
  extern void		Tk_GeometryRequest _ANSI_ARGS_((Tk_Window tkwin,
  			    int reqWidth,  int reqHeight));
  extern Tk_3DBorder	Tk_Get3DBorder _ANSI_ARGS_((Tcl_Interp *interp,
***************
*** 596,601 ****
--- 606,619 ----
  			    char *className));
  extern int		Tk_GetPixels _ANSI_ARGS_((Tcl_Interp *interp,
  			    Tk_Window tkwin, char *string, int *intPtr));
+ extern Pixmap		Tk_GetPixmap _ANSI_ARGS_((Tcl_Interp *interp,
+ 			    Tk_Window tkwin, Tk_Uid string));
+ extern Pixmap		Tk_GetPixmapClipMask _ANSI_ARGS_((Display *display,
+ 			    Pixmap pixmap));
+ extern Pixmap		Tk_GetPixmapFromData _ANSI_ARGS_((Tcl_Interp *interp,
+ 			    Tk_Window tkwin, Tk_Uid name, char *source,
+ 			    unsigned int width, unsigned int height,
+ 			    unsigned int depth, char *format));
  extern int		Tk_GetRelief _ANSI_ARGS_((Tcl_Interp *interp,
  			    char *name, int *reliefPtr));
  extern void		Tk_GetRootCoords _ANSI_ARGS_ ((Tk_Window tkwin,
***************
*** 648,653 ****
--- 666,673 ----
  			    XFontStruct *fontStructPtr));
  extern char *		Tk_NameOfJoinStyle _ANSI_ARGS_((int join));
  extern char *		Tk_NameOfJustify _ANSI_ARGS_((Tk_Justify justify));
+ extern char *		Tk_NameOfPixmap _ANSI_ARGS_((Display *display,
+ 			    Pixmap bitmap));
  extern char *		Tk_NameOfRelief _ANSI_ARGS_((int relief));
  extern Tk_Window	Tk_NameToWindow _ANSI_ARGS_((Tcl_Interp *interp,
  			    char *pathName, Tk_Window tkwin));
***************
*** 656,661 ****
--- 676,683 ----
  extern int		Tk_ParseArgv _ANSI_ARGS_((Tcl_Interp *interp,
  			    Tk_Window tkwin, int *argcPtr, char **argv,
  			    Tk_ArgvInfo *argTable, int flags));
+ extern Pixmap		Tk_PixmapOfName _ANSI_ARGS_((Tk_Uid name,
+ 			    Tk_Window tkwin));
  extern void		Tk_Preserve _ANSI_ARGS_((ClientData clientData));
  extern int		Tk_RegisterInterp _ANSI_ARGS_((Tcl_Interp *interp,
  			    char *name, Tk_Window tkwin));
***************
*** 664,671 ****
--- 686,706 ----
  			    unsigned int width, unsigned int height));
  extern Tk_RestrictProc *Tk_RestrictEvents _ANSI_ARGS_((Tk_RestrictProc *proc,
  			    char *arg, char **prevArgPtr));
+ extern int		Tk_SavePixmap _ANSI_ARGS_((Tcl_Interp *interp,
+ 			    Tk_Window tkwin, char *fileName,
+ 			    Pixmap savePixmap, Pixmap clipMask,
+ 			    unsigned int width, unsigned int height,
+ 			    char *format));
  extern void		Tk_SetBackgroundFromBorder _ANSI_ARGS_((
  			    Tk_Window tkwin, Tk_3DBorder border));
+ extern int              Tk_CacheStatusOfPixmap _ANSI_ARGS_((
+ 		            Display *display, Pixmap pixmap));
+ extern int              Tk_DefaultCacheStatus _ANSI_ARGS_(());
+ extern void             Tk_SetCacheStatusOfPixmap _ANSI_ARGS_((
+ 		            Display *display, Pixmap pixmap,
+ 			    int status));
+ extern void             Tk_SetDefaultCacheStatus _ANSI_ARGS_((
+ 			    int status));
  extern void		Tk_SetClass _ANSI_ARGS_((Tk_Window tkwin,
  			    char *className));
  extern void		Tk_SetColorModel _ANSI_ARGS_((Tk_Window tkwin,
***************
*** 688,695 ****
--- 723,735 ----
  extern void		Tk_SizeOfBitmap _ANSI_ARGS_((Display *display,
  			    Pixmap bitmap, unsigned int *widthPtr,
  			    unsigned int *heightPtr));
+ extern void		Tk_SizeOfPixmap _ANSI_ARGS_((Display *display,
+ 			    Pixmap bitmap, unsigned int *widthPtr,
+ 			    unsigned int *heightPtr));
  extern void		Tk_Sleep _ANSI_ARGS_((int ms));
  extern void		Tk_UndefineCursor _ANSI_ARGS_((Tk_Window window));
+ extern int		Tk_UndefinePixmap _ANSI_ARGS_((Tcl_Interp *interp,
+ 			    Tk_Uid name, Tk_Window tkwin));
  extern void		Tk_Ungrab _ANSI_ARGS_((Tk_Window tkwin));
  extern void		Tk_UnmapWindow _ANSI_ARGS_((Tk_Window tkwin));
  #ifdef KANJI
***************
*** 754,759 ****
--- 794,801 ----
  extern int		Tk_OptionCmd _ANSI_ARGS_((ClientData clientData,
  			    Tcl_Interp *interp, int argc, char **argv));
  extern int		Tk_PackCmd _ANSI_ARGS_((ClientData clientData,
+ 			    Tcl_Interp *interp, int argc, char **argv));
+ extern int		Tk_PinfoCmd _ANSI_ARGS_((ClientData clientData,
  			    Tcl_Interp *interp, int argc, char **argv));
  extern int		Tk_PlaceCmd _ANSI_ARGS_((ClientData clientData,
  			    Tcl_Interp *interp, int argc, char **argv));
*** tk3.2-jp.OLD/tkButton.c	Wed Jan 12 14:27:36 1994
--- tk3.2-jp.NEW/tkButton.c	Wed Jan 12 14:28:40 1994
***************
*** 55,60 ****
--- 55,62 ----
  				 * of this variable. */
      Pixmap bitmap;		/* Bitmap to display or None.  If not None
  				 * then text and textVar are ignored. */
+     Pixmap clipMask;		/* Bitmap to specify the clipping mask
+ 				 * for transparent pixmaps, or None. */
  
      /*
       * Information used when displaying widget:
***************
*** 232,240 ****
  	(char *) NULL, 0, ALL_MASK},
      {TK_CONFIG_SYNONYM, "-bg", "background", (char *) NULL,
  	(char *) NULL, 0, ALL_MASK},
!     {TK_CONFIG_BITMAP, "-bitmap", "bitmap", "Bitmap",
  	DEF_BUTTON_BITMAP, Tk_Offset(Button, bitmap),
  	ALL_MASK|TK_CONFIG_NULL_OK},
      {TK_CONFIG_PIXELS, "-borderwidth", "borderWidth", "BorderWidth",
  	DEF_BUTTON_BORDER_WIDTH, Tk_Offset(Button, borderWidth), ALL_MASK},
      {TK_CONFIG_STRING, "-command", "command", "Command",
--- 234,245 ----
  	(char *) NULL, 0, ALL_MASK},
      {TK_CONFIG_SYNONYM, "-bg", "background", (char *) NULL,
  	(char *) NULL, 0, ALL_MASK},
!     {TK_CONFIG_PIXMAP, "-bitmap", "bitmap", "Bitmap",
  	DEF_BUTTON_BITMAP, Tk_Offset(Button, bitmap),
  	ALL_MASK|TK_CONFIG_NULL_OK},
+     {TK_CONFIG_BITMAP, "-mask", "mask", "Mask",
+ 	DEF_BUTTON_BITMAP, Tk_Offset(Button, clipMask),
+ 	ALL_MASK|TK_CONFIG_NULL_OK},
      {TK_CONFIG_PIXELS, "-borderwidth", "borderWidth", "BorderWidth",
  	DEF_BUTTON_BORDER_WIDTH, Tk_Offset(Button, borderWidth), ALL_MASK},
      {TK_CONFIG_STRING, "-command", "command", "Command",
***************
*** 431,436 ****
--- 436,442 ----
      butPtr->text = NULL;
      butPtr->textVarName = NULL;
      butPtr->bitmap = None;
+     butPtr->clipMask = None;
      butPtr->state = tkNormalUid;
      butPtr->normalBorder = NULL;
      butPtr->activeBorder = NULL;
***************
*** 687,693 ****
  	ckfree(butPtr->textVarName);
      }
      if (butPtr->bitmap != None) {
! 	Tk_FreeBitmap(butPtr->display, butPtr->bitmap);
      }
      if (butPtr->normalBorder != NULL) {
  	Tk_Free3DBorder(butPtr->normalBorder);
--- 693,699 ----
  	ckfree(butPtr->textVarName);
      }
      if (butPtr->bitmap != None) {
! 	Tk_FreePixmap(butPtr->display, butPtr->bitmap);
      }
      if (butPtr->normalBorder != NULL) {
  	Tk_Free3DBorder(butPtr->normalBorder);
***************
*** 770,775 ****
--- 776,783 ----
      if (butPtr->command != NULL) {
  	ckfree(butPtr->command);
      }
+     /* the clipmask itself was already freed */
+     butPtr->clipMask = None;
      ckfree((char *) butPtr);
  }
  
***************
*** 859,864 ****
--- 867,881 ----
      gcValues.foreground = butPtr->normalFg->pixel;
      gcValues.background = Tk_3DBorderColor(butPtr->normalBorder)->pixel;
  
+     if (butPtr->bitmap != None &&
+ 	Tk_GetPixmapClipMask(butPtr->display, butPtr->bitmap) != None) {
+         if (butPtr->clipMask != None) {
+ 	    Tk_FreePixmap(butPtr->display, butPtr->clipMask);
+         }
+         butPtr->clipMask =
+           Tk_GetPixmapClipMask(butPtr->display, butPtr->bitmap);
+     }
+     
      /*
       * Note: GraphicsExpose events are disabled in normalTextGC because it's
       * used to copy stuff from an off-screen pixmap onto the screen (we know
***************
*** 1117,1123 ****
      if (butPtr->bitmap != None) {
  	unsigned int width, height;
  
! 	Tk_SizeOfBitmap(butPtr->display, butPtr->bitmap, &width, &height);
  	switch (butPtr->anchor) {
  	    case TK_ANCHOR_NW: case TK_ANCHOR_W: case TK_ANCHOR_SW:
  		x = butPtr->borderWidth + butPtr->selectorSpace
--- 1134,1140 ----
      if (butPtr->bitmap != None) {
  	unsigned int width, height;
  
! 	Tk_SizeOfPixmap(butPtr->display, butPtr->bitmap, &width, &height);
  	switch (butPtr->anchor) {
  	    case TK_ANCHOR_NW: case TK_ANCHOR_W: case TK_ANCHOR_SW:
  		x = butPtr->borderWidth + butPtr->selectorSpace
***************
*** 1151,1161 ****
  	    y += 1;
  	}
  #ifdef KANJI
! 	XCopyPlane(butPtr->display, butPtr->bitmap, pixmap,
! 		gc->fe[0].gc, 0, 0, width, height, x, y, 1);
  #else
! 	XCopyPlane(butPtr->display, butPtr->bitmap, pixmap,
! 		gc, 0, 0, width, height, x, y, 1);
  #endif /* KANJI */
  	y += height/2;
      } else {
--- 1168,1202 ----
  	    y += 1;
  	}
  #ifdef KANJI
! 	if (butPtr->clipMask != None) {
! 	  XSetClipOrigin(butPtr->display, gc->fe[0].gc, x, y);
! 	  XSetClipMask(butPtr->display, gc->fe[0].gc, butPtr->clipMask);
! 	}
! 	if (Tk_DepthOfPixmap(butPtr->display, butPtr->bitmap) == 1) {
! 	  XCopyPlane(butPtr->display, butPtr->bitmap, pixmap,
! 		     gc->fe[0].gc, 0, 0, width, height, x, y, 1);
! 	} else {
! 	  XCopyArea(butPtr->display, butPtr->bitmap, pixmap,
! 		    gc->fe[0].gc, 0, 0, width, height, x, y);
! 	}
! 	if (butPtr->clipMask != None) {
!           XSetClipMask(butPtr->display, gc->fe[0].gc, None);
!         }
  #else
! 	if (butPtr->clipMask != None) {
! 	  XSetClipOrigin(butPtr->display, gc, x, y);
! 	  XSetClipMask(butPtr->display, gc, butPtr->clipMask);
! 	}
! 	if (Tk_DepthOfPixmap(butPtr->display, butPtr->bitmap) == 1) {
! 	  XCopyPlane(butPtr->display, butPtr->bitmap, pixmap,
! 		     gc, 0, 0, width, height, x, y, 1);
! 	} else {
! 	  XCopyArea(butPtr->display, butPtr->bitmap, pixmap,
! 		    gc, 0, 0, width, height, x, y);
! 	}
! 	if (butPtr->clipMask != None) {
!           XSetClipMask(butPtr->display, gc, None);
!         }
  #endif /* KANJI */
  	y += height/2;
      } else {
***************
*** 1366,1372 ****
  
      butPtr->selectorSpace = 0;
      if (butPtr->bitmap != None) {
! 	Tk_SizeOfBitmap(butPtr->display, butPtr->bitmap, &width, &height);
  	if (butPtr->width > 0) {
  	    width = butPtr->width;
  	}
--- 1407,1413 ----
  
      butPtr->selectorSpace = 0;
      if (butPtr->bitmap != None) {
!         Tk_SizeOfPixmap(butPtr->display, butPtr->bitmap, &width, &height);
  	if (butPtr->width > 0) {
  	    width = butPtr->width;
  	}
*** tk3.2-jp.OLD/tkCanvas.h	Wed Jan 12 14:27:38 1994
--- tk3.2-jp.NEW/tkCanvas.h	Wed Jan 12 14:28:42 1994
***************
*** 403,408 ****
--- 403,411 ----
  extern void		TkCanvPsPath _ANSI_ARGS_((Tcl_Interp *interp,
  			    double *coordPtr, int numPoints,
  			    Tk_PostscriptInfo *psInfoPtr));
+ extern int		TkCanvPsPixmap _ANSI_ARGS_((Tk_Canvas *canvasPtr,
+ 			    Tk_PostscriptInfo *psInfoPtr, Pixmap bitmap,
+                             double toX, double toY));
  extern int		TkCanvPsStipple _ANSI_ARGS_((Tk_Canvas *canvasPtr,
  			    Tk_PostscriptInfo *psInfoPtr, Pixmap bitmap,
  			    int filled));
*** tk3.2-jp.OLD/tkCanvas.c	Wed Jan 12 14:27:38 1994
--- tk3.2-jp.NEW/tkCanvas.c	Wed Jan 12 14:28:42 1994
***************
*** 217,222 ****
--- 217,226 ----
  			    XEvent *eventPtr));
  static void		RelinkItems _ANSI_ARGS_((Tk_Canvas *canvasPtr,
  			    char *tag, Tk_Item *prevPtr));
+ static int		SaveCanvas _ANSI_ARGS_((Tcl_Interp *interp,
+ 			    Tk_Canvas *canvasPtr, char *fileName, 
+ 			    char *format, int x, int y,
+ 			    unsigned int width, unsigned int height));
  static Tk_Item *	StartTagSearch _ANSI_ARGS_((Tk_Canvas *canvasPtr,
  			    char *tag, TagSearch *searchPtr));
  
***************
*** 1045,1050 ****
--- 1049,1074 ----
  	    }
  	}
  	RelinkItems(canvasPtr, argv[2], prevPtr);
+     } else if ((c == 's') && (strncmp(argv[1], "save", length) == 0)
+           && (length >= 3)) {
+         if (argc != 4 && argc != 8) {
+             Tcl_AppendResult(interp, "wrong # args: should be \"",
+                 argv[0], " save fileName format ?x y width height?\"",
+                 (char *) NULL);
+             goto error;
+         }
+         if (argc == 4) {
+             if (SaveCanvas(interp, canvasPtr, argv[2], argv[3], 0,
+ 	        0, 0, 0) != TCL_OK) {
+                 goto error;
+             }
+         } else {
+             if (SaveCanvas(interp, canvasPtr, argv[2], argv[3],
+ 	        atol(argv[4]), atol(argv[5]), atol(argv[6]),
+ 		atol(argv[7]))) {
+                 goto error;
+             }
+         }
      } else if ((c == 's') && (strncmp(argv[1], "scale", length) == 0)
  	    && (length >= 3)) {
  	double xOrigin, yOrigin, xScale, yScale;
***************
*** 1660,1665 ****
--- 1684,1883 ----
      if (canvasPtr->flags & UPDATE_SCROLLBARS) {
  	CanvasUpdateScrollbars(canvasPtr);
      }
+ }
+ 
+ /*
+  *--------------------------------------------------------------
+  *
+  * SaveCanvas --
+  *
+  *    This procedure saves the contents of a canvas window.
+  *
+  * Results:
+  *    The return value is a standard Tcl result.  If TCL_ERROR is
+  *    returned, then interp->result contains an error message.
+  *
+  * Side effects:
+  *    A pixmap is written to a file.
+  *
+  *--------------------------------------------------------------
+  */
+ 
+ static int
+ SaveCanvas(interp, canvasPtr, fileName, format, x, y, width, height)
+     Tcl_Interp *interp;               /* Used for error reporting. */
+     register Tk_Canvas *canvasPtr;    /* Information about widget */
+     char *fileName;             /* the output file name. */
+     char *format;               /* the output file format. */
+     int x;                      /* upper left x coordinate. */
+     int y;                      /* upper left y coordinate. */
+     unsigned int width;         /* width of pixmap area to save. */
+     unsigned int height;        /* height of pixmap area to save. */
+ {
+     register Tk_Window tkwin = canvasPtr->tkwin;
+     register Tk_Item *itemPtr;
+     Pixmap pixmap;
+     Pixmap savePixmap;
+     int screenX1, screenX2, screenY1, screenY2;
+ 
+     if (canvasPtr->tkwin == NULL) {
+ 	return TCL_OK;
+     }
+     if (!Tk_IsMapped(tkwin)) {
+ 	return TCL_OK;
+     }
+     if (!(fileName && *fileName)) {
+ 	Tcl_ResetResult(interp);
+ 	Tcl_AppendResult(interp, "no filename specified for canvas saving",
+ 	    (char *) NULL);
+ 	return TCL_ERROR;
+     }
+ 
+     /*
+      * Choose a new current item if that is needed (this could cause
+      * event handlers to be invoked).
+      */
+ 
+     while (canvasPtr->flags & REPICK_NEEDED) {
+ 	Tk_Preserve((ClientData) canvasPtr);
+ 	canvasPtr->flags &= ~REPICK_NEEDED;
+ 	PickCurrentItem(canvasPtr, &canvasPtr->pickEvent);
+ 	tkwin = canvasPtr->tkwin;
+ 	Tk_Release((ClientData) canvasPtr);
+ 	if (tkwin == NULL) {
+ 	    return TCL_OK;
+ 	}
+     }
+ 
+     if(x == 0 && y == 0 && width == 0 && height == 0) {
+         screenX1 = 0;
+         screenY1 = 0;
+         screenX2 = Tk_Width(tkwin);
+         screenY2 = Tk_Height(tkwin);
+         width = Tk_Width(tkwin);
+         height = Tk_Height(tkwin);
+     } else {
+         if(width != 0 && height != 0) {
+             screenX1 = x;
+             screenY1 = y;
+             screenX2 = x + width;
+             screenY2 = y + height;
+         } else {
+             Tcl_ResetResult(interp);
+             Tcl_AppendResult(interp,
+ 	        "no correct size specified for canvas saving",
+                 (char *) NULL);
+             return TCL_ERROR;
+         }
+     }
+ 
+     /*
+      * Redrawing is done in a temporary pixmap that is allocated
+      * here and freed at the end of the procedure.  All drawing
+      * is done to the pixmap, and the pixmap is copied to the
+      * screen at the end of the procedure. The temporary pixmap
+      * serves two purposes:
+      *
+      * 1. It provides a smoother visual effect (no clearing and
+      *    gradual redraw will be visible to users).
+      * 2. It allows us to redraw only the objects that overlap
+      *    the redraw area.  Otherwise incorrect results could
+      *	  occur from redrawing things that stick outside of
+      *	  the redraw area (we'd have to redraw everything in
+      *    order to make the overlaps look right).
+      *
+      * Some tricky points about the pixmap:
+      *
+      * 1. We only allocate a large enough pixmap to hold the
+      *    area that has to be redisplayed.  This saves time in
+      *    in the X server for large objects that cover much
+      *    more than the area being redisplayed:  only the area
+      *    of the pixmap will actually have to be redrawn.
+      * 2. The origin of the pixmap is adjusted to an even multiple
+      *    of 32 bits.  This is so that stipple patterns with a size
+      *    of 8 or 16 or 32 bits will always line up when information
+      *    is copied back to the screen.
+      * 3. Some X servers (e.g. the one for DECstations) have troubles
+      *    with characters that overlap an edge of the pixmap (on the
+      *    DEC servers, as of 8/18/92, such characters are drawn one
+      *    pixel too far to the right).  To handle this problem,
+      *    make the pixmap a bit larger than is absolutely needed
+      *    so that for normal-sized fonts the characters that ovelap
+      *    the edge of the pixmap will be outside the area we care
+      *    about.
+      */
+ 
+     canvasPtr->drawableXOrigin = (screenX1 - 30) & ~0x1f;
+     canvasPtr->drawableYOrigin = (screenY1 - 30) & ~0x1f;
+     pixmap = XCreatePixmap(Tk_Display(tkwin), Tk_WindowId(tkwin),
+ 	screenX2 + 30 - canvasPtr->drawableXOrigin,
+ 	screenY2 + 30 - canvasPtr->drawableYOrigin,
+ 	DefaultDepthOfScreen(Tk_Screen(tkwin)));
+     savePixmap = XCreatePixmap(Tk_Display(tkwin), Tk_WindowId(tkwin),
+         width, height, Tk_Depth(tkwin));
+ 
+     /*
+      * Clear the area to be redrawn.
+      */
+ 
+     XFillRectangle(Tk_Display(tkwin), pixmap, canvasPtr->pixmapGC,
+ 	    screenX1 - canvasPtr->drawableXOrigin,
+ 	    screenY1 - canvasPtr->drawableYOrigin,
+ 	    (unsigned int) (screenX2 - screenX1),
+ 	    (unsigned int) (screenY2 - screenY1));
+     XFillRectangle(Tk_Display(tkwin), savePixmap, canvasPtr->pixmapGC,
+             0, 0, width, height);
+ 
+     /*
+      * Scan through the item list, redrawing those items that need it.
+      * An item must be redraw if either (a) it intersects the smaller
+      * on-screen area or (b) it intersects the full canvas area and its
+      * type requests that it be redrawn always (e.g. so subwindows can
+      * be unmapped when they move off-screen).
+      */
+ 
+     for (itemPtr = canvasPtr->firstItemPtr; itemPtr != NULL;
+ 	    itemPtr = itemPtr->nextPtr) {
+ 	if ((itemPtr->x1 >= screenX2)
+ 		|| (itemPtr->y1 >= screenY2)
+ 		|| (itemPtr->x2 < screenX1)
+ 		|| (itemPtr->y2 < screenY1)) {
+ 	    if (!itemPtr->typePtr->alwaysRedraw
+ 		    || (itemPtr->x1 >= canvasPtr->redrawX2)
+ 		    || (itemPtr->y1 >= canvasPtr->redrawY2)
+ 		    || (itemPtr->x2 < canvasPtr->redrawX1)
+ 		    || (itemPtr->y2 < canvasPtr->redrawY1)) {
+ 		continue;
+ 	    }
+ 	}
+ 	(*itemPtr->typePtr->displayProc)(canvasPtr, itemPtr, pixmap);
+     }
+ 
+     /*
+      * Copy from the temporary pixmap to the screen, then free up
+      * the temporary pixmap.
+      */
+ 
+     XCopyArea(Tk_Display(tkwin), pixmap, savePixmap,
+ 	    canvasPtr->pixmapGC,
+ 	    screenX1 - canvasPtr->drawableXOrigin,
+ 	    screenY1 - canvasPtr->drawableYOrigin,
+ 	    screenX2 - screenX1, screenY2 - screenY1, 0, 0);
+ 
+     /*
+      * Save temporary pixmap.
+      */
+ 
+     if (Tk_SavePixmap(interp, tkwin, fileName, savePixmap,
+            (Pixmap) NULL, width, height, format) != TCL_OK) {
+         XFreePixmap(Tk_Display(tkwin), pixmap);
+         XFreePixmap(Tk_Display(tkwin), savePixmap);
+         return TCL_ERROR;
+     }
+     XFreePixmap(Tk_Display(tkwin), pixmap);
+     XFreePixmap(Tk_Display(tkwin), savePixmap);
+ 
+     return TCL_OK;
  }
  
  /*
*** tk3.2-jp.OLD/tkCanvBmap.c	Wed Jan 12 14:27:37 1994
--- tk3.2-jp.NEW/tkCanvBmap.c	Wed Jan 12 14:28:40 1994
***************
*** 34,39 ****
--- 34,41 ----
      Tk_Anchor anchor;		/* Where to anchor bitmap relative to
  				 * (x,y). */
      Pixmap bitmap;		/* Bitmap to display in window. */
+     Pixmap clipMask;		/* Bitmap to specify the clipping mask
+ 				 * for transparent pixmaps, or None. */
      XColor *fgColor;		/* Foreground color to use for bitmap. */
      XColor *bgColor;		/* Background color to use for bitmap. */
      GC gc;			/* Graphics context to use for drawing
***************
*** 49,56 ****
  	"center", Tk_Offset(BitmapItem, anchor), TK_CONFIG_DONT_SET_DEFAULT},
      {TK_CONFIG_COLOR, "-background", (char *) NULL, (char *) NULL,
  	(char *) NULL, Tk_Offset(BitmapItem, bgColor), TK_CONFIG_NULL_OK},
!     {TK_CONFIG_BITMAP, "-bitmap", (char *) NULL, (char *) NULL,
  	(char *) NULL, Tk_Offset(BitmapItem, bitmap), TK_CONFIG_NULL_OK},
      {TK_CONFIG_COLOR, "-foreground", (char *) NULL, (char *) NULL,
  	"black", Tk_Offset(BitmapItem, fgColor), 0},
      {TK_CONFIG_CUSTOM, "-tags", (char *) NULL, (char *) NULL,
--- 51,60 ----
  	"center", Tk_Offset(BitmapItem, anchor), TK_CONFIG_DONT_SET_DEFAULT},
      {TK_CONFIG_COLOR, "-background", (char *) NULL, (char *) NULL,
  	(char *) NULL, Tk_Offset(BitmapItem, bgColor), TK_CONFIG_NULL_OK},
!     {TK_CONFIG_PIXMAP, "-bitmap", (char *) NULL, (char *) NULL,
  	(char *) NULL, Tk_Offset(BitmapItem, bitmap), TK_CONFIG_NULL_OK},
+     {TK_CONFIG_BITMAP, "-mask", (char *) NULL, (char *) NULL,
+ 	(char *) NULL, Tk_Offset(BitmapItem, clipMask), TK_CONFIG_NULL_OK},
      {TK_CONFIG_COLOR, "-foreground", (char *) NULL, (char *) NULL,
  	"black", Tk_Offset(BitmapItem, fgColor), 0},
      {TK_CONFIG_CUSTOM, "-tags", (char *) NULL, (char *) NULL,
***************
*** 161,166 ****
--- 165,171 ----
  
      bmapPtr->anchor = TK_ANCHOR_CENTER;
      bmapPtr->bitmap = None;
+     bmapPtr->clipMask = None;
      bmapPtr->fgColor = NULL;
      bmapPtr->bgColor = NULL;
      bmapPtr->gc = None;
***************
*** 282,287 ****
--- 287,301 ----
      }
      bmapPtr->gc = newGC;
  
+     if (bmapPtr->bitmap != None &&
+ 	Tk_GetPixmapClipMask(canvasPtr->display, bmapPtr->bitmap) != None) {
+         if (bmapPtr->clipMask != None) {
+ 	    Tk_FreePixmap(canvasPtr->display, bmapPtr->clipMask);
+         }
+         bmapPtr->clipMask =
+ 	    Tk_GetPixmapClipMask(canvasPtr->display, bmapPtr->bitmap);
+     }
+     
      ComputeBitmapBbox(canvasPtr, bmapPtr);
  
      return TCL_OK;
***************
*** 312,318 ****
      register BitmapItem *bmapPtr = (BitmapItem *) itemPtr;
  
      if (bmapPtr->bitmap != None) {
! 	Tk_FreeBitmap(canvasPtr->display, bmapPtr->bitmap);
      }
      if (bmapPtr->fgColor != NULL) {
  	Tk_FreeColor(bmapPtr->fgColor);
--- 326,332 ----
      register BitmapItem *bmapPtr = (BitmapItem *) itemPtr;
  
      if (bmapPtr->bitmap != None) {
! 	Tk_FreePixmap(canvasPtr->display, bmapPtr->bitmap);
      }
      if (bmapPtr->fgColor != NULL) {
  	Tk_FreeColor(bmapPtr->fgColor);
***************
*** 323,328 ****
--- 337,344 ----
      if (bmapPtr->gc != NULL) {
  	Tk_FreeGC(canvasPtr->display, bmapPtr->gc);
      }
+     /* the clipmask itself was already freed */
+     bmapPtr->clipMask = None;
  }
  
  /*
***************
*** 368,374 ****
       * Compute location and size of bitmap, using anchor information.
       */
  
!     Tk_SizeOfBitmap(canvasPtr->display, bmapPtr->bitmap, &width, &height);
      switch (bmapPtr->anchor) {
  	case TK_ANCHOR_N:
  	    x -= width/2;
--- 384,390 ----
       * Compute location and size of bitmap, using anchor information.
       */
  
!     Tk_SizeOfPixmap(canvasPtr->display, bmapPtr->bitmap, &width, &height);
      switch (bmapPtr->anchor) {
  	case TK_ANCHOR_N:
  	    x -= width/2;
***************
*** 440,451 ****
      register BitmapItem *bmapPtr = (BitmapItem *) itemPtr;
  
      if (bmapPtr->bitmap != None) {
! 	XCopyPlane(Tk_Display(canvasPtr->tkwin), bmapPtr->bitmap, drawable,
! 		bmapPtr->gc, 0, 0,
! 		(unsigned int) bmapPtr->header.x2 - bmapPtr->header.x1,
! 		(unsigned int) bmapPtr->header.y2 - bmapPtr->header.y1,
  		bmapPtr->header.x1 - canvasPtr->drawableXOrigin,
! 		bmapPtr->header.y1 - canvasPtr->drawableYOrigin, 1);
      }
  }
  
--- 456,488 ----
      register BitmapItem *bmapPtr = (BitmapItem *) itemPtr;
  
      if (bmapPtr->bitmap != None) {
!         if (bmapPtr->clipMask != None) {
! 	    XSetClipOrigin(Tk_Display(canvasPtr->tkwin), bmapPtr->gc,
  		bmapPtr->header.x1 - canvasPtr->drawableXOrigin,
!                 bmapPtr->header.y1 - canvasPtr->drawableYOrigin);
! 	    XSetClipMask(Tk_Display(canvasPtr->tkwin), bmapPtr->gc,
! 		bmapPtr->clipMask);
! 	}
!         if (Tk_DepthOfPixmap(Tk_Display(canvasPtr->tkwin),
! 			     bmapPtr->bitmap) == 1) {
!             XCopyPlane(Tk_Display(canvasPtr->tkwin), bmapPtr->bitmap,
!                 drawable, bmapPtr->gc, 0, 0,
!                 (unsigned int) bmapPtr->header.x2 - bmapPtr->header.x1,
!                 (unsigned int) bmapPtr->header.y2 - bmapPtr->header.y1,
!                 bmapPtr->header.x1 - canvasPtr->drawableXOrigin,
!                 bmapPtr->header.y1 - canvasPtr->drawableYOrigin, 1);
!         } else {
!             XCopyArea(Tk_Display(canvasPtr->tkwin), bmapPtr->bitmap,
!                 drawable, bmapPtr->gc, 0, 0,
!                 (unsigned int) bmapPtr->header.x2 - bmapPtr->header.x1,
!                 (unsigned int) bmapPtr->header.y2 - bmapPtr->header.y1,
!                 bmapPtr->header.x1 - canvasPtr->drawableXOrigin,
!                 bmapPtr->header.y1 - canvasPtr->drawableYOrigin);
! 	}
!         if (bmapPtr->clipMask != None) {
!             XSetClipMask(Tk_Display(canvasPtr->tkwin), bmapPtr->gc,
! 			 None);
!         }
      }
  }
  
***************
*** 504,509 ****
--- 541,556 ----
  	yDiff = 0;
      }
  
+     if (xDiff == 0 && yDiff == 0 && bmapPtr->clipMask != None) {
+       int x = (int) (coordPtr[0] - x1 - 0.5);
+       int y = (int) (coordPtr[1] - y1 - 0.5);
+       XImage *image = XGetImage (canvasPtr->display, bmapPtr->clipMask,
+ 				 x, y, 1, 1, AllPlanes, XYPixmap);
+       int pixel = XGetPixel (image, 0, 0);
+       XDestroyImage (image);
+       if (pixel == 0) return 5.0;
+     }
+ 
      return hypot(xDiff, yDiff);
  }
  
***************
*** 664,670 ****
  
      x = bmapPtr->x;
      y = TkCanvPsY(psInfoPtr, bmapPtr->y);
!     Tk_SizeOfBitmap(canvasPtr->display, bmapPtr->bitmap, &width, &height);
      switch (bmapPtr->anchor) {
  	case TK_ANCHOR_NW:			y -= height;		break;
  	case TK_ANCHOR_N:	x -= width/2.0; y -= height;		break;
--- 711,717 ----
  
      x = bmapPtr->x;
      y = TkCanvPsY(psInfoPtr, bmapPtr->y);
!     Tk_SizeOfPixmap(canvasPtr->display, bmapPtr->bitmap, &width, &height);
      switch (bmapPtr->anchor) {
  	case TK_ANCHOR_NW:			y -= height;		break;
  	case TK_ANCHOR_N:	x -= width/2.0; y -= height;		break;
***************
*** 701,713 ****
  	if (TkCanvPsColor(canvasPtr, psInfoPtr, bmapPtr->fgColor) != TCL_OK) {
  	    return TCL_ERROR;
  	}
! 	sprintf(buffer, "%g %g translate\n %d %d true matrix {\n",
! 		x, y, width, height);
! 	Tcl_AppendResult(canvasPtr->interp, buffer, (char *) NULL);
! 	if (TkCanvPsBitmap(canvasPtr, psInfoPtr, bmapPtr->bitmap) != TCL_OK) {
  	    return TCL_ERROR;
  	}
- 	Tcl_AppendResult(canvasPtr->interp, "\n} imagemask\n", (char *) NULL);
      }
      return TCL_OK;
  }
--- 748,769 ----
  	if (TkCanvPsColor(canvasPtr, psInfoPtr, bmapPtr->fgColor) != TCL_OK) {
  	    return TCL_ERROR;
  	}
! 	if (Tk_DepthOfPixmap(canvasPtr->display, bmapPtr->bitmap) == 1) {
! 	  sprintf(buffer, "%g %g translate\n %d %d true matrix {\n",
! 		  x, y, width, height);
! 	  Tcl_AppendResult(canvasPtr->interp, buffer, (char *) NULL);
! 	  if (TkCanvPsBitmap(canvasPtr, psInfoPtr,
! 			     bmapPtr->bitmap) != TCL_OK) {
! 	    return TCL_ERROR;
! 	  }
! 	  Tcl_AppendResult(canvasPtr->interp, "\n} imagemask\n",
! 			   (char *) NULL);
! 	} else {
! 	  if (TkCanvPsPixmap(canvasPtr, psInfoPtr,
! 			     bmapPtr->bitmap, x, y) != TCL_OK) {
  	    return TCL_ERROR;
+ 	  }
  	}
      }
      return TCL_OK;
  }
*** tk3.2-jp.OLD/tkCanvPs.c	Wed Jan 12 14:27:37 1994
--- tk3.2-jp.NEW/tkCanvPs.c	Wed Jan 12 14:28:40 1994
***************
*** 930,936 ****
  
      Tk_SizeOfBitmap(canvasPtr->display, bitmap, &width, &height);
      imagePtr = XGetImage(Tk_Display(canvasPtr->tkwin), bitmap, 0, 0,
! 	    width, height, 1, XYPixmap);
      Tcl_AppendResult(canvasPtr->interp, "<", (char *) NULL);
      mask = 0x80;
      value = 0;
--- 930,936 ----
  
      Tk_SizeOfBitmap(canvasPtr->display, bitmap, &width, &height);
      imagePtr = XGetImage(Tk_Display(canvasPtr->tkwin), bitmap, 0, 0,
! 	      width, height, 1, XYPixmap);
      Tcl_AppendResult(canvasPtr->interp, "<", (char *) NULL);
      mask = 0x80;
      value = 0;
***************
*** 1019,1024 ****
--- 1019,1327 ----
      Tcl_AppendResult(canvasPtr->interp, filled ? " true" : " false",
  	    " StippleFill\n", (char *) NULL);
      return TCL_OK;
+ }
+ 
+ /*
+  *
+  * Name - get.hc
+  * Copyright (C) 1990-92 Bruce Schuchardt, Servio Corp.
+  *
+  * Description:  image grabbing functions for xgrabsc
+  * 
+  * makePSImage returns an XImage structure that contains the samples
+  * to be written.  If the input image is monochrome, its XImage structure
+  * will be returned.  Otherwise a new structure is allocated and returned.
+  */
+ 
+ XImage* makePSImage(canvasPtr, ximage, desiredDepth, depth, bpl, spb)
+     Tk_Canvas *canvasPtr;		/* Information about canvas. */
+     XImage* ximage;
+     int desiredDepth;  /* 0 = don't care */
+     int* depth;
+     int* bpl;
+     int* spb;
+ {
+   register unsigned char* ptr;
+   XImage* psimage;
+ 
+   /* use depth as the number of bits in output samples */
+   *depth = ximage->depth;
+   /* postscript only supports 1, 2, 4, or 8 */
+   if (*depth > 8) *depth = 8;     /* max postscript bits/sample */
+   if (*depth < 8 && *depth > 4) *depth = 8;
+   if (*depth == 3) *depth = 4;
+     
+   if (desiredDepth == 0) {
+     desiredDepth = *depth;
+   }
+   
+   *bpl = ((ximage->width * desiredDepth) + 7) / 8;
+ 
+   if (*depth == 1) {
+     /* Same image */
+     psimage = ximage;
+   } else {
+     /* colors have to be changed to luminescence */
+     ptr = (unsigned char *)malloc(ximage->height * *bpl);
+     psimage = XCreateImage(canvasPtr->display,
+ 		  DefaultVisualOfScreen(Tk_Screen(canvasPtr->tkwin)),
+                   desiredDepth, ZPixmap,
+                   0, ptr,
+                   ximage->width, ximage->height,
+                   8, *bpl);
+     if (!psimage) {
+       fprintf(stderr,
+ 	      "wish: could not create image for Postscript conversion\n");
+       exit(3);
+     }
+     /* force the bits_per_pixel to be what is needed */
+     psimage->bits_per_pixel = desiredDepth;
+   }
+ 
+   *spb = 8 / psimage->bits_per_pixel;    /* samples per byte */
+   *depth = desiredDepth;  /* The final resolution */
+   return psimage;
+ }
+ /*
+  *--------------------------------------------------------------
+  *
+  * TkCanvPsPixmap --
+  *
+  *	This procedure is called to output the contents of a
+  *	pixmap in proper image data format for Postscript (i.e.
+  *	data between angle brackets).
+  *
+  * Results:
+  *	Returns a standard Tcl return value.  If an error occurs
+  *	then an error message will be left in canvasPtr->interp->result.
+  *	If no error occurs, then additional Postscript will be
+  *	appended to canvasPtr->interp->result.
+  *
+  * Side effects:
+  *	None.
+  *
+  *--------------------------------------------------------------
+  */
+ 
+ int
+ TkCanvPsPixmap(canvasPtr, handle, bitmap, toX, toY)
+     Tk_Canvas *canvasPtr;		/* Information about canvas. */
+     Tk_PostscriptInfo *handle;		/* Information about Postscript being
+ 					 * generated. */
+     Pixmap bitmap;			/* Bitmap to use for stippling. */
+     double toX;                         /* translate X */
+     double toY;                         /* translate Y */
+ {
+   register unsigned char b, b2, *ptr;
+   PostscriptInfo *psInfoPtr = (PostscriptInfo *) handle;
+   unsigned int width, height;
+   XImage *imagePtr;
+   XImage *psimage;
+   int charsInLine = 0, i, x, y, value, mask, depth, bpl, spb;
+   long p;
+   char string[200];
+   int lshift, lmask;
+   int numCmaps, ncolors;
+   Colormap *cmaps, cmap;
+   XColor colors[256];
+   unsigned int red[256], green[256], blue[256];
+ 
+   if (psInfoPtr->prepass) {
+     return TCL_OK;
+   }
+ 
+   /* get the colormap info */
+   cmaps = XListInstalledColormaps(canvasPtr->display,
+ 			          Tk_WindowId(canvasPtr->tkwin), &numCmaps);
+   if (numCmaps == 0) {
+     cmap = DefaultColormapOfScreen(Tk_Screen(canvasPtr->tkwin));
+   } else {
+     cmap = *cmaps;
+   }
+   XFree(cmaps);
+ 
+   ncolors = CellsOfScreen(Tk_Screen(canvasPtr->tkwin));
+   /* this won't cut the mustard for DirectColor */
+   for (i = 0; i < ncolors; i++) {
+     colors[i].pixel = i;
+   }
+ 
+   XQueryColors(canvasPtr->display, cmap, colors, ncolors);
+   for (i = 0; i < ncolors; i++) {
+     red[i] = colors[i].red;
+     green[i] = colors[i].green;
+     blue[i] = colors[i].blue;
+   }
+ 
+   Tk_SizeOfPixmap(canvasPtr->display, bitmap, &width, &height);
+   if (strncmp(psInfoPtr->colorMode, "monochrome",
+ 	      strlen(psInfoPtr->colorMode)) == 0) {
+     imagePtr = XGetImage(Tk_Display(canvasPtr->tkwin), bitmap, 0, 0,
+ 			 width, height, 1, XYPixmap);
+ 
+     sprintf(string, "%g %g translate\n", toX, toY);
+     Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+     sprintf(string, "%d %d true matrix {\n", width, height);
+     Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+     Tcl_AppendResult(canvasPtr->interp, "<", (char *) NULL);
+     
+     mask = 0x80;
+     value = 0;
+     charsInLine = 0;
+     for (y = 1; y <= height; y++) {
+       for (x = 0; x < width; x++) {
+ 	if (XGetPixel(imagePtr, x, height-y)) {
+ 	  value |= mask;
+ 	}
+ 	mask >>= 1;
+ 	if (mask == 0) {
+ 	  sprintf(string, "%02x", value);
+ 	  Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+ 	  mask = 0x80;
+ 	  value = 0;
+ 	  charsInLine += 2;
+ 	  if (charsInLine >= 60) {
+ 	    Tcl_AppendResult(canvasPtr->interp, "\n", (char *) NULL);
+ 	    charsInLine = 0;
+ 	  }
+ 	}
+       }
+       if (mask != 0x80) {
+ 	sprintf(string, "%02x", value);
+ 	Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+ 	mask = 0x80;
+ 	value = 0;
+ 	charsInLine += 2;
+       }
+     }
+     Tcl_AppendResult(canvasPtr->interp, ">\n} imagemask\n", (char *) NULL);
+   } else {
+     if (strncmp(psInfoPtr->colorMode, "gray",
+ 		strlen(psInfoPtr->colorMode)) == 0) {
+       imagePtr = XGetImage(Tk_Display(canvasPtr->tkwin), bitmap, 0, 0,
+ 			   width, height, AllPlanes, ZPixmap);
+       psimage = makePSImage(canvasPtr, imagePtr, 0, &depth, &bpl,
+ 			    &spb, 0);
+ 
+       if (depth > 1) {
+ 	/* translate colors into grays */
+ 	lshift = 16 - psimage->bits_per_pixel;
+ 	lmask  = (1 << psimage->bits_per_pixel) - 1;
+ 	for (y = 0; y < imagePtr->height; y++) {
+ 	  for (x = 0; x < imagePtr->width; x++) {
+ 	    p = XGetPixel(imagePtr, x, y);
+ 	    i = (0.30*(double) red[p]) +
+ 	      (0.59*(double) green[p]) +
+ 		(0.11*(double) blue[p]);
+ 	    i = (i >> lshift) & lmask;
+ 	    XPutPixel(psimage, x, y, i);
+ 	  }
+ 	}
+       }
+ 
+       sprintf(string, "%g %g translate\n", toX, toY);
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       sprintf(string, "%d %d scale\n", width, height);
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       sprintf(string, "%d %d %d [%d 0 0 -%d 0 %d] {\n", width, height,
+ 	      Tk_DepthOfPixmap(canvasPtr->display, bitmap),
+ 	      width, height, height);
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       Tcl_AppendResult(canvasPtr->interp, "<", (char *) NULL);
+       
+       for (y = 0; y < psimage->height; y++) {
+ 	for (x = 0,
+ 	     ptr = (unsigned char *) (psimage->data +
+ 				      (y * psimage->bytes_per_line));
+ 	     x < psimage->width;
+ 	     x += spb, ptr++) {
+ 	  b = *ptr;
+ 	  if (depth == 1 && psimage->bitmap_bit_order == LSBFirst) {
+ 	    /* swap the bits in a byte */
+ 	    b2 = 0;
+ 	    b2 |= (b & 0x01) << 7;
+ 	    b2 |= (b & 0x02) << 5;
+ 	    b2 |= (b & 0x04) << 3;
+ 	    b2 |= (b & 0x08) << 1;
+ 	    b2 |= (b & 0x10) >> 1;
+ 	    b2 |= (b & 0x20) >> 3;
+ 	    b2 |= (b & 0x40) >> 5;
+ 	    b2 |= (b & 0x80) >> 7;
+ 	    b = b2;
+ 	  }
+ 	  sprintf(string, "%02x", b);
+ 	  Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+ 	  charsInLine += 2;
+ 	  if (charsInLine >= 60) {
+ 	    Tcl_AppendResult(canvasPtr->interp, "\n", (char *) NULL);
+ 	    charsInLine = 0;
+ 	  }
+ 	}
+       }
+       
+       Tcl_AppendResult(canvasPtr->interp, ">\n} image\n", (char *) NULL);
+       
+       if (psimage != imagePtr) {
+ 	free(psimage->data);
+ 	free(psimage);
+       }
+     } else {
+       imagePtr = XGetImage(Tk_Display(canvasPtr->tkwin), bitmap, 0, 0,
+ 			   width, height, AllPlanes, ZPixmap);
+       spb = 1;
+       
+       sprintf(string, "%g %g translate\n", toX, toY);
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       sprintf(string, "%d %d scale\n", width, height);
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       sprintf(string, "/buffer %d string def\n", 1);
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       sprintf(string, "/rgbmap {<");
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       for (x = 0; x < ncolors; x++) {
+ 	sprintf(string, "%02x%02x%02x%c",
+ 		(unsigned char)((red[x] >> 8) & 0xff),
+ 		(unsigned char)((green[x] >> 8) & 0xff),
+ 		(unsigned char)((blue[x] >> 8) & 0xff),
+ 		x < (ncolors - 1) ? '\n' : '>');
+ 	Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       }
+       sprintf(string, "} def\n");
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       sprintf(string, "\n%d %d %d [%d 0 0 -%d 0 %d]\n", width, height,
+ 	      Tk_DepthOfPixmap(canvasPtr->display, bitmap),
+ 	      width, height, height);
+       Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+       Tcl_AppendResult(canvasPtr->interp,
+ 		       " { currentfile buffer readhexstring pop pop\n",
+ 		       (char *) NULL);
+       Tcl_AppendResult(canvasPtr->interp,
+ 		       "   rgbmap buffer 0 get 3 mul 3 getinterval\n",
+ 		       (char *) NULL);
+       Tcl_AppendResult(canvasPtr->interp, " }\n", (char *) NULL);
+       Tcl_AppendResult(canvasPtr->interp, " false 3 colorimage\n",
+ 		       (char *) NULL);
+       
+       for (y = 0; y < imagePtr->height; y++) {
+ 	for (x = 0, ptr = (unsigned char *) (imagePtr->data +
+ 					     (y * imagePtr->bytes_per_line));
+ 	     x < imagePtr->width;
+ 	     x += spb, ptr++) {
+ 	  b = *ptr;
+ 	  sprintf(string, "%02x", b & 0xFF);
+ 	  Tcl_AppendResult(canvasPtr->interp, string, (char *) NULL);
+ 	  charsInLine += 2;
+ 	  if (charsInLine >= 60) {
+ 	    Tcl_AppendResult(canvasPtr->interp, "\n", (char *) NULL);
+ 	    charsInLine = 0;
+ 	  }
+ 	}
+       }
+       Tcl_AppendResult(canvasPtr->interp, "\n", (char *) NULL);
+     }
+   }
+   XDestroyImage(imagePtr);
+   return TCL_OK;
  }
  
  /*
*** tk3.2-jp.OLD/tkConfig.c	Wed Jan 12 14:27:39 1994
--- tk3.2-jp.NEW/tkConfig.c	Wed Jan 12 14:28:42 1994
***************
*** 456,461 ****
--- 456,480 ----
  		*((Pixmap *) ptr) = new;
  		break;
  	    }
+             case TK_CONFIG_PIXMAP: {
+                 Pixmap new, old;
+ 
+                 if (nullValue) {
+                     new = None;
+                 } else {
+                     uid = valueIsUid ? (Tk_Uid) value : Tk_GetUid(value);
+                     new = Tk_GetPixmap(interp, tkwin, uid);
+                     if (new == None) {
+                         return TCL_ERROR;
+                     }
+                 }
+                 old = *((Pixmap *) ptr);
+                 if (old != None) {
+                     Tk_FreePixmap(Tk_Display(tkwin), old);
+                 }
+                 *((Pixmap *) ptr) = new;
+                 break;
+             }
  	    case TK_CONFIG_BORDER: {
  		Tk_3DBorder new, old;
  
***************
*** 760,765 ****
--- 779,791 ----
  	    }
  	    break;
  	}
+         case TK_CONFIG_PIXMAP: {
+             Pixmap pixmap = *((Pixmap *) ptr);
+             if (pixmap != None) {
+                 argv[4] = Tk_NameOfPixmap(Tk_Display(tkwin), pixmap);
+             }
+             break;
+         }
  	case TK_CONFIG_BORDER: {
  	    Tk_3DBorder border = *((Tk_3DBorder *) ptr);
  	    if (border != NULL) {
*** tk3.2-jp.OLD/tkMenu.c	Wed Jan 12 14:27:40 1994
--- tk3.2-jp.NEW/tkMenu.c	Wed Jan 12 14:28:43 1994
***************
*** 49,54 ****
--- 49,56 ----
      int underline;		/* Index of character to underline. */
      Pixmap bitmap;		/* Bitmap to display in menu entry, or None.
  				 * If not None then label is ignored. */
+     Pixmap clipMask;            /* Bitmap to specify the clipping mask
+                                  * for transparent pixmaps, or None. */
  #ifdef KANJI
      wchar *accel;
  #else
***************
*** 179,188 ****
  	DEF_MENU_ENTRY_BG, Tk_Offset(MenuEntry, border),
  	COMMAND_MASK|CHECK_BUTTON_MASK|RADIO_BUTTON_MASK|CASCADE_MASK
  	|TK_CONFIG_NULL_OK},
!     {TK_CONFIG_BITMAP, "-bitmap", (char *) NULL, (char *) NULL,
  	DEF_MENU_ENTRY_BITMAP, Tk_Offset(MenuEntry, bitmap),
  	COMMAND_MASK|CHECK_BUTTON_MASK|RADIO_BUTTON_MASK|CASCADE_MASK
  	|TK_CONFIG_NULL_OK},
      {TK_CONFIG_STRING, "-command", (char *) NULL, (char *) NULL,
  	DEF_MENU_ENTRY_COMMAND, Tk_Offset(MenuEntry, command),
  	COMMAND_MASK|CHECK_BUTTON_MASK|RADIO_BUTTON_MASK|CASCADE_MASK},
--- 181,194 ----
  	DEF_MENU_ENTRY_BG, Tk_Offset(MenuEntry, border),
  	COMMAND_MASK|CHECK_BUTTON_MASK|RADIO_BUTTON_MASK|CASCADE_MASK
  	|TK_CONFIG_NULL_OK},
!     {TK_CONFIG_PIXMAP, "-bitmap", (char *) NULL, (char *) NULL,
  	DEF_MENU_ENTRY_BITMAP, Tk_Offset(MenuEntry, bitmap),
  	COMMAND_MASK|CHECK_BUTTON_MASK|RADIO_BUTTON_MASK|CASCADE_MASK
  	|TK_CONFIG_NULL_OK},
+     {TK_CONFIG_BITMAP, "-mask", (char *) NULL, (char *) NULL,
+ 	DEF_MENU_ENTRY_BITMAP, Tk_Offset(MenuEntry, clipMask),
+ 	COMMAND_MASK|CHECK_BUTTON_MASK|RADIO_BUTTON_MASK|CASCADE_MASK
+ 	|TK_CONFIG_NULL_OK},
      {TK_CONFIG_STRING, "-command", (char *) NULL, (char *) NULL,
  	DEF_MENU_ENTRY_COMMAND, Tk_Offset(MenuEntry, command),
  	COMMAND_MASK|CHECK_BUTTON_MASK|RADIO_BUTTON_MASK|CASCADE_MASK},
***************
*** 667,672 ****
--- 673,679 ----
  	mePtr->label = NULL;
  	mePtr->underline = -1;
  	mePtr->bitmap = None;
+ 	mePtr->clipMask = None;
  	mePtr->accel = NULL;
  	mePtr->state = tkNormalUid;
  	mePtr->border = NULL;
***************
*** 1129,1135 ****
  #endif /* KANJI */
      }
      if (mePtr->bitmap != None) {
! 	Tk_FreeBitmap(menuPtr->display, mePtr->bitmap);
      }
      if (mePtr->accel != NULL) {
  #ifdef KANJI
--- 1136,1142 ----
  #endif /* KANJI */
      }
      if (mePtr->bitmap != None) {
! 	Tk_FreePixmap(menuPtr->display, mePtr->bitmap);
      }
      if (mePtr->accel != NULL) {
  #ifdef KANJI
***************
*** 1192,1197 ****
--- 1199,1206 ----
      if (mePtr->offValue != NULL) {
  	ckfree(mePtr->offValue);
      }
+     /* the clipmask itself was already freed */
+     mePtr->clipMask = None;
      ckfree((char *) mePtr);
  }
  
***************
*** 1471,1476 ****
--- 1480,1494 ----
  	}
      }
  
+     if (mePtr->bitmap != None &&
+ 	Tk_GetPixmapClipMask(menuPtr->display, mePtr->bitmap) != None) {
+       if (mePtr->clipMask != None) {
+ 	Tk_FreePixmap(menuPtr->display, mePtr->clipMask);
+       }
+       mePtr->clipMask =
+ 	Tk_GetPixmapClipMask(menuPtr->display, mePtr->bitmap);
+     }
+      
  #ifdef KANJI
      if (mePtr->asciiFontPtr != NULL || mePtr->kanjiFontPtr != NULL) {
  	mePtr->fontPtr = Tk_GetFontSet(
***************
*** 1682,1688 ****
  	if (mePtr->bitmap != None) {
  	    unsigned int bitmapWidth, bitmapHeight;
  
! 	    Tk_SizeOfBitmap(menuPtr->display, mePtr->bitmap,
  		    &bitmapWidth, &bitmapHeight);
  	    mePtr->height = bitmapHeight;
  	    width = bitmapWidth;
--- 1700,1706 ----
  	if (mePtr->bitmap != None) {
  	    unsigned int bitmapWidth, bitmapHeight;
  
!             Tk_SizeOfPixmap(menuPtr->display, mePtr->bitmap,
  		    &bitmapWidth, &bitmapHeight);
  	    mePtr->height = bitmapHeight;
  	    width = bitmapWidth;
***************
*** 1878,1893 ****
  		- fontPtr->descent)/2;
  	if (mePtr->bitmap != None) {
  	    unsigned int width, height;
- 
- 	    Tk_SizeOfBitmap(menuPtr->display, mePtr->bitmap, &width, &height);
- 	    XCopyPlane(menuPtr->display, mePtr->bitmap, Tk_WindowId(tkwin),
  #ifdef KANJI
! 		    gc->fe[0].gc, 0, 0, width, height,
  #else
! 		    gc, 0, 0, width, height,
! #endif /* KANJI */
! 		    menuPtr->borderWidth + menuPtr->selectorSpace,
! 		    (int) (mePtr->y + (mePtr->height - height)/2), 1);
  	} else {
  	    baseline = mePtr->y + (mePtr->height + fontPtr->ascent
  		    - fontPtr->descent)/2;
--- 1896,1948 ----
  		- fontPtr->descent)/2;
  	if (mePtr->bitmap != None) {
  	    unsigned int width, height;
  #ifdef KANJI
! 	    Tk_SizeOfPixmap(menuPtr->display, mePtr->bitmap, &width, &height);
! 	    if (mePtr->clipMask != None) {
! 	      XSetClipOrigin(menuPtr->display, gc->fe[0].gc,
! 			     menuPtr->borderWidth + menuPtr->selectorSpace, 
! 			     (int) (mePtr->y + (mePtr->height - height)/2));
! 	      XSetClipMask(menuPtr->display, gc->fe[0].gc,
! 			   mePtr->clipMask);
! 	    }
! 	    if (Tk_DepthOfPixmap(menuPtr->display, mePtr->bitmap) == 1) {
! 	      XCopyPlane(menuPtr->display, mePtr->bitmap,
! 			 Tk_WindowId(tkwin), gc->fe[0].gc, 0, 0, width, height,
! 			 menuPtr->borderWidth + menuPtr->selectorSpace,
! 			 (int) (mePtr->y + (mePtr->height - height)/2), 1);
! 	    } else {
! 	      XCopyArea(menuPtr->display, mePtr->bitmap,
! 			Tk_WindowId(tkwin), gc->fe[0].gc, 0, 0, width, height,
! 			menuPtr->borderWidth + menuPtr->selectorSpace,
! 			(int) (mePtr->y + (mePtr->height - height)/2));
! 	    }
! 	    if (mePtr->clipMask != None) {
! 	      XSetClipMask(menuPtr->display, gc->fe[0].gc, None);
! 	    }
  #else
! 	    Tk_SizeOfPixmap(menuPtr->display, mePtr->bitmap, &width, &height);
! 	    if (mePtr->clipMask != None) {
! 	      XSetClipOrigin(menuPtr->display, gc,
! 			     menuPtr->borderWidth + menuPtr->selectorSpace, 
! 			     (int) (mePtr->y + (mePtr->height - height)/2));
! 	      XSetClipMask(menuPtr->display, gc,
! 			   mePtr->clipMask);
! 	    }
! 	    if (Tk_DepthOfPixmap(menuPtr->display, mePtr->bitmap) == 1) {
! 	      XCopyPlane(menuPtr->display, mePtr->bitmap,
! 			 Tk_WindowId(tkwin), gc, 0, 0, width, height,
! 			 menuPtr->borderWidth + menuPtr->selectorSpace,
! 			 (int) (mePtr->y + (mePtr->height - height)/2), 1);
! 	    } else {
! 	      XCopyArea(menuPtr->display, mePtr->bitmap,
! 			Tk_WindowId(tkwin), gc, 0, 0, width, height,
! 			menuPtr->borderWidth + menuPtr->selectorSpace,
! 			(int) (mePtr->y + (mePtr->height - height)/2));
! 	    }
! 	    if (mePtr->clipMask != None) {
! 	      XSetClipMask(menuPtr->display, gc, None);
! 	    }
! #endif
  	} else {
  	    baseline = mePtr->y + (mePtr->height + fontPtr->ascent
  		    - fontPtr->descent)/2;
*** tk3.2-jp.OLD/tkMenubutton.c	Wed Jan 12 14:27:40 1994
--- tk3.2-jp.NEW/tkMenubutton.c	Wed Jan 12 14:28:43 1994
***************
*** 61,66 ****
--- 61,68 ----
      Pixmap bitmap;		/* Bitmap to display or None.  If not None
  				 * then text and textVar and underline
  				 * are ignored. */
+     Pixmap clipMask;		/* Bitmap to specify the clipping mask
+ 				 * for transparent pixmaps, or None. */
  
      /*
       * Information used when displaying widget:
***************
*** 176,184 ****
  	(char *) NULL, 0, 0},
      {TK_CONFIG_SYNONYM, "-bg", "background", (char *) NULL,
  	(char *) NULL, 0, 0},
!     {TK_CONFIG_BITMAP, "-bitmap", "bitmap", "Bitmap",
  	DEF_MENUBUTTON_BITMAP, Tk_Offset(MenuButton, bitmap),
  	TK_CONFIG_NULL_OK},
      {TK_CONFIG_PIXELS, "-borderwidth", "borderWidth", "BorderWidth",
  	DEF_MENUBUTTON_BORDER_WIDTH, Tk_Offset(MenuButton, borderWidth), 0},
      {TK_CONFIG_ACTIVE_CURSOR, "-cursor", "cursor", "Cursor",
--- 178,189 ----
  	(char *) NULL, 0, 0},
      {TK_CONFIG_SYNONYM, "-bg", "background", (char *) NULL,
  	(char *) NULL, 0, 0},
!     {TK_CONFIG_PIXMAP, "-bitmap", "bitmap", "Bitmap",
  	DEF_MENUBUTTON_BITMAP, Tk_Offset(MenuButton, bitmap),
  	TK_CONFIG_NULL_OK},
+     {TK_CONFIG_BITMAP, "-mask", "mask", "Mask",
+ 	DEF_MENUBUTTON_BITMAP, Tk_Offset(MenuButton, clipMask),
+ 	TK_CONFIG_NULL_OK},
      {TK_CONFIG_PIXELS, "-borderwidth", "borderWidth", "BorderWidth",
  	DEF_MENUBUTTON_BORDER_WIDTH, Tk_Offset(MenuButton, borderWidth), 0},
      {TK_CONFIG_ACTIVE_CURSOR, "-cursor", "cursor", "Cursor",
***************
*** 312,317 ****
--- 317,323 ----
      mbPtr->underline = -1;
      mbPtr->textVarName = NULL;
      mbPtr->bitmap = None;
+     mbPtr->clipMask = None;
      mbPtr->state = tkNormalUid;
      mbPtr->normalBorder = NULL;
      mbPtr->activeBorder = NULL;
***************
*** 480,486 ****
  	ckfree(mbPtr->textVarName);
      }
      if (mbPtr->bitmap != None) {
! 	Tk_FreeBitmap(mbPtr->display, mbPtr->bitmap);
      }
      if (mbPtr->normalBorder != NULL) {
  	Tk_Free3DBorder(mbPtr->normalBorder);
--- 486,492 ----
  	ckfree(mbPtr->textVarName);
      }
      if (mbPtr->bitmap != None) {
!         Tk_FreePixmap(mbPtr->display, mbPtr->bitmap);
      }
      if (mbPtr->normalBorder != NULL) {
  	Tk_Free3DBorder(mbPtr->normalBorder);
***************
*** 542,547 ****
--- 548,555 ----
      if (mbPtr->cursor != None) {
  	Tk_FreeCursor(mbPtr->display, mbPtr->cursor);
      }
+     /* the clipmask itself was already freed */
+     mbPtr->clipMask = None;
      ckfree((char *) mbPtr);
  }
  
***************
*** 629,635 ****
      gcValues.foreground = mbPtr->normalFg->pixel;
      gcValues.background = Tk_3DBorderColor(mbPtr->normalBorder)->pixel;
  
!     /*
       * Note: GraphicsExpose events are disabled in GC's because they're
       * used to copy stuff from an off-screen pixmap onto the screen (we know
       * that there's no problem with obscured areas).
--- 637,652 ----
      gcValues.foreground = mbPtr->normalFg->pixel;
      gcValues.background = Tk_3DBorderColor(mbPtr->normalBorder)->pixel;
  
!     if (mbPtr->bitmap != None &&
! 	Tk_GetPixmapClipMask(mbPtr->display, mbPtr->bitmap) != None) {
!         if (mbPtr->clipMask != None) {
! 	    Tk_FreePixmap(mbPtr->display, mbPtr->clipMask);
!         }
!         mbPtr->clipMask =
!             Tk_GetPixmapClipMask(mbPtr->display, mbPtr->bitmap);
!     }
!      
!    /*
       * Note: GraphicsExpose events are disabled in GC's because they're
       * used to copy stuff from an off-screen pixmap onto the screen (we know
       * that there's no problem with obscured areas).
***************
*** 841,847 ****
      if (mbPtr->bitmap != None) {
  	unsigned int width, height;
  
! 	Tk_SizeOfBitmap(mbPtr->display, mbPtr->bitmap, &width, &height);
  	switch (mbPtr->anchor) {
  	    case TK_ANCHOR_NW: case TK_ANCHOR_W: case TK_ANCHOR_SW:
  		x += mbPtr->borderWidth + mbPtr->padX;
--- 858,864 ----
      if (mbPtr->bitmap != None) {
  	unsigned int width, height;
  
!         Tk_SizeOfPixmap(mbPtr->display, mbPtr->bitmap, &width, &height);
  	switch (mbPtr->anchor) {
  	    case TK_ANCHOR_NW: case TK_ANCHOR_W: case TK_ANCHOR_SW:
  		x += mbPtr->borderWidth + mbPtr->padX;
***************
*** 867,877 ****
  		break;
  	}
  #ifdef KANJI
! 	XCopyPlane(mbPtr->display, mbPtr->bitmap, pixmap,
! 		gc->fe[0].gc, 0, 0, width, height, x, y, 1);
  #else
! 	XCopyPlane(mbPtr->display, mbPtr->bitmap, pixmap,
! 		gc, 0, 0, width, height, x, y, 1);
  #endif /* KANJI */
      } else {
  	switch (mbPtr->anchor) {
--- 884,920 ----
  		break;
  	}
  #ifdef KANJI
! 	if (mbPtr->clipMask != None) {
! 	  XSetClipOrigin(mbPtr->display, gc->fe[0].gc, x, y);
! 	  XSetClipMask(mbPtr->display, gc->fe[0].gc,
! 		       mbPtr->clipMask);
! 	}
! 	if (Tk_DepthOfPixmap(mbPtr->display, mbPtr->bitmap) == 1) {
! 	  XCopyPlane(mbPtr->display, mbPtr->bitmap, pixmap,
! 		     gc->fe[0].gc, 0, 0, width, height, x, y, 1);
! 	} else {
! 	  XCopyArea(mbPtr->display, mbPtr->bitmap, pixmap,
! 		    gc->fe[0].gc, 0, 0, width, height, x, y);
! 	}
! 	if (mbPtr->clipMask != None) {
! 	  XSetClipMask(mbPtr->display, gc->fe[0].gc, None);
! 	}
  #else
! 	if (mbPtr->clipMask != None) {
! 	  XSetClipOrigin(mbPtr->display, gc, x, y);
! 	  XSetClipMask(mbPtr->display, gc,
! 		       mbPtr->clipMask);
! 	}
! 	if (Tk_DepthOfPixmap(mbPtr->display, mbPtr->bitmap) == 1) {
! 	  XCopyPlane(mbPtr->display, mbPtr->bitmap, pixmap,
! 		     gc, 0, 0, width, height, x, y, 1);
! 	} else {
! 	  XCopyArea(mbPtr->display, mbPtr->bitmap, pixmap,
! 		    gc, 0, 0, width, height, x, y);
! 	}
! 	if (mbPtr->clipMask != None) {
! 	  XSetClipMask(mbPtr->display, gc, None);
! 	}
  #endif /* KANJI */
      } else {
  	switch (mbPtr->anchor) {
***************
*** 1026,1032 ****
      unsigned int width, height;
  
      if (mbPtr->bitmap != None) {
! 	Tk_SizeOfBitmap(mbPtr->display, mbPtr->bitmap, &width, &height);
  	if (mbPtr->width > 0) {
  	    width = mbPtr->width;
  	}
--- 1069,1075 ----
      unsigned int width, height;
  
      if (mbPtr->bitmap != None) {
!         Tk_SizeOfPixmap(mbPtr->display, mbPtr->bitmap, &width, &height);
  	if (mbPtr->width > 0) {
  	    width = mbPtr->width;
  	}
*** tk3.2-jp.OLD/tkWindow.c	Wed Jan 12 14:27:41 1994
--- tk3.2-jp.NEW/tkWindow.c	Wed Jan 12 14:28:44 1994
***************
*** 116,121 ****
--- 116,124 ----
  #endif /* KANJI */
      {"option",		Tk_OptionCmd},
      {"pack",		Tk_PackCmd},
+ #if defined(USE_PINFO)
+     {"pinfo",           Tk_PinfoCmd},
+ #endif
      {"place",		Tk_PlaceCmd},
      {"selection",	Tk_SelectionCmd},
      {"tk",		Tk_TkCmd},
*** tk3.2-jp.OLD/doc/canvas.n	Wed Jan 12 14:27:45 1994
--- tk3.2-jp.NEW/doc/canvas.n	Wed Jan 12 14:28:33 1994
***************
*** 862,867 ****
--- 862,877 ----
  as the destination location for the moved items.
  This command returns an empty string.
  .TP
+ \fIpathName \fBsave \fIfileName\fR \fIformat\fR ?x y width height?
+ Save the contents of the canvas widget to a output file. The
+ type of the output file is defined with the \fIformat\fR option.
+ Currently only the formats \fIbitmap\fR and \fIxpm3\fR are
+ supported. The \fIfileName\fR specifies the output filename. If
+ no position (\fIx\fR, \fIy\fR) and size (\fIwidth\fR, \fIheight\fR)
+ are given the currently visible window is saved. By specifing a
+ position and size the given rectangle is saved.
+ This command returns an empty string.
+ .TP
  \fIpathName \fBscale \fItagOrId xOrigin yOrigin xScale yScale\fR
  Rescale all of the items given by \fItagOrId\fR in canvas coordinate
  space.
