'\"
'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /user6/ouster/tcl/man/RCS/Tcl.man,v 1.89 91/12/20 09:49:44 ouster Exp $ SPRITE (Berkeley)
'
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.HS Tcl tcl
.BS
.SH NAME
accept, connect, filehandler, shutdown \- Opens and handles TCP connections
.BE
.TP
\fBaccept \fIfile\fR
Accepts a connection on an existing server \fIfile\fR (created with the
\fIconnect\fR command) and returns an identifier with may be used in
commands like \fBread\fR, \fBwrite\fR and \fBclose\fR.

If the listening socket is a INET domain socket, the remote machine IP
address and remote port number of the connection are stored as a list in
the global array \fBconnect_info\fR in the element referenced by the
identifier returned from \fBaccept\fR.

If the socket is a UNIX domain socket, then an empty string is stored in
the array \fBconnect_info\fR.
.TP
\fBconnect [\fI"-server"\fR] \fIhost\fR \fIport\fR
Connects to or sets up an INET server with TCP and returns an identifier
that may be used in future invocations of commands.

If \fI"-server"\fR is specified then a listening socket is set up. If \fIhost\fR
is a non-empty string, this specifies the remote address in the same
way as bind(2) does. If \fIhost\fR is an empty string, then any machine
may connect. If
\fIport\fR is empty or 0, then the system will select a port number for you.
The returned identifier may be used in commands like \fBaccept\fR,
\fBclose\fR and \fBfilehandler\fR. The port number of the connection is
saved in the global array \fBconnect_info\fR in the element with the same
name as the returned identifier. You may only use the returned identifier
in the \fBclose\fR, \fBaccept\fR and \fBfilehandler\fR commands.

If \fI"-server"\fR is not specified, then a connection is made to a remote
server. The returned identifier may be used in commands 
like \fBread\fR, \fBwrite\fR, \fBgets\fR, \fBputs\fR
and \fBclose\fR.  \fIhost\fR gives the name of the host to connect to.
\fIport\fR gives the desired port.

Even if every socket is opened for both reading and writing, \fBseek\fR
must not be invoked between a read and a write.
.TP
\fBconnect [\fI"-server"\fR] \fIpath\fR
Set up a UNIX domain socket. This command is identical to the one above
except that a UNIX domain socket is created with an address specified by
\fIpath\fR. An empty string is stored in the global array \fBconnect_info\fR.
.TP
\fBshutdown \fIfile\fR \fIcode\fR
Shutdown a connection for reading, writing or both.

If \fIcode\fR is \fB"0"\fR, \fB"read"\fR or \fB"receives"\fR then further
receives on \fIfile\fR will be disabled.

If \fIcode\fR is \fB"1"\fR, \fB"write"\fR or \fB"sends"\fR, then further
sends on \fIfile\fR will be disabled (and eof will be sent on the socket).

If \fIcode\fR is \fB"2"\fR, \fB"all"\fR or \fB"both"\fR, then further reads and
writes on \fIfile\fR will be disabled.

.TP
\fBfilehandler \fIfile\fR ?\fImode\fR \fIcommand\fR?
The \fBfilehander\fR command is only used with Tk.  The command
specifies a TCL command to be called whenever the given \fIfile\fR can
be read, written, and/or when there is an exeptional condition.  The
\fImode\fR argument indicates the situations when the \fIcommand\fR
will be called.  It may be any combination of the following values:
.RS
.TP
\fBr\fR
Call \fIcommand\fR whenever the there is data to read from the socket.
The command procedure is called with two arguemnts: \fBr\fR to
indicate that there is something to read, and a \fIfile\fR id
that can be used for reading.  The procedure should read at least some
data from the socket, or otherwise the procedure will be called
continuously. 
.TP
\fBw\fR
Call \fIcommand\fR whenever data can be written to the socket.  This
option is rarely used since most sockets can be written most of the time.
.TP
\fBe\fR
Call \fIcommand\fR whenever there is an exceptional condition pending
on the socket.  The \fIcommand\fR procedure is called with two
arguments: an \fBe\fR to indicate exception, and a \fIfile\fR id that
can be used as an argument to \fBread\fR, \fBclose\fR etc.
.PP
The same \fIcommand\fR may be used for several different conditions.
The first argument supplied to \fIcommand\fR denotes always the
condition type.  If there are several different conditions (e.g. the
file can be both read and written), the \fIcommand\fR will be called
separately for each condition.

Specifying a new command with \fBfilehandler\fR will remove any
earlier command from use.  NOTE!  Currently there is a small memory
leak whenever a new command replaces an existing one.

When a \fIcommand\fR procedure is specified for the socket via
\fBfilehandler\fR command, the socket will be automatically closed and the
associated file handler deleted if there is a pending eof or error
condition after executing the user supplied \fIcommand\fR procedure.
.SH AUTHOR
Pekka Nikander, Telecom Finland (Pekka.Nikander@ajk.tele.fi)
Extended by Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
