/*
 * (C) J.W.Hawtin 6/12/93
 * jwh@cs.bham.ac.uk
 * AKA Admirial wibble
 *
 * Permission is give to copy and change the code so long as it program is
 * never sold, when distributed the full source is made available, and this
 * header is never removed.

 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <string.h>
#include <strings.h>
#include <signal.h>

#define MAXSTRLEN 1024
#define LIST_SIZE 16*MAXSTRLEN

#define TRUE 1
#define FALSE 0

int sock, finished, stdn;

#define pe(a) if (stdn==FALSE) printf("%s\n",a); else perror(a)

/* For some odd systems, which don't put this in errno.h. */

extern int errno;

int connect_to(st,port)			/* Try to make a connection. */
char *st;
int port;
{
  struct in_addr host_address;
  struct sockaddr_in socket_address;
  int err;
    
  if (!get_host_address(st, &host_address)) { /* Can't do it. */
    return(0);
  }
  
  socket_address.sin_family = AF_INET;
  socket_address.sin_port = htons(port);
  bcopy(&host_address, &socket_address.sin_addr, sizeof(struct in_addr));
  
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    pe("% Couldn't open socket");
    return(0);
  }
  
  err = connect(sock, &socket_address, sizeof(struct sockaddr_in));
  if (err < 0) {
    pe("% Couldn't connect to socket");
    return(0);
  }
  
#ifdef FNDELAY
  fcntl(sock, F_SETFL, FNDELAY);    /* Do we need this? */
#endif

  return(1);				/* Success! */
}

int get_host_address(name, addr)	/* Get a host address. */
  register char *name;
  register struct in_addr *addr;
{
  struct hostent *blob;
  union {				/* %#@!%!@%#!@ idiot who designed */
    long signed_thingy;			/* the inetaddr routine.... */
    unsigned long unsigned_thingy;
  } thingy;

  if (*name == '\0') {
    pe("%% No host address specified.");
    exit (0);
  }

  if ((*name >= '0') && (*name <= '9')) {	/* IP address. */
    addr->s_addr = inet_addr(name);
    thingy.unsigned_thingy = addr->s_addr;
    if (thingy.signed_thingy == -1) {
      printf("%% Couldn't find host %s\n", name);
      exit (0);
    }
  }
  else {				/* Host name. */
    blob = gethostbyname(name);

    if (blob == NULL) {
      printf("%% Couldn't find host %s\n", name);
      exit (0);
    }

    bcopy(blob->h_addr, addr, sizeof(struct in_addr));
  }

  return (1);				/* Success. */
}

disconnect()		 /* Disconnect from current world. */
{
  close(sock);
}

transmit(s, l)
  char *s;
  int l;
{
  register int err;

  err = send(sock, s, l, 0);
  if (err == -1)
    pe("send failed\n");  
}

receive(s)
register char *s;
{
  register int count;
  
  count = recv(sock, s, MAXSTRLEN, 0);
  if (count == -1)
    if (errno == EWOULDBLOCK)
      s[0] = '\0';
    else
      pe("recv failed");
  else
    s[count] = '\0';

  if (count <= 0)                       /* Check for end of message. */
    finished = TRUE;
}


int read_port(host, port)
char *host;
int port;
{
  char s[MAXSTRLEN+10], line[100];
  fd_set readers, exceptions;
  int count, chrs = 0, ret;
  int connected=0;
  
  finished = FALSE;
  
  if (connect_to(host,port)==1)
  {
    sleep(2);
    while(finished==FALSE)
    {
      
      /* setup so multiplex checks socket */
      FD_ZERO(&exceptions);
      FD_ZERO(&readers);
      FD_SET(sock, &readers);   /* Check socket. */
      
      count = select(sock + 1, &readers, NULL, &exceptions, NULL);
      if (count == -1)
      {
	if (errno != EINTR)
	  pe("select");
      }
      else
	if (count!=0)
	{
	  if (FD_ISSET(sock, &readers))
	  {
	    receive(s);
	    printf("%s",s);
	  }
	}
    }
    disconnect();
    connected =1;
  }
  else
  {
  }

}


main(argc, argv)
int     argc;
char    *argv[];
{
  int port, count=argc-1;
  char *name, **ptr;
  
  stdn=TRUE;
  
  if (count>1)
  {
    ptr=argv;
    
    ptr++;
    
    if (strcmp(*ptr,"-s")==0)
    {
      stdn=FALSE;
      ptr++;
      count--;
    }
    if (count==2)
    {
      name=*ptr++;
      port=atoi(*ptr);
      read_port(name,port);
      exit(TRUE);
    }
  }
  fprintf(stderr,"Usage: %s [-s] host port\n",*argv); 
  exit(FALSE);
}



