# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Number Dialog
#
# Commands
#
#	get_number <leader> <title> <label> <min> <max> <tick> <init> <var>
#		Get a number in the range <min>..<max> rounded to the
#		nearest <tick>.  The initial displayed value is <init>.
#		<title> is used to prompt the user.  If the user
#		confirms the selection, set <var> to the selected number
#		and return true.  Else return false.

# Hidden global variables
#
#	num_init		Created num dialog window?
#	num_done		Is num interaction finished

set num_init 0
set num_done 0

proc get_number {leader title label min max tick init var} {
    num_make

    set result [num_interact $leader $title $label $min $max $tick $init]
    if $result {
	upvar $var returnVar
	set returnVar [.number_dialog.scale get]
    }
    return $result
}

proc num_make {} {
    global num_init num_done
    if {$num_init} {return}
    set num_init 1

    set f .number_dialog

    toplevel $f -class Dialog
    wm title $f Dialog
    wm protocol $f WM_DELETE_WINDOW {set num_done 0}

    frame $f.top -relief raised -bd 1
    frame $f.bot -relief raised -bd 1
    frame $f.bot.default -relief sunken -bd 1

    scale $f.scale -orient horizontal -length 3i -showvalue 1
    pack append $f.top $f.scale {top expand padx 5m pady 5m}

    button $f.yes -text Okay -command {set num_done 1}
    button $f.no -text Cancel -command {set num_done 0}

    pack append $f.bot.default $f.yes {left padx 3m pady 3m}

    pack append $f.bot $f.no {left expand padx 5m pady 5m}
    pack append $f.bot $f.bot.default {left expand}

    pack append $f $f.top {top expand fill}
    pack append $f $f.bot {bottom fill}

    bind $f <Control-c> {set num_done 0}
    bind $f <Return>    {set num_done 1}

    wm withdraw $f
    update
}

proc num_interact {leader title label min max tick init} {
    global num_done
    set f .number_dialog

    # Fix dialog contents
    $f.scale configure -from $min -to $max -tickinterval $tick -label $label
    $f.scale set $init
    wm title $f $title

    # Run dialog
    set num_done -1
    dialog_run $leader $f $f num_done

    return $num_done
}
