#!/usr/local/bin/wish -f

# sample_application shows how to embed evaluate_parameters into your application.

source "src/evap.tcl"

proc setup_for_evap {Q command} { 

    # Simply read the PDT and MM files and initialize the evap variables for the specified package.

    global ${Q}PDT ${Q}MM

    set IN [open "pdt/${command}_pdt" "r"]
    set ${Q}PDT [split [read $IN] \n];                      # initialize Parameter Description Table
    close $IN
    set IN [open "mm/${command}.mm" "r"]
    set ${Q}MM [split [string trimright [read $IN] \n] \n]; # initialize Message Module
    close $IN

}; # end setup_for_evap

# sample_application command processors follow, in alphabetical order.

proc exi_proc {} {

    set Q "exi_pkg_"; setup_for_evap "$Q" "exi"
    global ${Q}PDT ${Q}MM ${Q}Options
    if { [evap [set ${Q}PDT] [set ${Q}MM] $Q]  != 1 } { return }

    puts -nonewline stdout "Have a nice day!\n"
    exit 0

}; # end exi_proc

proc samc_proc {} {

    global argc argv evap_Help_Hooks

    set Q "samc_pkg_"; setup_for_evap "$Q" "samc"
    global ${Q}PDT ${Q}MM ${Q}Options
    set evap_Help_Hooks(P_HHUOFL) " \[Color_List\]\n"
    set evap_Help_Hooks(P_HHBOFL) "\nA Color_List is optionally required by this command.\n\n"
    if { [evap [set ${Q}PDT] [set ${Q}MM] $Q] != 1 } { return }

    puts -nonewline stdout "In sub samc_proc, value of option `id' = `[set ${Q}Options(id)]'.\n"
    foreach color $argv {
        puts -nonewline stdout "  color = $color\n"
    }

}; # end samc_proc

# Main.

set commands(exit|exi) "exi_proc"; set commands(sample_command|samc) "samc_proc"

setup_for_evap "" "sama"
evap $PDT $MM;                 # evaluate_parameters for sample_application

# Let evaluate_parameters process all user input for the application, and then call the actual command processor.

if { $Options(input) == "stdin" } {
    set I "$Options(input)"
} else {
    set I [open "$Options(input)" "r"]
}

evap_pac "sama>" $I commands; # process application commands

close $I
exit 0
