# Implements a text widget for browsing and editing
# Also a few functions to manipulate label and entry widgets and manage focus.

# For arbitrary symbol generation

global symname symnum
set symname "sym"
set symnum 0

# Returns a new symbol upon each call
proc gensym {} {
  global symname symnum
  incr symnum
  return $symname$symnum
}


# Label creation procedures.

# Time to display labels
set flash_time 3000

# Displays a label for $flash_time seconds. Label lives in $parent.
# Args gets passed to the label as configuration options.
proc flash_label {parent args} {
	global flash_time
	if {($parent == ".")} {set newlabel ".m[gensym]"
	} else {set newlabel "$parent.m[gensym]"}
# Bug in that this label gets text configs after entering a horiz grid.
# so we destroy & recreate it. (a workaround)
	eval label $newlabel $args
	destroy $newlabel
	eval label $newlabel $args
	pack $newlabel -side left
	after $flash_time "destroy $newlabel"
}

# An abbreviation to show in labels in lieu of their normal contents.
set label_abbrev "-"

# Toggles a label between its normal contents and $label_abbrev
proc label_expand_toggle {label variable} {
	global label_abbrev
	if {($variable == [lindex [$label configure -textvariable] 4])} {
		$label configure -textvariable "" -text $label_abbrev
	} else {$label configure -textvariable $variable
}}

# Binds MB1 to toggle between label's normal display and an abbreviated one.
proc label_expand_bind {label variable} {
	$label configure -textvariable $variable -relief flat
	bind $label <ButtonRelease-1> "label_expand_toggle %W $variable"
}


# Procedures for filling the text widget.

# Updates the display iff it is not getting choked with data.
proc update_text_display {t} {
	after 100 "if {[$t index insert] == \[$t index insert\]} {
			if {[$t compare insert == new_stuff]} {
				$t yview -pickplace insert}
			update idletasks ; update}"
}

# Reads file a line at a time, and updates t per line.
# Since Tk can only handle events immediately after a line is read, this
# causes many problems, besides being a pain if the command is slow.
proc read_file_graduated {t file} {
	set v [lindex [$t configure -height] 4] ; incr v -1
	while {![eof $file]} {
		$t insert new_stuff [gets $file]
		$t insert new_stuff \n
		update_text_display $t
		global graduated_interrupt
		if $graduated_interrupt break
}}

# The 'better' way to handle background file reading.
proc addinput_read {t f events} {
#	if {"$events" != "READ"} {error "Unexpected events: $events"}
	global graduated_interrupt
	set result [gets $f line]
	if {$graduated_interrupt || ($result < 0)} {
	        removeinput $f
		global addinput_done
		set addinput_done 1
		return
	}
	$t insert new_stuff "$line\n"
	update_text_display $t
}

# fills text widget t with contents from $file, which must be opened for
# reading. Does not clear text widget.
proc read_file_handler {t index file {graduated 0}} {
	if $graduated {
		# Enable user to interrupt with a C-g.
		set binding [bind $t <Control-g>]
		global graduated_interrupt;	set graduated_interrupt 0
		bind $t <Control-g> "set graduated_interrupt 1 ; beep"
		$t mark set new_stuff $index
		# Use addinput extension, if possible
		if {[info commands addinput] == ""} {
			read_file_graduated $t $file
		} else {global addinput_done ; set addinput_done 0
			addinput $file "addinput_read $t %F %E"
			tkwait variable addinput_done
		}
		bind $t <Control-g> $binding
		$t mark unset new_stuff
	} else {set index [$t index insert]
		$t insert $index [read $file]
}}

set use_pipe 0
set gradual_io 1

# Opens up $path/$name or just $name if it is a command pipeline, and
# fills text widget t with its contents. w/o clearing text widget first.
proc load_and_insert_file {t index f path name} {
	cd $path
	set graduated 0
	global use_pipe gradual_io
	if {([string match \|* $name]) || $use_pipe} {
		set name "| [string trimleft $name {|}]"
		if {[string match *\& $name] || $gradual_io} {
			set name [string trimright $name {&}]
			set graduated 1}
		set file [open $name r]
	} elseif {[catch {set file [open $path/$name r]}]} {
		flash_label $f -text "New file: $path/$name"
		return
	}
	beth_busy $t read_file_handler $t $index "$file" $graduated
	beth_busy $t close "$file"
}

# Like load_and_insert_file but clears text widget first.
proc load_file {t index f path name} {
	$t delete 1.0 end
	load_and_insert_file $t $index $f $path $name
}


# Create the text widget (if it doesn't already exist) and scrollbar.
set text_configs [eval concat $text_configs]
if {(![info exists text])} {
	frame .ts
	set text .ts.text

	eval text $text $text_configs -relief sunken -setgrid true \
		-yscrollcommand [list [list .ts.s set]]
	focus default $text
	focus $text
	catch {scrollbar .ts.s -relief raised -command "$text yview"}
	pack $text -in .ts -side right -expand yes -fill both
	pack .ts.s -in .ts -side right -fill y
	pack .ts -in . -side bottom -expand yes -fill both
}

# Create the frame widget (if it doesn't already exist)
if {(![info exists frame])} {
	set frame .frame
	catch {frame $frame -relief raised}
	catch {entry $frame.e -relief sunken -bd 2}
	$frame.e insert end [winfo name .]
	$frame.e configure -state disabled -width 5
	parse_bindings $frame.e {B1-Motion A-ButtonPress-1} \
			{$frame.e select from 0 ; $frame.e select to end}
	pack $frame.e -side left
	pack $frame -side bottom -fill x -before .ts
	update
	pack propagate $frame 0
}

# Create the quit button (if user wants)
if {(![info exists dont_make_quit])} {
	catch {button $frame.q -text "Quit" -command "quit_beth"}
	pack $frame.q -side right -expand yes -fill x
}

# All Text bindings are disabled; they are re-enabled in other files.
foreach binding [bind Text] {
	if {[string match "*Key*" $binding]} {
		bind Text $binding ""}}

# Set of widgets to switch focus around
set focus_list "$text"

proc switch_focus {} {
	global focus_list
	set old_focus [focus]
	set index [lsearch $focus_list $old_focus]
	incr index
	if {$index == [llength $focus_list]} {set index 0}
	focus [lindex $focus_list $index]
	if {$old_focus == [focus]} {beep}
}

# For when a completion is ambiguous or erroneous
global completion_message
set completion_message ""

global entry_count
set entry_count 0

# Creates an entry & label and sets focus to the entry. ESC toggles between
# entry and t, which can be any other widget.
# t, label, and entry should be absolute widget names.
# Args are extra completions to try before doing the default completions.
proc create_f_entry {t label entry args} {
	if {![winfo exists $label]} {
		global menu entry_count ; incr entry_count
		if {($entry_count == 1) && [winfo exists $menu]} {
			$menu.entry configure -state normal
			global edit_flag
			if {!$edit_flag} {$menu.edit configure -state normal}
		}
# Bug in that this label gets text configs after entering a horiz grid.
# so we destroy & recreate it. (a workaround)
		label $label -relief raised -height 1
		destroy $label
		label $label -relief raised -height 1
		entry $entry
		pack $label -side left -fill none -expand 0
		pack $entry -side left -expand yes -fill x
	
		global default_completions focus_list
		bind $entry <Tab> "e_complete_multiple %W [list [concat \
					$args $default_completions]]"
		set focus_list [concat $focus_list $entry]
	}
	focus $entry
}

# Destroys label and entry created by create_f_entry.
proc destroy_f_entry {t label entry} {
	global menu entry_count ; incr entry_count -1
	if {($entry_count < 0)} {set entry_count 0}
	if {($entry_count == 0) && [winfo exists $menu]} {
		$menu.entry configure -state disabled
		global edit_flag
		if {!$edit_flag} {$menu.edit configure -state normal}}
	destroy $label ; destroy $entry
	global focus_list
	set index [lsearch $focus_list $entry]
	set focus_list [lreplace $focus_list $index $index]
}
