; Wb-tree File Based Associative String Data Base System.
; Copyright (c) 1991, 1992, 1993 Holland Mark Martin
;
;Permission to use, copy, modify, and distribute this software and its
;documentation for educational, research, and non-profit purposes and
;without fee is hereby granted, provided that the above copyright
;notice appear in all copies and that both that copyright notice and
;this permission notice appear in supporting documentation, and that
;the name of Holland Mark Martin not be used in advertising or
;publicity pertaining to distribution of the software without specific,
;written prior consent in each case.  Permission to incorporate this
;software into commercial products can be obtained from Jonathan
;Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
;01803-4467, USA.  Holland Mark Martin makes no representations about
;the suitability or correctness of this software for any purpose.  It
;is provided "as is" without express or implied warranty.  Holland Mark
;Martin is under no obligation to provide any services, by way of
;maintenance, update, or otherwise.

;;; routines in this file return pass/fail (#t/#f)

(require (in-vicinity (program-vicinity) "sys"))

(define io-diag #f)

(define (init-filesystem!) #f)

(define (min-file-blk-size name) 128)

(define (blk-file-create name bsiz)
  (open-output-file name))

(define (blk-file-open-modify name bsiz)
  (open-io-file name))

(define (blk-file-open-read-only name bsiz)
  (open-input-file name))

(define (blk-file-close file) (close-io-port file))

(define (blk-read file blk bsiz blknum)
  (file-set-position file (* bsiz blknum))
  (cond ((= bsiz (read-string file blk bsiz))
	 (if io-diag (fprintf diagout "rd:%*.c %10.ld\\n"
			      (+ 1 (- (BLK-LEVEL blk) LEAF)) (BLK-TYP blk) blknum))
	 (if (BLK-TYP? blk FRL-TYP)
	     (set! read-fl-ct (+ read-fl-ct 1))
	     (set! read-ct (+ read-ct 1)))
	 #t)
	(else
	 (fprintf diagout ">>>>ERROR<<<< couldn't read blk %ld\\n"
		  blknum)
	 #f)))

(define (blk-write file blk bsiz blknum)
  (file-set-position file (* bsiz blknum))
  (cond ((= bsiz (write-string file blk bsiz))
	 (if io-diag (fprintf diagout "wr:%*.c %10.ld\\n"
			      (+ 1 (- (BLK-LEVEL blk) LEAF)) (BLK-TYP blk) blknum))
	 (if (BLK-TYP? blk FRL-TYP)
	     (set! write-fl-ct (+ write-fl-ct 1))
	     (set! write-ct (+ write-ct 1)))
	 #t)
	(else
	 (fprintf diagout ">>>>ERROR<<<< couldn't write blk %ld\\n"
		  blknum)
	 #f)))

(define (extend-file file blk bsiz blknum)
  (file-set-position file (* bsiz blknum))
  (cond ((= bsiz (write-string file blk bsiz))
	 (if io-diag (fprintf diagout "Extending file %d blks\\n"
			      (+ (quotient FLC-LEN 2) 1)))
	 #t)
	(else
	 (fprintf diagout ">>>>ERROR<<<< couldn't extend file %ld\\n"
		  blknum)
	 #f)))
