NAME
====

I18n::Simple

AUTHOR
======

Patrick Spek <p.spek@tyil.work>

VERSION
=======

0.0.0

Description
===========

A simple internationalisation module.

Installation
============

Install this module through [zef](https://github.com/ugexe/zef):

```sh
zef install Text::I18n
```

Using the module
================

Examples
========

Take the following YAML file, and save it in your module's `resources` directory. These examples assume the file being saved at `resources/i18n/en.yml`.

    ---
    foo: This is a template!
    bar: This template is for you, $(user).

Then use the module as follows:

    use I18n::Simple;

    # Load the templates. You can make the `en` part a variable to easily switch
    # between different languages in your program.
    i18n-init(%?RESOURCES<i18n/en.yml>);

    # Call a template without placeholders
    dd i18n("foo"); # "This is a template!"

    # Call a template with placeholders
    dd i18n("bar", user => "Bob"); # "This template is for you, Bob."

License
=======

This module is distributed under the terms of the AGPL-3.0.

