[![Build Status](https://travis-ci.org/scriptkitties/p6-Config.svg?branch=master)](https://travis-ci.org/scriptkitties/p6-Config)

### method clear

```
method clear() returns Mu
```

Clear the config.

### method get

```
method get() returns Mu
```

Return the entire config hash.

### method get

```
method get(
    Nil $key, 
    $default = Nil
) returns Mu
```

Fallback method in case the key is Nil. Will always return the default value.

### method get

```
method get(
    Str $key, 
    $default = Nil
) returns Mu
```

Get a value from the config object. To get a nested key, use a . to descent a level.

### method get

```
method get(
    List $keyparts, 
    $default = Nil
) returns Mu
```

Get a value from the config object using a list to indicate the nested key to get.

### method get-parser

```
method get-parser(
    Str $path, 
    Str $parser = ""
) returns Str
```

Get the name of the parser module to use for the given path.

### method get-parser-type

```
method get-parser-type(
    Str $path
) returns Str
```

Get the type of parser required for the given path.

### method has

```
method has(
    Str $key
) returns Mu
```

Check wether a given key exists.

### method has

```
method has(
    List $keyparts
) returns Mu
```

Check wether a given key exists using a list to supply the nested key to check.

### method read

```
method read() returns Mu
```

Reload the configuration. Requires the configuration to have been loaded from a file.

### method read

```
method read(
    Str $path, 
    Str $parser = "", 
    Bool :$skip-not-found = Bool::False
) returns Mu
```

Load a configuration file from the given path. Optionally set a parser module name to use. If not set, Config will attempt to deduce the parser to use.

### method read

```
method read(
    List $paths, 
    Str $parser = "", 
    Bool :$skip-not-found = Bool::False
) returns Mu
```

Read a list of paths. Will fail on the first file that fails to load for whatever reason. If no files could be loaded, the method will return False.

### method read

```
method read(
    Hash $hash
) returns Mu
```

Read a plain Hash into the configuration.

### method set

```
method set(
    Str $key, 
    $value
) returns Mu
```

Set a single key to a given value;

### method write

```
method write(
    Str $path, 
    Str $parser = ""
) returns Mu
```

Write the current configuration to the given path. If no parser is given, it tries to use the parser that was used when loading the configuration.
