use 5.14.0;
use strict;
use warnings;

our $VERSION = '0.1302'; # VERSION
# ABSTRACT: Common imports

package OpenGbg::Standard::Imports {

    use base 'Moops';
    use OpenGbg::Types();
    use MooseX::AttributeShortcuts();

    sub import {
        my $class = shift;
        my %opts = @_;

        push @{ $opts{'imports'} ||= [] } => (
            'feature'           => [qw/:5.14/],
            'OpenGbg::Types'    => [{ replace => 1 }, '-types'],
            'MooseX::AttributeShortcuts' => [],
        );

        $class->SUPER::import(%opts);
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

OpenGbg::Standard::Imports - Common imports

=head1 VERSION

Version 0.1302, released 2015-01-17.

=head1 SOURCE

L<https://github.com/Csson/p5-OpenGbg>

=head1 HOMEPAGE

L<https://metacpan.org/release/OpenGbg>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
