use v6;

use Test;
use lib <lib>;

use HTML::BoreDOM;

plan 2;

use-ok "HTML::BoreDOM";

my ($html, $expect);

$html =
h("html",
 h("head",
  h("title", "Hello, World!")),
 h("body",
  h("h1", "An Unexpected Party"),
  h("p", "In a hole in the ground there lived a hobbit.")));

$expect = Q:to<EOF>;
<html>
<head>
<title>Hello, World!</title>
</head>
<body>
<h1>An Unexpected Party</h1>
<p>In a hole in the ground there lived a hobbit.</p>
</body>
</html>
EOF

is $html, $expect, "h() stringifies to HTML";

done-testing;
