package Dist::Zilla::Plugin::For::App::shcompgen;

our $DATE = '2016-05-15'; # DATE
our $VERSION = '0.04'; # VERSION

use 5.010001;
use strict;
use warnings;
use utf8;

use Moose;
use namespace::autoclean;

use List::Util qw(first);

with (
    'Dist::Zilla::Role::InstallTool',
);

sub setup_installer {
  my ($self) = @_;

  # first, try MakeMaker
  my $build_script = first { $_->name eq 'Makefile.PL' }
      @{ $self->zilla->files };
  $self->log_fatal('No Makefile.PL found. Using [MakeMaker] is required')
      unless $build_script;

  my $content = $build_script->content;

  no strict 'refs';
  my $header = "
# modify generated Makefile to run 'shcompgen init' & 'shcompgen generate'\n".
"# during installation. this piece is generated by " . __PACKAGE__ . " version " .
    (${__PACKAGE__ ."::VERSION"} // 'dev').".\n";

  my $body = <<'_';
SHCOMPGEN_INIT:
{
    print "Modifying Makefile to run 'shcompgen init' & 'shcompgen generate'\n";
    open my($fh), "<", "Makefile" or die "Can't open generated Makefile: $!";
    my $content = do { local $/; ~~<$fh> };

    $content =~ s/^(install :: pure_install doc_install)/$1 shcompgen_init/m
        or die "Can't find pattern in Makefile (1)";

    # apparently we can't put $ in the Makefile
    $content .= qq|\nshcompgen_init :\n\t| .
        q|$(PERLRUN) -E'require App::shcompgen; my %args; App::shcompgen::_set_args_defaults(\%args); say App::shcompgen::init(%args)->[2]; App::shcompgen::generate(%args, replace=>1, remove=>1)'| .
        qq|\n\n|;

    open $fh, ">", "Makefile" or die "Can't write modified Makefile: $!";
    print $fh $content;
}
_

  $content .= $header . $body;

  return $build_script->content($content);
}

no Moose;
1;
# ABSTRACT: Plugin for building App-shcompgen distribution

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::For::App::shcompgen - Plugin for building App-shcompgen distribution

=head1 VERSION

This document describes version 0.04 of Dist::Zilla::Plugin::For::App::shcompgen (from Perl distribution Dist-Zilla-Plugin-For-App-shcompgen), released on 2016-05-15.

=head1 SYNOPSIS

In F<dist.ini>:

 [For::App::shcompgen]

=head1 DESCRIPTION

This plugin is meant only for building C<App-shcompgen> distribution (see
L<App::shcompgen>). Currently what it does:

=over

=item * Modify F<Makefile.PL> so F<Makefile> will run C<shcompgen init> & C<shcompgen generate> when distribution is installed

This allows initialization of L<shcompgen> after installation, so it's ready for
use.

=back

=for Pod::Coverage ^(setup_installer)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-For-App-shcompgen>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-shcompgen-InitOnInstall>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-For-App-shcompgen>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<shcompgen>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
