package RT::Extension::PushoverNotify;

use 5.10.1;
use strict;
use warnings FATAL => 'all';

=head1 NAME

RT::Extension::PushoverNotify - integrate Pushover notifications for Request Tracker

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

See the perldoc for RT::Action::Pushover

=head1 AUTHOR

Craig Ringer, C<< <ringerc at cpan.org> >>

=head1 BUGS

Feel free to report bugs and send patches to C<bug-rt-extension-pushovernotify at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=RT-Extension-PushoverNotify>.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc RT::Extension::PushoverNotify

and

    perldoc RT::Action::PushoverNotify

This module is supplied as-is and isn't supported by ShiftPlanning.com,
BestPractical, or by the author. If you need help, you might have some luck on
the Request Tracker mailing list or ShiftPlanning.com forums.

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=RT-Extension-PushoverNotify>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/RT-Extension-PushoverNotify>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/RT-Extension-PushoverNotify>

=item * Search CPAN

L<http://search.cpan.org/dist/RT-Extension-PushoverNotify/>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2013 2ndQuadrant

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See L<http://dev.perl.org/licenses/> for more information.

=cut

1; # End of RT::Extension::PushoverNotify
