/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.metadata.quality.Scope;
import org.opengis.util.InternationalString;

@XmlType(name="LI_Lineage_Type", propOrder={"statement", "processSteps", "sources"})
@XmlRootElement(name="LI_Lineage")
public class DefaultLineage
extends ISOMetadata
implements Lineage {
    private static final long serialVersionUID = 6214461492323186254L;
    private InternationalString statement;
    private Scope scope;
    private Collection<Citation> additionalDocumentation;
    private Collection<ProcessStep> processSteps;
    private Collection<Source> sources;

    public DefaultLineage() {
    }

    public DefaultLineage(Lineage lineage) {
        super(lineage);
        if (lineage != null) {
            this.statement = lineage.getStatement();
            this.processSteps = this.copyCollection(lineage.getProcessSteps(), ProcessStep.class);
            this.sources = this.copyCollection(lineage.getSources(), Source.class);
            if (lineage instanceof DefaultLineage) {
                this.scope = ((DefaultLineage)lineage).getScope();
                this.additionalDocumentation = this.copyCollection(((DefaultLineage)lineage).getAdditionalDocumentation(), Citation.class);
            }
        }
    }

    public static DefaultLineage castOrCopy(Lineage lineage) {
        if (lineage == null || lineage instanceof DefaultLineage) {
            return (DefaultLineage)lineage;
        }
        return new DefaultLineage(lineage);
    }

    @Override
    @XmlElement(name="statement")
    public InternationalString getStatement() {
        return this.statement;
    }

    public void setStatement(InternationalString internationalString) {
        this.checkWritePermission();
        this.statement = internationalString;
    }

    @UML(identifier="scope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.checkWritePermission();
        this.scope = scope;
    }

    @UML(identifier="additionalDocumentation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAdditionalDocumentation() {
        this.additionalDocumentation = this.nonNullCollection(this.additionalDocumentation, Citation.class);
        return this.additionalDocumentation;
    }

    public void setAdditionalDocumentation(Collection<? extends Citation> collection) {
        this.additionalDocumentation = this.writeCollection(collection, this.additionalDocumentation, Citation.class);
    }

    @XmlElement(name="processStep")
    public Collection<ProcessStep> getProcessSteps() {
        this.processSteps = this.nonNullCollection(this.processSteps, ProcessStep.class);
        return this.processSteps;
    }

    public void setProcessSteps(Collection<? extends ProcessStep> collection) {
        this.processSteps = this.writeCollection(collection, this.processSteps, ProcessStep.class);
    }

    @XmlElement(name="source")
    public Collection<Source> getSources() {
        this.sources = this.nonNullCollection(this.sources, Source.class);
        return this.sources;
    }

    public void setSources(Collection<? extends Source> collection) {
        this.sources = this.writeCollection(collection, this.sources, Source.class);
    }
}

