package WWW::Hetzner::CLI::Cmd::Image;
our $VERSION = '0.001';
our $AUTHORITY = 'cpan:GETTY';

# ABSTRACT: Image commands

use Moo;
use MooX::Cmd;
use MooX::Options usage_string => 'USAGE: hcloud.pl image [--type system|snapshot|backup] [options]';
use JSON::MaybeXS qw(encode_json);

option type => (
    is      => 'ro',
    format  => 's',
    doc     => 'Filter by type (system, snapshot, backup)',
);

sub execute {
    my ($self, $args, $chain) = @_;

    my $main = $chain->[0];
    my $cloud = $main->cloud;

    my %params;
    $params{type} = $self->type if $self->type;

    my $images = $cloud->images->list(%params);

    if ($main->output eq 'json') {
        print encode_json($images), "\n";
        return;
    }

    printf "%-10s %-20s %-10s %-15s %s\n",
        'ID', 'NAME', 'TYPE', 'OS', 'STATUS';
    print "-" x 70, "\n";

    for my $i (@$images) {
        printf "%-10s %-20s %-10s %-15s %s\n",
            $i->{id},
            $i->{name} // '-',
            $i->{type},
            ($i->{os_flavor} // '') . ' ' . ($i->{os_version} // ''),
            $i->{status};
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::Hetzner::CLI::Cmd::Image - Image commands

=head1 VERSION

version 0.001

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/Getty/p5-www-hetzner>

  git clone https://github.com/Getty/p5-www-hetzner.git

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
