# Generated by default/object.tt
package Paws::Batch::ComputeResourceUpdate;
  use Moose;
  has DesiredvCpus => (is => 'ro', isa => 'Int', request_name => 'desiredvCpus', traits => ['NameInRequest']);
  has MaxvCpus => (is => 'ro', isa => 'Int', request_name => 'maxvCpus', traits => ['NameInRequest']);
  has MinvCpus => (is => 'ro', isa => 'Int', request_name => 'minvCpus', traits => ['NameInRequest']);
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'securityGroupIds', traits => ['NameInRequest']);
  has Subnets => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'subnets', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Batch::ComputeResourceUpdate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Batch::ComputeResourceUpdate object:

  $service_obj->Method(Att1 => { DesiredvCpus => $value, ..., Subnets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Batch::ComputeResourceUpdate object:

  $result = $service_obj->Method(...);
  $result->Att1->DesiredvCpus

=head1 DESCRIPTION

An object representing the attributes of a compute environment that can
be updated. For more information, see Compute Environments
(https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html)
in the I<AWS Batch User Guide>.

=head1 ATTRIBUTES


=head2 DesiredvCpus => Int

The desired number of Amazon EC2 vCPUS in the compute environment.

This parameter isn't applicable to jobs running on Fargate resources,
and shouldn't be specified.


=head2 MaxvCpus => Int

The maximum number of Amazon EC2 vCPUs that an environment can reach.

With both C<BEST_FIT_PROGRESSIVE> and C<SPOT_CAPACITY_OPTIMIZED>
allocation strategies, AWS Batch might need to exceed C<maxvCpus> to
meet your capacity requirements. In this event, AWS Batch never exceeds
C<maxvCpus> by more than a single instance. That is, no more than a
single instance from among those specified in your compute environment.


=head2 MinvCpus => Int

The minimum number of Amazon EC2 vCPUs that an environment should
maintain.

This parameter isn't applicable to jobs running on Fargate resources,
and shouldn't be specified.


=head2 SecurityGroupIds => ArrayRef[Str|Undef]

The Amazon EC2 security groups associated with instances launched in
the compute environment. This parameter is required for Fargate compute
resources, where it can contain up to 5 security groups. This can't be
specified for EC2 compute resources. Providing an empty list is handled
as if this parameter wasn't specified and no change is made.


=head2 Subnets => ArrayRef[Str|Undef]

The VPC subnets that the compute resources are launched into. Fargate
compute resources can contain up to 16 subnets. Providing an empty list
will be handled as if this parameter wasn't specified and no change is
made. This can't be specified for EC2 compute resources. For more
information, see VPCs and Subnets
(https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) in
the I<Amazon VPC User Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Batch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

