/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1994  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.7 of 15-Sep-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * file.c ---		The Optional File-Access Word Set and
 *			File-Access Extension Words.
 * (duz 12Jul93)
 */

#include <stdio.h>
#include <errno.h>

#include "config.h"
#include "forth.h"
#include "support.h"


Code (bin)
{
  *sp += FMODE_BIN;
}

Code (close_file)
{
  File *fid = (File *)sp [0];
  sp [0] = close_file (fid) ? errno : 0;
}

Code (create_file)
{
  char *fn = (char *)sp [2];	/* c-addr, name */
  uCell u = sp [1];		/* length of name */
  Cell fam = sp [0];		/* file access mode */
  File *fid = create_file (fn, u, fam);

  sp += 1;
  sp [1] = (Cell)fid;
  sp [0] = fid ? 0 : errno;
}

Code (delete_file)
{
  char *fn = (char *)sp [1];	/* c-addr, name */
  uCell u = sp [0];		/* length of name */
  char fnz [PATH_LENGTH];	/* to store name in ascii-z format */

  sp += 1;
  store_filename (fn, u, fnz, sizeof fnz);
  sp [0] = remove (fnz) ? errno : 0;
}

Code (file_position)
{
  File *fid = (File *)sp [0];	/* file-id */
  fpos_t pos = ftell (fid->f);
  udCell ud;

  sp -= 2;
  if (pos != -1)
    {
      UL2UDC (pos, ud);
      sp [0] = 0;		/* ior */
    }
  else
    {
      ud.lo = ud.hi = -1;
      sp [0] = errno;		/* ior */
    }
  *(udCell *)&sp [1] = ud;	/* ud */
}

Code (file_size)
{
  File *fid = (File *)sp [0];	/* fileid */
  fpos_t size = fsize (fid->f);
  udCell ud;

  sp -= 2;
  if (size != -1)
    {
      UL2UDC (size, ud);
      sp [0] = 0;		/* ior */
    }
  else
    {
      ud.lo = ud.hi = -1;
      sp [0] = errno;		/* ior */
    }
  *(udCell *)&sp [1] = ud;	/* ud */
}

Code (include_file)
{
  include_file ((File *)*sp++);
}

Code (included)
{
  char *fn = (char *)sp [1];	/* c-addr, name */
  uCell u = sp [0];		/* length of name */
  sp += 2;
  included (fn, u);
}

Code (open_file)
{
  char *fn = (char *)sp [2];	/* c-addr, name */
  uCell u = sp [1];		/* length of name */
  Cell fam = sp [0];		/* file access mode */
  File *fid = open_file (fn, u, fam);

  sp += 1;
  sp [1] = (Cell)fid;
  sp [0] = fid ? 0 : errno;
}

Code (read_file)
{
  char *c_addr = (char *)sp [2];
  uCell u = sp [1];
  File *fid = (File *)sp [0];
  Cell r = read_file (c_addr, &u, fid);

  sp += 1;
  sp [1] = u;
  sp [0] = r;
}

Code (read_line)
{
  char *c_addr = (char *)sp [2];
  uCell u = sp [1];
  File *fid = (File *)sp [0];
  Cell ior;
  int r = read_line (c_addr, &u, fid, &ior);

  sp [2] = u;
  sp [1] = r;
  sp [0] = ior;
}

Code (reposition_file)
{
  File *fid = (File *)sp [0];
  fpos_t pos = UDC2UL (sp [1], sp [2]);

  sp += 2;
  sp [0] = reposition_file (fid, pos);
}

Code (resize_file)
{
  File *fid = (File *)sp [0];
  fpos_t size = UDC2UL (sp [1], sp [2]);

  sp += 2;
  if (resize_file (fid, size))
    fid->size = size / BPBUF, *sp = 0;
  else
    *sp = errno;
}

Code (write_file)
{
  char *c_addr = (char *)sp [2];
  uCell u = sp [1];
  File *fid = (File *)sp [0];

  sp += 2;
  sp [0] = write_file (c_addr, u, fid);
}

Code (write_line)
{
  char *c_addr = (char *)sp [2];
  uCell u = sp [1];
  File *fid = (File *)sp [0];

  sp += 2;
  if ((sp [0] = write_file (c_addr, u, fid)) == 0)
    putc ('\n', fid->f);
}

Code (file_status)
{
  char fn [PATH_LENGTH];
  int mode;

  store_filename ((char *)sp [1], sp [0], fn, sizeof fn);
  mode = file_access (fn);
  if (mode == -1)
    {
      sp [1] = 0;
      sp [0] = errno;
    }
  else
    {
      sp [1] = mode;
      sp [0] = 0;
    }
}

Code (flush_file)
{
  File *fid = (File *)sp [0];

  if (BLOCK_FILE == fid)
    {
      save_buffers_();
      sp [0] = 0;
    }
  else
    {
      if (fflush (fid->f))
	sp [0] = errno;
      else
	sp [0] = 0;
    }
}

Code (rename_file)
{
  char oldnm [80], newnm [80];

  store_filename ((char *)sp [3], sp [2], oldnm, sizeof oldnm);
  store_filename ((char *)sp [1], sp [0], newnm, sizeof newnm);
  sp += 3;
  *sp = rename (oldnm, newnm) ? errno : 0;
}


LISTWORDS (file) =
{
  CO ("BIN",		bin),
  CO ("CLOSE-FILE",	close_file),
  CO ("CREATE-FILE",	create_file),
  CO ("DELETE-FILE",	delete_file),
  CO ("FILE-POSITION",	file_position),
  CO ("FILE-SIZE",	file_size),
  CO ("INCLUDE-FILE",	include_file),
  CO ("INCLUDED",	included),
  CO ("OPEN-FILE",	open_file),
  OC ("R/O",		FMODE_RO),
  OC ("R/W",		FMODE_RW),
  CO ("READ-FILE",	read_file),
  CO ("READ-LINE",	read_line),
  CO ("REPOSITION-FILE",reposition_file),
  CO ("RESIZE-FILE",	resize_file),
  OC ("W/O",		FMODE_WO),
  CO ("WRITE-FILE",	write_file),
  CO ("WRITE-LINE",	write_line),
  CO ("FILE-STATUS",	file_status),
  CO ("FLUSH-FILE",	flush_file),
  CO ("RENAME-FILE",	rename_file)
};
COUNTWORDS (file, "File-access + extensions");
