#include <math.h>
#include <stdio.h>
#include <vogle.h>
#include "art.h"
#include "macro.h"
#include "gram.h"
#include "poly.h"

extern attr	*astackp;
extern mats	*mstackp;
extern hlist	*fhlist;
extern float	tolerance;
extern int	lookatdone;

extern double	modrf();

/*
 * torusinit
 *
 *	Draw a torus. The equation used is:
 *
 *	 	(x^2 + y^2 + z^2 + 1.0 - r^2)^2 - 4(x^2 + y^2) = 0.0.
 *
 * where r is between 0.0 and 1.0.
 *
 */
void
torusinit(o, d)
	object	*o;
	details *d;
{
	float	torad, ringrad, radius;
	vector	cent;
	details	*ld;
	int	first;
	float	delta, ang, dx, dy;

	if (!lookatdone)
		deflookat();

	cent.x = cent.y = cent.z = 0.0;

	first = 1;

	while (d != (details *)NULL) {
		switch (d->type) {
		case CENTER:
			cent = d->u.v;
			break;
		case RADII:
			torad = d->u.v.x;
			ringrad = d->u.v.y;
			break;
		case RADIUS:
			if (first) {
				ringrad = d->u.f;
				first = 0;
			} else
				torad = d->u.f;
			break;
		default:
			warning("art: illegal field in torus ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	pushmatrix();

		calctransforms(mstackp);
		multmatrix(mstackp->obj2ray);

		translate(cent.x, cent.y, cent.z);

		/* 
		 * draw the latitudinal rings.
		 */
		circle(0.0, 0.0, torad + ringrad);

		circle(0.0, 0.0, torad - ringrad);

		pushmatrix();
			translate(0.0, 0.0, ringrad);

			circle(0.0, 0.0, torad);

			translate(0.0, 0.0, -2 * ringrad);

			circle(0.0, 0.0, torad);
		popmatrix();

		/*
		 * draw the longitudinal rings
		 */

		delta = 180.0 / 10;

		for (ang = 0.0; ang < 360.0; ang += delta) {
			pushmatrix();
				dx = torad * cos((double)ang * M_PI / 180.0);
				dy = torad * sin((double)ang * M_PI / 180.0);
				translate(dx, dy, 0.0);
				rotate(90.0, 'x');
				rotate(ang, 'y');
				circle(0.0, 0.0, ringrad);
			popmatrix();

		}

	popmatrix();
}
