#include <math.h>
#include <stdio.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern mats	*mstackp;
extern hlist	*fhlist;
extern float	tolerance;
extern int	lookatdone, longlines, latlines;

/*
 * sphereinit
 *
 *	initialise the function pointers and fields for a sphere object,
 * returning its pointer.
 */
void
sphereinit(o, d)
	object	*o;
	details *d;
{
	details	*ld;
	vector	cent, radii;
	float	i, delta;
	float	a, r, z;

	cent.x = cent.y = cent.z = 0.0;		/* default sphere */
	radii.x = radii.y = radii.z = 1.0;

	if (!lookatdone)
		deflookat();

	while (d != (details *)NULL) {
		switch (d->type) {
		case CENTER:
			cent = d->u.v;
			break;
		case RADII:
			radii = d->u.v;
			break;
		case RADIUS:
			radii.x = radii.y = radii.z = d->u.f;
			break;
		default:
			warning("art: illegal field in sphere ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}

	pushmatrix();

		calctransforms(mstackp);
		multmatrix(mstackp->obj2ray);

		translate(cent.x, cent.y, cent.z);

		scale(radii.x, radii.y, radii.z);

		/*
		 * create the longitudinal rings
		 */
						     
		delta = 180.0 / longlines;
		for (i = 0; i < 170; i += delta) {
			pushmatrix();
				rotate(i, 'y');
				circle(0.0, 0.0, 1.0);
			popmatrix();
		}

		/*
		 * create the latitudinal rings
		 */
						     
		pushmatrix();
			rotate(90.0, 'x');
			delta = 180.0 / latlines;
			for (a = -90.0; a < 80.0; a += delta) {
				r = cos((double)a * M_PI / 180.0);
				z = sin((double)a * M_PI / 180.0);
				pushmatrix();
					translate(0.0, 0.0, -z);
					circle(0.0, 0.0, r);
				popmatrix();
			}
		popmatrix();

	popmatrix();
}
