# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
#include <math.h>
#include "art.h"
#include "objs.h"
#include "gram.h"

extern int	linecount;

extern char	currentfile[];

extern symbol	*lookup();

extern double	atof();

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
return(PERSPECTIVE);
break;
case 2:
return(ORTHOGRAPHIC);
break;
case 3:
return(PROJECTION);
break;
case 4:
return(MAXTREEDEPTH);
break;
case 5:
return(SCREENSIZE);
break;
case 6:
	return(SOURCE);
break;
case 7:
return(AMPLITUDE);
break;
case 8:
return(WAVELENGTH);
break;
case 9:
	return(DAMPING);
break;
case 10:
	return(PHASE);
break;
case 11:
return(SCALEFACTOR);
break;
case 12:
return(SOURCERADIUS);
break;
case 13:
return(TURBULENCE);
break;
case 14:
	return(SQUEEZE);
break;
case 15:
	return(OFFFILE);
break;
case 16:
	return(OFFFILE);
break;
case 17:
return(COLOURFILE);
break;
case 18:
return(NORMALFILE);
break;
case 19:
return(VNORMALFILE);
break;
case 20:
return(VORTFILE);
break;
case 21:
	return(TOP);
break;
case 22:
	return(BASE);
break;
case 23:
return(CONST);
break;
case 24:
return(COEFFS);
break;
case 25:
	return(ORDER);
break;
case 26:
	return(CSG);
break;
case 27:
return(COMPOSITE);
break;
case 28:
{
			yylval.y_int = PHONGSHADING;
			return(OPTION);
		}
break;
case 29:
{
			yylval.y_int = ART_BACKFACING;
			return(OPTION);
		}
break;
case 30:
	return(ON);
break;
case 31:
	return(OFF);
break;
case 32:
return(MATERIAL);
break;
case 33:
	return(CENTER);
break;
case 34:
	return(COLOUR);
break;
case 35:
	return(AMBIENT);
break;
case 36:
return(REFLECTANCE);
break;
case 37:
return(ABSORPTION);
break;
case 38:
return(TRANSPARENCY);
break;
case 39:
return(HAZECOLOUR);
break;
case 40:
return(FOGFACTOR);
break;
case 41:
	return(RFACTOR);
break;
case 42:
	return(FALLOFF);
break;
case 43:
	return(RI);
break;
case 44:
	return(REPEAT);
break;
case 45:
	return(RADIUS);
break;
case 46:
	return(RADII);
break;
case 47:
	return(LIGHT);
break;
case 48:
return(DIRECTION);
break;
case 49:
	return(ANGLE);
break;
case 50:
return(INSIDEANGLE);
break;
case 51:
return(BEAMDISTRIBUTION);
break;
case 52:
	return(NUMRAYS);
break;
case 53:
	return(VERTEX);
break;
case 54:
return(LOCATION);
break;
case 55:
	return(TILE);
break;
case 56:
	return(TEXTURE);
break;
case 57:
	return(MAP);
break;
case 58:
return(COLOURMAP);
break;
case 59:
	return(RANGE);
break;
case 60:
	return(BLEND);
break;
case 61:
return(BLENDCOLOR);
break;
case 62:
return(SCALEFACTORS);
break;
case 63:
	return(SIZE);
break;
case 64:
return(EQUATION);
break;
case 65:
return(ART_TRANSLATE);
break;
case 66:
	return(ART_ROTATE);
break;
case 67:
	return(ART_SCALE);
break;
case 68:
	return(LOOKAT);
break;
case 69:
	return(UP);
break;
case 70:
return(FIELDOFVIEW);
break;
case 71:
return(RAYSPERPIXEL);
break;
case 72:
return(PIXELGRID);
break;
case 73:
	return(SHADOWS);
break;
case 74:
	return(TITLE);
break;
case 75:
return(BACKGROUND);
break;
case 76:
return(MAXHITLEVEL);
break;
case 77:
	return(OUTPUT);
break;
case 78:
return(TWENTYFIVEBIT);
break;
case 79:
	{
			yylval.y_int = PIX_RGB;
			return(FILETYPE);
		}
break;
case 80:
	{
			yylval.y_int = PIX_RLE;
			return(FILETYPE);
		}
break;
case 81:
	{
			yylval.y_int = PIX_RGBA;
			return(FILETYPE);
		}
break;
case 82:
	{
			yylval.y_int = PIX_RLEA;
			return(FILETYPE);
		}
break;
case 83:
{
			if ((yylval.y_sym = lookup(yytext)) != (symbol *)NULL)
				return(OBJECT_TYPE);
			else {
				yylval.y_str = (char *)smalloc(strlen(yytext) + 1);
				strcpy(yylval.y_str, yytext);

				return(NAME);
			}
		}
break;
case 84:
{
			yylval.y_int = atoi(yytext);
			return(INTEGER);
		}
break;
case 85:
{
			yylval.y_flt = atof(yytext);
			return(FLOAT);
		}
break;
case 86:
	return(PLUS);
break;
case 87:
	return(MINUS);
break;
case 88:
	return(DIV);
break;
case 89:
	return(MULT);
break;
case 90:
	return(PCENT);
break;
case 91:
	return(POWER);
break;
case 92:
	return(COMMA);
break;
case 93:
	return(LP);
break;
case 94:
	return(RP);
break;
case 95:
	return(EQUALS);
break;
case 96:
	return(DOLS);
break;
case 97:
	{
			char	buf[BUFSIZ], *p;
			
			for (p = buf; (*p = getchar()) != '"'; p++)
				if (*p == '\n' || *p == EOF)
					yyerror("syntax error");

			*p = 0;

			yylval.y_str = (char *)smalloc(strlen(buf) + 1);
			strcpy(yylval.y_str, buf);

			return(NAME);
		}
break;
case 98:
	{
			return(LBRACE);
		}
break;
case 99:
	{
			return(RBRACE);
		}
break;
case 100:
	return(QUOTE);
break;
case 101:
	{
			linecount++;
		}
break;
case 102:
	{
			;
		}
break;
case 103:
	{
			int	c, i, j;
			char	buf[BUFSIZ], *p;

			i = 0;
			while ((buf[i] = getchar()) != '\n' && !feof(stdin))
				i++;

			if (sscanf(buf, "%d", &linecount) != 1)
				linecount++;
			else {
				for (p = buf; p != &buf[i]; p++)
					if (*p == '"')
						break;

				if (p == &buf[i])
					linecount++;
				else {
					j = 0;
					p++;
					while (*p != '"' && p != &buf[i])
						currentfile[j++] = *p++;
					currentfile[j] = 0;
				}
			}
		}
break;
case 104:
	{
			int	c1, c2;
			int	comline, incomment = 1;
			char	buf[BUFSIZ];

			comline = linecount;

			do {
				while ((c1 = getchar()) != '*' && c1 != '/' && c1 != EOF)
					if (c1 == '\n')
						linecount++;

				c2 = getchar();
				if (c2 == '\n')
					linecount++;

				if (c1 == '*' && c2 == '/')
					incomment--;

				if (c1 == '/' && c2 == '*') {
					incomment++;
					comline = linecount;
				}

			} while (incomment && c2 != EOF);

			if (c1 == EOF || c2 == EOF) {
				sprintf(buf, "art: unterminated comment - started line %d.\n", comline);
				fatal(buf);
			}
		}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
int yyvstop[] = {
0,

84,
0,

84,
0,

102,
0,

101,
0,

97,
0,

103,
0,

90,
0,

100,
0,

93,
0,

94,
0,

89,
0,

86,
0,

92,
0,

87,
0,

85,
0,

88,
0,

84,
0,

95,
0,

83,
0,

91,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

98,
0,

99,
0,

96,
0,

104,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

30,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

43,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

69,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

26,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

57,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

31,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

79,
83,
0,

80,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

21,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

22,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

81,
83,
0,

82,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

63,
83,
0,

83,
0,

83,
0,

83,
0,

55,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

49,
83,
0,

83,
0,

83,
0,

83,
0,

60,
83,
0,

83,
0,

83,
0,

34,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

47,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

25,
83,
0,

83,
0,

83,
0,

83,
0,

10,
83,
0,

83,
0,

83,
0,

83,
0,

46,
83,
0,

83,
0,

59,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

67,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

74,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

33,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

68,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

77,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

45,
83,
0,

83,
0,

83,
0,

44,
83,
0,

83,
0,

66,
83,
0,

83,
0,

83,
0,

83,
0,

6,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

53,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

35,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

9,
83,
0,

83,
0,

83,
0,

42,
83,
0,

83,
0,

83,
0,

15,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

52,
83,
0,

16,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

41,
83,
0,

83,
0,

83,
0,

73,
83,
0,

83,
0,

14,
83,
0,

56,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

58,
83,
0,

83,
0,

23,
83,
0,

83,
0,

64,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

54,
83,
0,

32,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

20,
83,
0,

83,
0,

83,
0,

7,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

17,
83,
0,

27,
83,
0,

48,
83,
0,

83,
0,

40,
83,
0,

39,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

72,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

65,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

37,
83,
0,

29,
83,
0,

75,
83,
0,

83,
0,

61,
83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

83,
0,

18,
83,
0,

83,
0,

83,
0,

83,
0,

3,
83,
0,

83,
0,

83,
0,

83,
0,

5,
83,
0,

83,
0,

83,
0,

13,
83,
0,

83,
0,

83,
0,

8,
83,
0,

83,
0,

83,
0,

70,
83,
0,

50,
83,
0,

76,
83,
0,

83,
0,

83,
0,

1,
83,
0,

83,
0,

83,
0,

36,
83,
0,

11,
83,
0,

83,
0,

83,
0,

83,
0,

19,
83,
0,

83,
0,

24,
83,
0,

4,
83,
0,

2,
83,
0,

28,
83,
0,

71,
83,
0,

62,
83,
0,

12,
83,
0,

38,
83,
0,

83,
0,

83,
0,

78,
83,
0,

83,
0,

83,
0,

51,
83,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,3,	1,4,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,3,	0,0,	1,5,	
1,6,	1,7,	1,8,	7,44,	
1,9,	1,10,	1,11,	1,12,	
1,13,	1,14,	1,15,	1,16,	
1,17,	1,18,	1,18,	1,18,	
1,18,	1,18,	1,18,	1,18,	
1,18,	1,18,	1,18,	17,45,	
0,0,	0,0,	1,19,	0,0,	
0,0,	0,0,	1,20,	1,20,	
1,20,	1,20,	1,20,	1,20,	
1,20,	1,20,	1,20,	1,20,	
1,20,	1,20,	1,20,	1,20,	
1,20,	1,20,	1,20,	1,20,	
1,20,	1,20,	1,20,	1,20,	
1,20,	1,20,	1,20,	1,20,	
0,0,	0,0,	0,0,	1,21,	
1,20,	0,0,	1,22,	1,23,	
1,24,	1,25,	1,26,	1,27,	
1,28,	1,29,	1,30,	1,20,	
1,20,	1,31,	1,32,	1,33,	
1,34,	1,35,	1,20,	1,36,	
1,37,	1,38,	1,39,	1,40,	
1,41,	1,20,	1,20,	1,20,	
1,42,	26,57,	1,43,	16,16,	
16,16,	16,16,	16,16,	16,16,	
16,16,	16,16,	16,16,	16,16,	
16,16,	18,16,	28,61,	18,18,	
18,18,	18,18,	18,18,	18,18,	
18,18,	18,18,	18,18,	18,18,	
18,18,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	29,62,	30,63,	32,66,	
39,95,	41,99,	46,100,	48,103,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	50,106,	51,107,	
52,108,	54,113,	20,20,	55,114,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	20,20,	20,20,	
20,20,	20,20,	22,46,	25,55,	
23,49,	56,115,	24,52,	57,116,	
23,50,	27,58,	49,104,	25,56,	
31,64,	22,47,	22,48,	23,51,	
24,53,	27,59,	31,65,	33,67,	
24,54,	34,69,	40,96,	27,60,	
35,73,	33,68,	49,105,	35,74,	
35,75,	34,70,	47,101,	40,97,	
40,98,	34,71,	36,77,	58,117,	
34,72,	35,76,	36,78,	36,79,	
36,80,	37,84,	36,81,	59,118,	
47,102,	36,82,	37,85,	37,86,	
36,83,	53,109,	38,89,	60,119,	
61,120,	37,87,	38,90,	37,88,	
53,110,	53,111,	53,112,	62,121,	
38,91,	63,122,	64,123,	38,92,	
65,124,	66,126,	38,93,	67,129,	
38,94,	66,127,	68,130,	69,131,	
71,132,	66,128,	72,134,	73,135,	
65,125,	74,136,	75,138,	76,139,	
77,140,	79,145,	78,143,	80,146,	
82,147,	83,148,	84,149,	85,151,	
71,133,	86,152,	77,141,	74,137,	
78,144,	87,153,	88,154,	89,155,	
90,156,	91,158,	92,159,	93,160,	
94,161,	77,142,	96,162,	84,150,	
90,157,	97,163,	98,164,	99,165,	
100,166,	101,167,	102,168,	103,169,	
104,170,	105,171,	106,172,	107,173,	
108,174,	109,175,	110,176,	111,177,	
112,178,	114,179,	115,180,	116,181,	
117,182,	118,183,	119,184,	120,185,	
121,186,	122,187,	123,188,	124,189,	
125,190,	127,191,	128,192,	129,194,	
130,195,	131,196,	132,197,	133,198,	
134,199,	135,200,	136,201,	137,202,	
138,203,	139,204,	128,193,	140,205,	
141,206,	142,207,	143,208,	144,209,	
145,210,	146,211,	147,212,	148,213,	
149,214,	150,215,	151,216,	152,217,	
153,218,	154,219,	155,220,	156,221,	
157,222,	159,223,	160,224,	161,225,	
162,226,	163,227,	164,228,	165,229,	
166,230,	167,231,	168,232,	169,233,	
170,234,	170,235,	172,236,	173,237,	
174,238,	175,239,	176,240,	177,242,	
178,243,	176,241,	179,244,	180,245,	
181,246,	182,247,	183,248,	184,249,	
185,250,	186,251,	187,252,	188,253,	
189,254,	190,255,	191,256,	192,257,	
193,258,	194,259,	195,260,	196,261,	
197,262,	198,263,	199,264,	200,265,	
201,266,	202,267,	203,268,	204,269,	
205,270,	206,272,	207,273,	208,274,	
209,275,	210,276,	213,277,	214,278,	
215,279,	216,280,	218,281,	219,282,	
205,271,	220,283,	222,284,	223,285,	
224,286,	225,287,	226,288,	227,289,	
228,290,	229,291,	230,292,	231,293,	
232,294,	234,295,	235,296,	236,297,	
237,298,	238,299,	239,300,	240,301,	
241,240,	242,303,	243,304,	244,305,	
245,306,	246,307,	240,302,	247,308,	
248,309,	249,310,	250,311,	251,312,	
252,313,	254,314,	255,315,	256,316,	
257,317,	258,318,	259,319,	260,320,	
261,321,	263,322,	264,323,	265,324,	
267,325,	268,326,	269,327,	271,328,	
273,329,	274,330,	275,331,	276,332,	
277,333,	278,334,	279,335,	280,336,	
281,337,	282,338,	283,339,	285,340,	
286,342,	287,343,	288,344,	285,341,	
289,345,	290,346,	291,347,	292,348,	
293,349,	294,350,	295,351,	296,352,	
297,353,	298,354,	300,355,	301,356,	
302,357,	303,358,	304,359,	305,360,	
306,361,	307,362,	308,363,	309,364,	
310,365,	311,366,	312,367,	313,368,	
314,369,	316,370,	317,371,	318,372,	
319,373,	320,374,	321,375,	322,376,	
324,377,	325,378,	326,379,	327,380,	
329,381,	330,382,	332,383,	334,384,	
335,385,	336,386,	337,387,	338,388,	
339,389,	340,390,	341,391,	342,392,	
343,393,	345,394,	346,395,	347,396,	
348,397,	350,398,	351,399,	352,400,	
353,401,	354,402,	355,403,	356,404,	
357,405,	358,406,	359,407,	361,408,	
362,409,	364,410,	365,411,	367,412,	
368,413,	369,414,	370,415,	371,416,	
372,417,	373,418,	376,419,	377,420,	
378,421,	379,422,	380,423,	381,424,	
382,425,	384,426,	385,427,	387,428,	
390,429,	391,430,	392,431,	393,432,	
394,433,	395,434,	396,435,	397,436,	
398,437,	399,438,	400,439,	401,440,	
402,441,	403,442,	404,443,	406,444,	
408,445,	410,446,	411,447,	412,448,	
413,450,	416,451,	412,449,	417,452,	
418,453,	419,454,	420,455,	421,456,	
422,457,	423,458,	424,459,	425,460,	
426,461,	427,462,	428,463,	429,464,	
430,465,	431,466,	432,467,	433,468,	
435,469,	436,470,	438,471,	439,472,	
440,473,	441,474,	442,476,	446,477,	
441,475,	449,448,	450,478,	451,479,	
452,480,	453,481,	454,482,	455,483,	
456,484,	458,485,	459,486,	460,487,	
461,488,	462,489,	463,490,	465,491,	
466,492,	467,493,	468,494,	469,495,	
473,496,	475,474,	476,497,	477,498,	
478,499,	479,500,	480,501,	482,502,	
483,503,	484,504,	486,505,	487,506,	
488,507,	490,508,	491,509,	493,510,	
494,511,	496,512,	497,513,	501,514,	
502,515,	504,516,	505,517,	507,518,	
508,519,	509,520,	510,521,	512,522,	
521,523,	522,524,	524,525,	525,526,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+1,	0,		yyvstop+1,
yycrank+0,	yysvec+1,	yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+0,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+9,
yycrank+0,	0,		yyvstop+11,
yycrank+3,	0,		0,	
yycrank+0,	0,		yyvstop+13,
yycrank+0,	0,		yyvstop+15,
yycrank+0,	0,		yyvstop+17,
yycrank+0,	0,		yyvstop+19,
yycrank+0,	0,		yyvstop+21,
yycrank+0,	0,		yyvstop+23,
yycrank+0,	0,		yyvstop+25,
yycrank+0,	0,		yyvstop+27,
yycrank+79,	0,		yyvstop+29,
yycrank+17,	0,		yyvstop+31,
yycrank+91,	0,		yyvstop+33,
yycrank+0,	0,		yyvstop+35,
yycrank+103,	0,		yyvstop+37,
yycrank+0,	0,		yyvstop+39,
yycrank+128,	yysvec+20,	yyvstop+41,
yycrank+131,	yysvec+20,	yyvstop+43,
yycrank+129,	yysvec+20,	yyvstop+45,
yycrank+130,	yysvec+20,	yyvstop+47,
yycrank+12,	yysvec+20,	yyvstop+49,
yycrank+136,	yysvec+20,	yyvstop+51,
yycrank+37,	yysvec+20,	yyvstop+53,
yycrank+64,	yysvec+20,	yyvstop+55,
yycrank+52,	yysvec+20,	yyvstop+57,
yycrank+131,	yysvec+20,	yyvstop+59,
yycrank+66,	yysvec+20,	yyvstop+61,
yycrank+132,	yysvec+20,	yyvstop+63,
yycrank+143,	yysvec+20,	yyvstop+65,
yycrank+147,	yysvec+20,	yyvstop+67,
yycrank+161,	yysvec+20,	yyvstop+69,
yycrank+166,	yysvec+20,	yyvstop+71,
yycrank+173,	yysvec+20,	yyvstop+73,
yycrank+52,	yysvec+20,	yyvstop+75,
yycrank+145,	yysvec+20,	yyvstop+77,
yycrank+68,	yysvec+20,	yyvstop+79,
yycrank+0,	0,		yyvstop+81,
yycrank+0,	0,		yyvstop+83,
yycrank+0,	0,		yyvstop+85,
yycrank+0,	0,		yyvstop+87,
yycrank+51,	yysvec+20,	yyvstop+89,
yycrank+156,	yysvec+20,	yyvstop+91,
yycrank+64,	yysvec+20,	yyvstop+93,
yycrank+135,	yysvec+20,	yyvstop+95,
yycrank+97,	yysvec+20,	yyvstop+97,
yycrank+94,	yysvec+20,	yyvstop+99,
yycrank+86,	yysvec+20,	yyvstop+101,
yycrank+172,	yysvec+20,	yyvstop+103,
yycrank+94,	yysvec+20,	yyvstop+105,
yycrank+90,	yysvec+20,	yyvstop+107,
yycrank+115,	yysvec+20,	yyvstop+109,
yycrank+114,	yysvec+20,	yyvstop+111,
yycrank+151,	yysvec+20,	yyvstop+113,
yycrank+166,	yysvec+20,	yyvstop+115,
yycrank+172,	yysvec+20,	yyvstop+117,
yycrank+165,	yysvec+20,	yyvstop+119,
yycrank+161,	yysvec+20,	yyvstop+121,
yycrank+170,	yysvec+20,	yyvstop+123,
yycrank+183,	yysvec+20,	yyvstop+125,
yycrank+189,	yysvec+20,	yyvstop+127,
yycrank+177,	yysvec+20,	yyvstop+129,
yycrank+177,	yysvec+20,	yyvstop+131,
yycrank+185,	yysvec+20,	yyvstop+133,
yycrank+193,	yysvec+20,	yyvstop+135,
yycrank+0,	yysvec+20,	yyvstop+137,
yycrank+196,	yysvec+20,	yyvstop+140,
yycrank+182,	yysvec+20,	yyvstop+142,
yycrank+185,	yysvec+20,	yyvstop+144,
yycrank+204,	yysvec+20,	yyvstop+146,
yycrank+182,	yysvec+20,	yyvstop+148,
yycrank+192,	yysvec+20,	yyvstop+150,
yycrank+204,	yysvec+20,	yyvstop+152,
yycrank+204,	yysvec+20,	yyvstop+154,
yycrank+208,	yysvec+20,	yyvstop+156,
yycrank+209,	yysvec+20,	yyvstop+158,
yycrank+0,	yysvec+20,	yyvstop+160,
yycrank+207,	yysvec+20,	yyvstop+163,
yycrank+193,	yysvec+20,	yyvstop+165,
yycrank+213,	yysvec+20,	yyvstop+167,
yycrank+214,	yysvec+20,	yyvstop+169,
yycrank+191,	yysvec+20,	yyvstop+171,
yycrank+200,	yysvec+20,	yyvstop+173,
yycrank+201,	yysvec+20,	yyvstop+175,
yycrank+199,	yysvec+20,	yyvstop+177,
yycrank+212,	yysvec+20,	yyvstop+179,
yycrank+209,	yysvec+20,	yyvstop+181,
yycrank+225,	yysvec+20,	yyvstop+183,
yycrank+209,	yysvec+20,	yyvstop+185,
yycrank+223,	yysvec+20,	yyvstop+187,
yycrank+0,	yysvec+20,	yyvstop+189,
yycrank+212,	yysvec+20,	yyvstop+192,
yycrank+218,	yysvec+20,	yyvstop+194,
yycrank+216,	yysvec+20,	yyvstop+196,
yycrank+213,	yysvec+20,	yyvstop+198,
yycrank+221,	yysvec+20,	yyvstop+200,
yycrank+228,	yysvec+20,	yyvstop+202,
yycrank+226,	yysvec+20,	yyvstop+204,
yycrank+227,	yysvec+20,	yyvstop+206,
yycrank+229,	yysvec+20,	yyvstop+208,
yycrank+236,	yysvec+20,	yyvstop+210,
yycrank+229,	yysvec+20,	yyvstop+212,
yycrank+229,	yysvec+20,	yyvstop+214,
yycrank+224,	yysvec+20,	yyvstop+216,
yycrank+239,	yysvec+20,	yyvstop+218,
yycrank+231,	yysvec+20,	yyvstop+220,
yycrank+231,	yysvec+20,	yyvstop+222,
yycrank+229,	yysvec+20,	yyvstop+224,
yycrank+0,	yysvec+20,	yyvstop+226,
yycrank+233,	yysvec+20,	yyvstop+229,
yycrank+245,	yysvec+20,	yyvstop+231,
yycrank+250,	yysvec+20,	yyvstop+233,
yycrank+240,	yysvec+20,	yyvstop+235,
yycrank+241,	yysvec+20,	yyvstop+237,
yycrank+248,	yysvec+20,	yyvstop+239,
yycrank+249,	yysvec+20,	yyvstop+241,
yycrank+251,	yysvec+20,	yyvstop+243,
yycrank+248,	yysvec+20,	yyvstop+245,
yycrank+250,	yysvec+20,	yyvstop+247,
yycrank+258,	yysvec+20,	yyvstop+249,
yycrank+249,	yysvec+20,	yyvstop+251,
yycrank+0,	yysvec+20,	yyvstop+253,
yycrank+256,	yysvec+20,	yyvstop+256,
yycrank+254,	yysvec+20,	yyvstop+258,
yycrank+250,	yysvec+20,	yyvstop+260,
yycrank+246,	yysvec+20,	yyvstop+262,
yycrank+259,	yysvec+20,	yyvstop+264,
yycrank+261,	yysvec+20,	yyvstop+267,
yycrank+259,	yysvec+20,	yyvstop+269,
yycrank+252,	yysvec+20,	yyvstop+271,
yycrank+250,	yysvec+20,	yyvstop+273,
yycrank+251,	yysvec+20,	yyvstop+275,
yycrank+257,	yysvec+20,	yyvstop+277,
yycrank+267,	yysvec+20,	yyvstop+279,
yycrank+263,	yysvec+20,	yyvstop+281,
yycrank+266,	yysvec+20,	yyvstop+283,
yycrank+269,	yysvec+20,	yyvstop+285,
yycrank+258,	yysvec+20,	yyvstop+287,
yycrank+266,	yysvec+20,	yyvstop+289,
yycrank+274,	yysvec+20,	yyvstop+291,
yycrank+277,	yysvec+20,	yyvstop+293,
yycrank+280,	yysvec+20,	yyvstop+295,
yycrank+281,	yysvec+20,	yyvstop+298,
yycrank+282,	yysvec+20,	yyvstop+301,
yycrank+272,	yysvec+20,	yyvstop+303,
yycrank+280,	yysvec+20,	yyvstop+305,
yycrank+282,	yysvec+20,	yyvstop+307,
yycrank+282,	yysvec+20,	yyvstop+309,
yycrank+270,	yysvec+20,	yyvstop+311,
yycrank+284,	yysvec+20,	yyvstop+313,
yycrank+270,	yysvec+20,	yyvstop+315,
yycrank+286,	yysvec+20,	yyvstop+317,
yycrank+280,	yysvec+20,	yyvstop+319,
yycrank+0,	yysvec+20,	yyvstop+321,
yycrank+279,	yysvec+20,	yyvstop+324,
yycrank+292,	yysvec+20,	yyvstop+326,
yycrank+281,	yysvec+20,	yyvstop+328,
yycrank+276,	yysvec+20,	yyvstop+330,
yycrank+279,	yysvec+20,	yyvstop+332,
yycrank+278,	yysvec+20,	yyvstop+334,
yycrank+294,	yysvec+20,	yyvstop+336,
yycrank+282,	yysvec+20,	yyvstop+338,
yycrank+296,	yysvec+20,	yyvstop+340,
yycrank+293,	yysvec+20,	yyvstop+342,
yycrank+298,	yysvec+20,	yyvstop+344,
yycrank+298,	yysvec+20,	yyvstop+346,
yycrank+0,	yysvec+20,	yyvstop+348,
yycrank+302,	yysvec+20,	yyvstop+351,
yycrank+303,	yysvec+20,	yyvstop+353,
yycrank+303,	yysvec+20,	yyvstop+355,
yycrank+303,	yysvec+20,	yyvstop+357,
yycrank+292,	yysvec+20,	yyvstop+359,
yycrank+296,	yysvec+20,	yyvstop+361,
yycrank+292,	yysvec+20,	yyvstop+363,
yycrank+305,	yysvec+20,	yyvstop+365,
yycrank+312,	yysvec+20,	yyvstop+367,
yycrank+296,	yysvec+20,	yyvstop+369,
yycrank+302,	yysvec+20,	yyvstop+371,
yycrank+314,	yysvec+20,	yyvstop+373,
yycrank+318,	yysvec+20,	yyvstop+375,
yycrank+311,	yysvec+20,	yyvstop+377,
yycrank+318,	yysvec+20,	yyvstop+379,
yycrank+318,	yysvec+20,	yyvstop+381,
yycrank+303,	yysvec+20,	yyvstop+383,
yycrank+304,	yysvec+20,	yyvstop+385,
yycrank+324,	yysvec+20,	yyvstop+387,
yycrank+308,	yysvec+20,	yyvstop+389,
yycrank+318,	yysvec+20,	yyvstop+391,
yycrank+310,	yysvec+20,	yyvstop+393,
yycrank+328,	yysvec+20,	yyvstop+395,
yycrank+329,	yysvec+20,	yyvstop+397,
yycrank+322,	yysvec+20,	yyvstop+399,
yycrank+314,	yysvec+20,	yyvstop+401,
yycrank+318,	yysvec+20,	yyvstop+403,
yycrank+313,	yysvec+20,	yyvstop+405,
yycrank+319,	yysvec+20,	yyvstop+407,
yycrank+331,	yysvec+20,	yyvstop+409,
yycrank+330,	yysvec+20,	yyvstop+411,
yycrank+326,	yysvec+20,	yyvstop+413,
yycrank+334,	yysvec+20,	yyvstop+415,
yycrank+331,	yysvec+20,	yyvstop+417,
yycrank+336,	yysvec+20,	yyvstop+419,
yycrank+326,	yysvec+20,	yyvstop+421,
yycrank+338,	yysvec+20,	yyvstop+423,
yycrank+343,	yysvec+20,	yyvstop+425,
yycrank+325,	yysvec+20,	yyvstop+427,
yycrank+0,	yysvec+20,	yyvstop+429,
yycrank+0,	yysvec+20,	yyvstop+432,
yycrank+326,	yysvec+20,	yyvstop+435,
yycrank+342,	yysvec+20,	yyvstop+437,
yycrank+343,	yysvec+20,	yyvstop+439,
yycrank+334,	yysvec+20,	yyvstop+441,
yycrank+0,	yysvec+20,	yyvstop+443,
yycrank+347,	yysvec+20,	yyvstop+446,
yycrank+346,	yysvec+20,	yyvstop+448,
yycrank+332,	yysvec+20,	yyvstop+450,
yycrank+0,	yysvec+20,	yyvstop+452,
yycrank+349,	yysvec+20,	yyvstop+455,
yycrank+336,	yysvec+20,	yyvstop+457,
yycrank+335,	yysvec+20,	yyvstop+459,
yycrank+337,	yysvec+20,	yyvstop+461,
yycrank+353,	yysvec+20,	yyvstop+463,
yycrank+346,	yysvec+20,	yyvstop+465,
yycrank+354,	yysvec+20,	yyvstop+467,
yycrank+349,	yysvec+20,	yyvstop+469,
yycrank+346,	yysvec+20,	yyvstop+471,
yycrank+349,	yysvec+20,	yyvstop+473,
yycrank+344,	yysvec+20,	yyvstop+475,
yycrank+0,	yysvec+20,	yyvstop+477,
yycrank+364,	yysvec+20,	yyvstop+480,
yycrank+348,	yysvec+20,	yyvstop+482,
yycrank+358,	yysvec+20,	yyvstop+484,
yycrank+365,	yysvec+20,	yyvstop+486,
yycrank+351,	yysvec+20,	yyvstop+489,
yycrank+361,	yysvec+20,	yyvstop+491,
yycrank+365,	yysvec+20,	yyvstop+493,
yycrank+354,	yysvec+20,	yyvstop+496,
yycrank+354,	yysvec+20,	yyvstop+498,
yycrank+373,	yysvec+20,	yyvstop+500,
yycrank+361,	yysvec+20,	yyvstop+502,
yycrank+356,	yysvec+20,	yyvstop+504,
yycrank+368,	yysvec+20,	yyvstop+506,
yycrank+373,	yysvec+20,	yyvstop+508,
yycrank+365,	yysvec+20,	yyvstop+510,
yycrank+378,	yysvec+20,	yyvstop+512,
yycrank+370,	yysvec+20,	yyvstop+514,
yycrank+368,	yysvec+20,	yyvstop+516,
yycrank+379,	yysvec+20,	yyvstop+518,
yycrank+0,	yysvec+20,	yyvstop+520,
yycrank+376,	yysvec+20,	yyvstop+523,
yycrank+366,	yysvec+20,	yyvstop+525,
yycrank+378,	yysvec+20,	yyvstop+527,
yycrank+368,	yysvec+20,	yyvstop+529,
yycrank+384,	yysvec+20,	yyvstop+531,
yycrank+378,	yysvec+20,	yyvstop+533,
yycrank+366,	yysvec+20,	yyvstop+535,
yycrank+380,	yysvec+20,	yyvstop+537,
yycrank+0,	yysvec+20,	yyvstop+539,
yycrank+386,	yysvec+20,	yyvstop+542,
yycrank+374,	yysvec+20,	yyvstop+544,
yycrank+390,	yysvec+20,	yyvstop+546,
yycrank+0,	yysvec+20,	yyvstop+548,
yycrank+377,	yysvec+20,	yyvstop+551,
yycrank+390,	yysvec+20,	yyvstop+553,
yycrank+395,	yysvec+20,	yyvstop+555,
yycrank+0,	yysvec+20,	yyvstop+557,
yycrank+380,	yysvec+20,	yyvstop+560,
yycrank+0,	yysvec+20,	yyvstop+562,
yycrank+395,	yysvec+20,	yyvstop+565,
yycrank+398,	yysvec+20,	yyvstop+567,
yycrank+382,	yysvec+20,	yyvstop+569,
yycrank+388,	yysvec+20,	yyvstop+571,
yycrank+399,	yysvec+20,	yyvstop+573,
yycrank+399,	yysvec+20,	yyvstop+575,
yycrank+392,	yysvec+20,	yyvstop+578,
yycrank+384,	yysvec+20,	yyvstop+580,
yycrank+403,	yysvec+20,	yyvstop+582,
yycrank+383,	yysvec+20,	yyvstop+584,
yycrank+392,	yysvec+20,	yyvstop+586,
yycrank+0,	yysvec+20,	yyvstop+588,
yycrank+399,	yysvec+20,	yyvstop+591,
yycrank+400,	yysvec+20,	yyvstop+593,
yycrank+388,	yysvec+20,	yyvstop+595,
yycrank+390,	yysvec+20,	yyvstop+597,
yycrank+415,	yysvec+20,	yyvstop+599,
yycrank+408,	yysvec+20,	yyvstop+601,
yycrank+413,	yysvec+20,	yyvstop+603,
yycrank+399,	yysvec+20,	yyvstop+605,
yycrank+400,	yysvec+20,	yyvstop+607,
yycrank+400,	yysvec+20,	yyvstop+609,
yycrank+419,	yysvec+20,	yyvstop+611,
yycrank+408,	yysvec+20,	yyvstop+613,
yycrank+405,	yysvec+20,	yyvstop+615,
yycrank+410,	yysvec+20,	yyvstop+617,
yycrank+0,	yysvec+20,	yyvstop+619,
yycrank+423,	yysvec+20,	yyvstop+622,
yycrank+418,	yysvec+20,	yyvstop+624,
yycrank+427,	yysvec+20,	yyvstop+626,
yycrank+420,	yysvec+20,	yyvstop+628,
yycrank+416,	yysvec+20,	yyvstop+630,
yycrank+424,	yysvec+20,	yyvstop+632,
yycrank+423,	yysvec+20,	yyvstop+634,
yycrank+418,	yysvec+20,	yyvstop+636,
yycrank+428,	yysvec+20,	yyvstop+638,
yycrank+429,	yysvec+20,	yyvstop+640,
yycrank+416,	yysvec+20,	yyvstop+642,
yycrank+432,	yysvec+20,	yyvstop+644,
yycrank+426,	yysvec+20,	yyvstop+646,
yycrank+438,	yysvec+20,	yyvstop+648,
yycrank+425,	yysvec+20,	yyvstop+650,
yycrank+0,	yysvec+20,	yyvstop+652,
yycrank+440,	yysvec+20,	yyvstop+655,
yycrank+430,	yysvec+20,	yyvstop+657,
yycrank+438,	yysvec+20,	yyvstop+659,
yycrank+438,	yysvec+20,	yyvstop+661,
yycrank+426,	yysvec+20,	yyvstop+663,
yycrank+441,	yysvec+20,	yyvstop+665,
yycrank+429,	yysvec+20,	yyvstop+667,
yycrank+0,	yysvec+20,	yyvstop+669,
yycrank+445,	yysvec+20,	yyvstop+672,
yycrank+441,	yysvec+20,	yyvstop+674,
yycrank+432,	yysvec+20,	yyvstop+676,
yycrank+431,	yysvec+20,	yyvstop+678,
yycrank+0,	yysvec+20,	yyvstop+680,
yycrank+434,	yysvec+20,	yyvstop+683,
yycrank+433,	yysvec+20,	yyvstop+685,
yycrank+0,	yysvec+20,	yyvstop+687,
yycrank+436,	yysvec+20,	yyvstop+690,
yycrank+0,	yysvec+20,	yyvstop+692,
yycrank+454,	yysvec+20,	yyvstop+695,
yycrank+437,	yysvec+20,	yyvstop+697,
yycrank+438,	yysvec+20,	yyvstop+699,
yycrank+440,	yysvec+20,	yyvstop+701,
yycrank+454,	yysvec+20,	yyvstop+704,
yycrank+455,	yysvec+20,	yyvstop+706,
yycrank+460,	yysvec+20,	yyvstop+708,
yycrank+461,	yysvec+20,	yyvstop+710,
yycrank+458,	yysvec+20,	yyvstop+712,
yycrank+458,	yysvec+20,	yyvstop+714,
yycrank+0,	yysvec+20,	yyvstop+716,
yycrank+453,	yysvec+20,	yyvstop+719,
yycrank+454,	yysvec+20,	yyvstop+721,
yycrank+453,	yysvec+20,	yyvstop+723,
yycrank+459,	yysvec+20,	yyvstop+725,
yycrank+0,	yysvec+20,	yyvstop+727,
yycrank+465,	yysvec+20,	yyvstop+730,
yycrank+461,	yysvec+20,	yyvstop+732,
yycrank+450,	yysvec+20,	yyvstop+734,
yycrank+452,	yysvec+20,	yyvstop+736,
yycrank+461,	yysvec+20,	yyvstop+738,
yycrank+465,	yysvec+20,	yyvstop+740,
yycrank+463,	yysvec+20,	yyvstop+742,
yycrank+460,	yysvec+20,	yyvstop+744,
yycrank+457,	yysvec+20,	yyvstop+746,
yycrank+458,	yysvec+20,	yyvstop+748,
yycrank+0,	yysvec+20,	yyvstop+750,
yycrank+464,	yysvec+20,	yyvstop+753,
yycrank+466,	yysvec+20,	yyvstop+755,
yycrank+0,	yysvec+20,	yyvstop+757,
yycrank+459,	yysvec+20,	yyvstop+760,
yycrank+467,	yysvec+20,	yyvstop+762,
yycrank+0,	yysvec+20,	yyvstop+764,
yycrank+468,	yysvec+20,	yyvstop+767,
yycrank+470,	yysvec+20,	yyvstop+769,
yycrank+471,	yysvec+20,	yyvstop+771,
yycrank+474,	yysvec+20,	yyvstop+773,
yycrank+482,	yysvec+20,	yyvstop+775,
yycrank+484,	yysvec+20,	yyvstop+777,
yycrank+480,	yysvec+20,	yyvstop+779,
yycrank+0,	yysvec+20,	yyvstop+781,
yycrank+0,	yysvec+20,	yyvstop+784,
yycrank+489,	yysvec+20,	yyvstop+787,
yycrank+471,	yysvec+20,	yyvstop+789,
yycrank+491,	yysvec+20,	yyvstop+791,
yycrank+484,	yysvec+20,	yyvstop+793,
yycrank+485,	yysvec+20,	yyvstop+795,
yycrank+479,	yysvec+20,	yyvstop+797,
yycrank+495,	yysvec+20,	yyvstop+799,
yycrank+0,	yysvec+20,	yyvstop+801,
yycrank+494,	yysvec+20,	yyvstop+804,
yycrank+489,	yysvec+20,	yyvstop+806,
yycrank+0,	yysvec+20,	yyvstop+808,
yycrank+498,	yysvec+20,	yyvstop+811,
yycrank+0,	yysvec+20,	yyvstop+813,
yycrank+0,	yysvec+20,	yyvstop+816,
yycrank+480,	yysvec+20,	yyvstop+819,
yycrank+483,	yysvec+20,	yyvstop+821,
yycrank+488,	yysvec+20,	yyvstop+823,
yycrank+494,	yysvec+20,	yyvstop+825,
yycrank+498,	yysvec+20,	yyvstop+827,
yycrank+500,	yysvec+20,	yyvstop+829,
yycrank+499,	yysvec+20,	yyvstop+831,
yycrank+492,	yysvec+20,	yyvstop+833,
yycrank+503,	yysvec+20,	yyvstop+835,
yycrank+495,	yysvec+20,	yyvstop+837,
yycrank+496,	yysvec+20,	yyvstop+839,
yycrank+493,	yysvec+20,	yyvstop+841,
yycrank+497,	yysvec+20,	yyvstop+843,
yycrank+508,	yysvec+20,	yyvstop+845,
yycrank+509,	yysvec+20,	yyvstop+847,
yycrank+0,	yysvec+20,	yyvstop+849,
yycrank+510,	yysvec+20,	yyvstop+852,
yycrank+0,	yysvec+20,	yyvstop+854,
yycrank+502,	yysvec+20,	yyvstop+857,
yycrank+0,	yysvec+20,	yyvstop+859,
yycrank+508,	yysvec+20,	yyvstop+862,
yycrank+500,	yysvec+20,	yyvstop+864,
yycrank+501,	yysvec+20,	yyvstop+866,
yycrank+513,	yysvec+20,	yyvstop+868,
yycrank+0,	yysvec+20,	yyvstop+870,
yycrank+0,	yysvec+20,	yyvstop+873,
yycrank+499,	yysvec+20,	yyvstop+876,
yycrank+518,	yysvec+20,	yyvstop+878,
yycrank+512,	yysvec+20,	yyvstop+880,
yycrank+509,	yysvec+20,	yyvstop+882,
yycrank+517,	yysvec+20,	yyvstop+884,
yycrank+523,	yysvec+20,	yyvstop+886,
yycrank+524,	yysvec+20,	yyvstop+888,
yycrank+514,	yysvec+20,	yyvstop+890,
yycrank+521,	yysvec+20,	yyvstop+892,
yycrank+517,	yysvec+20,	yyvstop+894,
yycrank+512,	yysvec+20,	yyvstop+896,
yycrank+507,	yysvec+20,	yyvstop+898,
yycrank+530,	yysvec+20,	yyvstop+900,
yycrank+530,	yysvec+20,	yyvstop+902,
yycrank+531,	yysvec+20,	yyvstop+904,
yycrank+534,	yysvec+20,	yyvstop+906,
yycrank+516,	yysvec+20,	yyvstop+908,
yycrank+530,	yysvec+20,	yyvstop+910,
yycrank+0,	yysvec+20,	yyvstop+912,
yycrank+520,	yysvec+20,	yyvstop+915,
yycrank+527,	yysvec+20,	yyvstop+917,
yycrank+0,	yysvec+20,	yyvstop+919,
yycrank+535,	yysvec+20,	yyvstop+922,
yycrank+539,	yysvec+20,	yyvstop+924,
yycrank+535,	yysvec+20,	yyvstop+926,
yycrank+527,	yysvec+20,	yyvstop+928,
yycrank+532,	yysvec+20,	yyvstop+930,
yycrank+0,	yysvec+20,	yyvstop+932,
yycrank+0,	yysvec+20,	yyvstop+935,
yycrank+0,	yysvec+20,	yyvstop+938,
yycrank+542,	yysvec+20,	yyvstop+941,
yycrank+0,	yysvec+20,	yyvstop+943,
yycrank+0,	yysvec+20,	yyvstop+946,
yycrank+531,	yysvec+20,	yyvstop+949,
yycrank+538,	yysvec+20,	yyvstop+951,
yycrank+546,	yysvec+20,	yyvstop+953,
yycrank+536,	yysvec+20,	yyvstop+955,
yycrank+548,	yysvec+20,	yyvstop+957,
yycrank+546,	yysvec+20,	yyvstop+959,
yycrank+533,	yysvec+20,	yyvstop+961,
yycrank+547,	yysvec+20,	yyvstop+963,
yycrank+0,	yysvec+20,	yyvstop+965,
yycrank+543,	yysvec+20,	yyvstop+968,
yycrank+534,	yysvec+20,	yyvstop+970,
yycrank+556,	yysvec+20,	yyvstop+972,
yycrank+545,	yysvec+20,	yyvstop+974,
yycrank+556,	yysvec+20,	yyvstop+976,
yycrank+553,	yysvec+20,	yyvstop+978,
yycrank+0,	yysvec+20,	yyvstop+980,
yycrank+549,	yysvec+20,	yyvstop+983,
yycrank+559,	yysvec+20,	yyvstop+985,
yycrank+560,	yysvec+20,	yyvstop+987,
yycrank+554,	yysvec+20,	yyvstop+989,
yycrank+559,	yysvec+20,	yyvstop+991,
yycrank+0,	yysvec+20,	yyvstop+993,
yycrank+0,	yysvec+20,	yyvstop+996,
yycrank+0,	yysvec+20,	yyvstop+999,
yycrank+566,	yysvec+20,	yyvstop+1002,
yycrank+0,	yysvec+20,	yyvstop+1004,
yycrank+551,	yysvec+20,	yyvstop+1007,
yycrank+550,	yysvec+20,	yyvstop+1009,
yycrank+548,	yysvec+20,	yyvstop+1011,
yycrank+567,	yysvec+20,	yyvstop+1013,
yycrank+561,	yysvec+20,	yyvstop+1015,
yycrank+554,	yysvec+20,	yyvstop+1017,
yycrank+0,	yysvec+20,	yyvstop+1019,
yycrank+566,	yysvec+20,	yyvstop+1022,
yycrank+571,	yysvec+20,	yyvstop+1024,
yycrank+563,	yysvec+20,	yyvstop+1026,
yycrank+0,	yysvec+20,	yyvstop+1028,
yycrank+573,	yysvec+20,	yyvstop+1031,
yycrank+574,	yysvec+20,	yyvstop+1033,
yycrank+562,	yysvec+20,	yyvstop+1035,
yycrank+0,	yysvec+20,	yyvstop+1037,
yycrank+560,	yysvec+20,	yyvstop+1040,
yycrank+579,	yysvec+20,	yyvstop+1042,
yycrank+0,	yysvec+20,	yyvstop+1044,
yycrank+581,	yysvec+20,	yyvstop+1047,
yycrank+579,	yysvec+20,	yyvstop+1049,
yycrank+0,	yysvec+20,	yyvstop+1051,
yycrank+564,	yysvec+20,	yyvstop+1054,
yycrank+567,	yysvec+20,	yyvstop+1056,
yycrank+0,	yysvec+20,	yyvstop+1058,
yycrank+0,	yysvec+20,	yyvstop+1061,
yycrank+0,	yysvec+20,	yyvstop+1064,
yycrank+579,	yysvec+20,	yyvstop+1067,
yycrank+585,	yysvec+20,	yyvstop+1069,
yycrank+0,	yysvec+20,	yyvstop+1071,
yycrank+582,	yysvec+20,	yyvstop+1074,
yycrank+578,	yysvec+20,	yyvstop+1076,
yycrank+0,	yysvec+20,	yyvstop+1078,
yycrank+572,	yysvec+20,	yyvstop+1081,
yycrank+573,	yysvec+20,	yyvstop+1084,
yycrank+568,	yysvec+20,	yyvstop+1086,
yycrank+585,	yysvec+20,	yyvstop+1088,
yycrank+0,	yysvec+20,	yyvstop+1090,
yycrank+575,	yysvec+20,	yyvstop+1093,
yycrank+0,	yysvec+20,	yyvstop+1095,
yycrank+0,	yysvec+20,	yyvstop+1098,
yycrank+0,	yysvec+20,	yyvstop+1101,
yycrank+0,	yysvec+20,	yyvstop+1104,
yycrank+0,	yysvec+20,	yyvstop+1107,
yycrank+0,	yysvec+20,	yyvstop+1110,
yycrank+0,	yysvec+20,	yyvstop+1113,
yycrank+0,	yysvec+20,	yyvstop+1116,
yycrank+576,	yysvec+20,	yyvstop+1119,
yycrank+588,	yysvec+20,	yyvstop+1121,
yycrank+0,	yysvec+20,	yyvstop+1123,
yycrank+583,	yysvec+20,	yyvstop+1126,
yycrank+585,	yysvec+20,	yyvstop+1128,
yycrank+0,	yysvec+20,	yyvstop+1130,
0,	0,	0};
struct yywork *yytop = yycrank+695;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,'.' ,'.' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,'A' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
