/* GNU Guix --- Functional package management for GNU
   Copyright (C) 2016, 2017 Ludovic Courtès <ludo@gnu.org>

   This file is part of GNU Guix.

   GNU Guix is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or (at
   your option) any later version.

   GNU Guix is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.  */

/* Interface to built-in derivation builders.  */

#pragma once

#include <derivations.hh>
#include <string>

namespace nix {

inline bool isBuiltin(const Derivation & drv)
{
	return drv.builder.starts_with("builtin:");
}

/* Build DRV, which lives at DRVPATH.  */
typedef void (*derivationBuilder) (const Derivation &drv,
                   const std::string &drvPath,
				   const std::string &output);

/* Return the built-in builder called BUILDER, or NULL if none was
   found.  */
derivationBuilder lookupBuiltinBuilder(const std::string &builder);

/* Return the list of supported built-in builder names.  */
std::list<std::string> builtinBuilderNames();
}
