/* System-dependent prototypes
   Copyright (C) 1985, 1993, 1994 Free Software Foundation, Inc.

This file is part of XEmacs.

XEmacs is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

XEmacs is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with XEmacs; see the file COPYING.  If not, write to the Free
Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Synched up with: FSF 19.28.  Split out of sysdep.c/emacs.c. */

#ifndef _XEMACS_SYSDEP_H_
#define _XEMACS_SYSDEP_H_

#include <setjmp.h>

#if !defined(VMS) || !defined(LINK_CRTL_SHARE) || !defined(SHAREABLE_LIB_BUG)
extern char **environ;
#else
extern noshare char **environ;
#endif /* VMS sharable environ bug */

struct emacs_tty;
extern int emacs_get_tty (int fd, struct emacs_tty *settings);
extern int emacs_set_tty (int fd, struct emacs_tty *settings, int waitp);

extern void stuff_char (struct device *d, int c);

extern void init_baud_rate (struct device *d);

extern void set_exclusive_use (int fd);

extern void set_descriptor_non_blocking (int fd);

extern void wait_without_blocking (void);

/* Wait for subprocess with process id `pid' to terminate and
   make sure it will get eliminated (not remain forever as a zombie) */
extern void wait_for_termination (int pid);

/* flush any pending output
 * (may flush input as well; it does not matter the way we use it)
 */
extern void flush_pending_output (int channel);

extern void child_setup_tty (int out);

/* Suspend the Emacs process; give terminal to its superior.  */
extern void sys_suspend (void);

extern void request_sigio (void);
extern void unrequest_sigio (void);

extern void stop_interrupts (void);
extern void start_interrupts (void);
extern void slow_down_interrupts (void);
extern void speed_up_interrupts (void);

/* Used so that signals can break out of system calls that aren't
   naturally interruptible. */

jmp_buf break_system_call_jump;
int can_break_system_calls;

extern int sys_write_1 (int fildes, CONST void *buf, unsigned int nbyte,
			int allow_quit);
extern int sys_read_1 (int fildes, void *buf, unsigned int nbyte,
		       int allow_quit);

/* Call these functions if you want to change some terminal parameter --
   reset the device, change the parameter, and init it again. */
extern void init_one_device (struct device *d);
extern void reset_one_device (struct device *d);

/* Prepare all terminals for exiting Emacs; move the cursor to the
   bottom of the frame, turn off special modes, etc.  Called at exit.
   This calls reset_one_device() on all devices and does some other
   stuff (e.g. fix the foreground pgroup). */

extern void reset_all_devices (void);

/* Call these functions if you are going to temporarily exit back to
   the shell (e.g. when suspending).  This calls reset_one_device()
   on the initial device and does some other stuff (e.g. fix the
   foreground pgroup). */

extern void reset_initial_device (void);
extern void reinit_initial_device (void);

/* We muck around with our process group.  This function needs
   to be called at startup.  The rest of the mucking is done as
   part of the functions reset_all_devices(), reset_initial_device(),
   and reinit_initial_device(). */

extern void init_process_group (void);
extern void munge_tty_process_group (void);
extern void unmunge_tty_process_group (void);

extern void disconnect_controlling_terminal (void);

/* Return nonzero if safe to use tabs in output.
   At the time this is called, init_sys_modes has not been done yet.  */
extern int tabs_safe_p (struct device *d);

/* Get terminal size from system.
   If zero or a negative number is stored, the value is not valid.  */
extern void get_tty_device_size (struct device *d, int *widthp, int *heightp);
/* Set the logical window size associated with descriptor FD */
extern int set_window_size (int fd, int height, int width);

/* Set up the proper status flags for use of a pty.  */
extern void setup_pty (int fd);

/* Return the address of the start of the text segment prior to unexec. */
extern char *start_of_text (void);
/* Return the address of the start of the data segment prior to unexec. */
extern void *start_of_data (void);
/* Return the address of the end of the text segment prior to unexec. */
extern char *end_of_text (void);
/* Return the address of the end of the data segment prior to unexec. */
extern char *end_of_data (void);


/* Get_system_name returns as its value a string for system-name to return. */
extern void init_system_name (void);

#ifndef HAVE_GETWD
extern char *getwd (char *pathname);
#endif

#ifndef HAVE_RENAME
extern int rename (CONST char *from, CONST char *to);
#endif

#ifndef HAVE_DUP2
extern int dup2 (int oldd, int newd);
#endif

#ifdef VMS
extern void init_vms_input (void);
extern void stop_vms_input (void);

extern int vms_truncate (char *fn);
extern int vlimit (void);       /* BTW, name conflicts with unix syscall */
extern int define_logical_name (char *varname, char *string)
extern int delete_logical_name (char *varname);
extern int rename_sans_version (char *from, char *to);
extern char *vmserrstr (int status);
extern char *sys_translate_vms (char *vfile);
extern char *sys_translate_unix (char *ufile);
extern int creat_copy_attrs (char *old, char *new);
extern int link (char *file, char *new);
#endif /* VMS */

#ifndef HAVE_STRERROR
/* X11R6 defines strerror as a macro */
# ifdef strerror
# undef strerror
# endif
extern CONST char *strerror (int);
#endif

#ifndef HAVE_H_ERRNO
extern int h_errno;
#endif

#endif /* _XEMACS_SYSDEP_H_ */
