;;; finder-inf.el --- keyword-to-package mapping
;; Keywords: help
;;; Commentary:
;; Don't edit this file.  It's generated by finder.el

;;; Code:

(setq finder-package-info '(
    ("paths.el"
        "define pathnames for use by various Emacs commands."
        (internal)
        "lisp/")
    ("bytecomp.el"
        "compilation of Lisp code into byte code."
        (internal)
        "lisp/bytecomp/")
    ("disass.el"
        "disassembler for compiled Emacs Lisp code"
        (internal)
        "lisp/bytecomp/")
    ("appt.el"
        "appointment notification functions."
        (calendar)
        "lisp/calendar/")
    ("cal-dst.el"
        "calendar functions for daylight savings rules."
        (calendar)
        "lisp/calendar/")
    ("cal-french.el"
        "calendar functions for the French Revolutionary calendar."
        (calendar)
        "lisp/calendar/")
    ("cal-mayan.el"
        "calendar functions for the Mayan calendars."
        (calendar)
        "lisp/calendar/")
    ("cal-x.el"
        "calendar windows in dedicated frames in x-windows"
        (calendar)
        "lisp/calendar/")
    ("cal-xemacs.el"
        "calendar functions for menu bar and popup menu support"
        (calendar)
        "lisp/calendar/")
    ("calendar.el"
        "Calendar functions."
        (calendar)
        "lisp/calendar/")
    ("diary-ins.el"
        "calendar functions for adding diary entries."
        (diary  calendar)
        "lisp/calendar/")
    ("diary-lib.el"
        "diary functions."
        (calendar)
        "lisp/calendar/")
    ("holidays.el"
        "holiday functions for the calendar package"
        (holidays  calendar)
        "lisp/calendar/")
    ("lunar.el"
        "calendar functions for phases of the moon."
        (calendar)
        "lisp/calendar/")
    ("solar.el"
        "calendar functions for solar events."
        (calendar)
        "lisp/calendar/")
    ("background.el"
        "fun with background jobs"
        (processes)
        "lisp/comint/")
    ("comint.el"
        "general command interpreter in a window stuff"
        (processes)
        "lisp/comint/")
    ("dbx.el"
        "run dbx under Emacs"
        (c  unix  tools  debugging)
        "lisp/comint/")
    ("gdb.el"
        "run gdb under Emacs"
        (c  unix  tools  debugging)
        "lisp/comint/")
    ("gud.el"
        "Grand Unified Debugger mode for gdb, sdb, dbx, or xdb"
        (c  unix  tools  debugging)
        "lisp/comint/")
    ("inf-lisp.el"
        "an inferior-lisp mode"
        (processes  lisp)
        "lisp/comint/")
    ("kermit.el"
        "additions to shell mode for use with kermit, etc."
        (comm  processes)
        "lisp/comint/")
    ("rlogin.el"
        "remote login interface"
        (unix  comm)
        "lisp/comint/")
    ("shell.el"
        "specialized comint.el for running the shell."
        (processes)
        "lisp/comint/")
    ("telnet.el"
        "run a telnet session from within an Emacs buffer"
        (comm  unix)
        "lisp/comint/")
    ("ange-ftp.el"
        "transparent FTP support for GNU Emacs"
        (comm)
        "lisp/dired/")
    ("dired-link.el"
        "Properly resolves UNIX (and Apollo variant) links under dired."
        nil
        "lisp/dired/")
    ("dired-x.el"
        "Sebastian Kremer's Extra DIRED hacked up for GNU Emacs19"
        (dired extensions)
        "lisp/dired/")
    ("dired.el"
        "directory-browsing commands"
        (dired extensions)
        "lisp/dired/")
    ("cust-print.el"
        "handles print-level and print-circle."
        (extensions)
        "lisp/edebug/")
    ("edebug.el"
        "a source-level debugger for Emacs Lisp"
        (lisp  tools  debugging)
        "lisp/edebug/")
    ("ediff-diff.el"
        "diff-related utilities"
        nil
        "lisp/ediff/")
    ("ediff-hook.el"
        "setup for Ediff's menus and autoloads"
        nil
        "lisp/ediff/")
    ("ediff-init.el"
        "Macros, variables, and defsubsts used by Ediff"
        nil
        "lisp/ediff/")
    ("ediff-merg.el"
        "merging utilities"
        nil
        "lisp/ediff/")
    ("ediff-meta.el"
        "support for multi-file/multi-buffer processing in Ediff"
        nil
        "lisp/ediff/")
    ("ediff-util.el"
        "the core commands and utilities of ediff"
        nil
        "lisp/ediff/")
    ("ediff-wind.el"
        "window manipulation utilities"
        nil
        "lisp/ediff/")
    ("ediff.el"
        "a comprehensive visual interface to diff & patch"
        (comparing  merging  patching  version control.)
        "lisp/ediff/")
    ("ebuff-menu.el"
        "electric-buffer-list mode"
        nil
        "lisp/electric/")
    ("echistory.el"
        "Electric Command History Mode"
        nil
        "lisp/electric/")
    ("ehelp.el"
        "bindings for electric-help mode"
        (help  extensions)
        "lisp/electric/")
    ("electric.el"
        "window maker and Command loop for `electric' modes."
        (extensions)
        "lisp/electric/")
    ("helper.el"
        "utility help package supporting help in electric modes"
        (help)
        "lisp/electric/")
    ("edt.el"
        "EDT emulation in Emacs"
        (emulations)
        "lisp/emulators/")
    ("gosmacs.el"
        "rebindings to imitate Gosmacs."
        (emulations)
        "lisp/emulators/")
    ("mlconvert.el"
        "convert buffer of Mocklisp code to real lisp."
        (emulations)
        "lisp/emulators/")
    ("mlsupport.el"
        "run-time support for mocklisp code."
        (extensions)
        "lisp/emulators/")
    ("teco.el"
        "Teco interpreter for Gnu Emacs, version 1."
        nil
        "lisp/emulators/")
    ("tpu-doc.el"
        "Documentation for TPU-edt"
        (emulations)
        "lisp/emulators/")
    ("tpu-edt.el"
        "Emacs emulating TPU emulating EDT"
        (emulations)
        "lisp/emulators/")
    ("tpu-extras.el"
        "Scroll margins and free cursor mode for TPU-edt"
        (emulations)
        "lisp/emulators/")
    ("ws-mode.el"
        "WordStar emulation mode for GNU Emacs"
        nil
        "lisp/emulators/")
    ("eos.el"
        "Intereactively loads the XEmacs/SPARCworks interface"
        (sparcworks eos era on sparcworks load)
        "lisp/eos/")
    ("loaddefs-eos.el"
        "define standard autoloads of other files"
        (internal)
        "lisp/eos/")
    ("sun-eos-browser.el"
        "Implements the XEmacs/SPARCworks SourceBrowser interface"
        (sparcworks eos era on sparcworks sbrowser source browser)
        "lisp/eos/")
    ("sun-eos-debugger-extra.el"
        "Implements the XEmacs/SPARCworks Debugger interface"
        (sparcworks eos era on sparcworks debugger dbx)
        "lisp/eos/")
    ("sun-eos-debugger.el"
        "Implements the XEmacs/SPARCworks interface"
        (sparcworks eos era on sparcworks debugger dbx)
        "lisp/eos/")
    ("sun-eos-editor.el"
        "Implements the XEmacs/SPARCworks editor protocol"
        (sparcworks eos era on sparcworks editor)
        "lisp/eos/")
    ("sun-eos-init.el"
        "Initializes the XEmacs/SPARCworks interface"
        (sparcworks eos era on sparcworks initialize)
        "lisp/eos/")
    ("sun-eos-load.el"
        "Loads the XEmacs/SPARCworks interface code"
        (sparcworks eos era on sparcworks debugger dbx)
        "lisp/eos/")
    ("sun-eos-menubar.el"
        "Implements the XEmacs/SPARCworks menubar"
        (sparcworks eos era on sparcworks menubar)
        "lisp/eos/")
    ("sun-eos-toolbar.el"
        "Implements the EOS toolbar interface"
        (sparcworks eos era on sparcworks toolbar)
        "lisp/eos/")
    ("sun-eos.el"
        "Intereactively loads the XEmacs/SPARCworks interface"
        (sparcworks eos era on sparcworks load)
        "lisp/eos/")
    ("tshell.el"
        "specialized term.el for running the shell."
        (processes)
        "lisp/eterm/")
    ("blackbox.el"
        "blackbox game in Emacs Lisp"
        (games)
        "lisp/games/")
    ("cookie1.el"
        "retrieve random phrases from fortune cookie files"
        (games)
        "lisp/games/")
    ("dissociate.el"
        "scramble text amusingly for Emacs."
        (games)
        "lisp/games/")
    ("doctor.el"
        "psychological help for frustrated users."
        (games)
        "lisp/games/")
    ("dunnet.el"
        "Text adventure for Emacs"
        (games)
        "lisp/games/")
    ("gomoku.el"
        "Gomoku game between you and Emacs"
        (games)
        "lisp/games/")
    ("hanoi.el"
        "towers of hanoi in GNUmacs"
        (games)
        "lisp/games/")
    ("life.el"
        "John Horton Conway's `Life' game for GNU Emacs"
        (games)
        "lisp/games/")
    ("mpuz.el"
        "multiplication puzzle for GNU Emacs"
        (games)
        "lisp/games/")
    ("spook.el"
        "spook phrase utility for overloading the NSA line eater"
        (games)
        "lisp/games/")
    ("studly.el"
        "StudlyCaps (tm)(r)(c)(xxx)"
        (games)
        "lisp/games/")
    ("yow.el"
        "quote random zippyisms"
        (games)
        "lisp/games/")
    ("chat.el"
        "a method for talking to asynchronous processes."
        nil
        "lisp/gnus/")
    ("gnus-virt.el"
        "framework for \"virtual\" newsgroups"
        nil
        "lisp/gnus/")
    ("gnusmail.el"
        "mail reply commands for GNUS newsreader"
        (news)
        "lisp/gnus/")
    ("gnusmisc.el"
        "miscellaneous commands for GNUS newsreader"
        (news)
        "lisp/gnus/")
    ("gnuspost.el"
        "post news commands for GNUS newsreader"
        (news)
        "lisp/gnus/")
    ("mhspool.el"
        "MH folder access using NNTP for GNU Emacs"
        (mail  news)
        "lisp/gnus/")
    ("nnspool.el"
        "spool access using NNTP for GNU Emacs"
        (news)
        "lisp/gnus/")
    ("nntp.el"
        "GNUS interface to NNTP servers"
        nil
        "lisp/gnus/")
    ("old-nntp.el"
        "NNTP (RFC977) Interface for GNU Emacs"
        (news)
        "lisp/gnus/")
    ("html-mode.el"
        "Major mode for editing HTML hypertext documents for the WWW"
        (hypermedia languages help docs wp)
        "lisp/hm--html-menus/")
    ("html-view.el"
        "routines for communicating with a NCSA Mosaic process"
        nil
        "lisp/hm--html-menus/")
    ("tmpl-minor-mode.el"
        "Template Minor Mode"
        nil
        "lisp/hm--html-menus/")
    ("hact.el"
        "Hyperbole button action handling."
        (hypermedia)
        "lisp/hyperbole/")
    ("hactypes.el"
        "Default action types for Hyperbole."
        (extensions  hypermedia)
        "lisp/hyperbole/")
    ("hargs.el"
        "Obtains user input through Emacs for Hyperbole"
        (extensions  hypermedia)
        "lisp/hyperbole/")
    ("hbdata.el"
        "Hyperbole button attribute accessor methods."
        (hypermedia)
        "lisp/hyperbole/")
    ("hbmap.el"
        "Hyperbole button map maintenance for queries and lookups."
        (hypermedia  matching)
        "lisp/hyperbole/")
    ("hbut.el"
        "Hyperbole button constructs."
        (extensions  hypermedia)
        "lisp/hyperbole/")
    ("hgnus.el"
        "Support Hyperbole buttons in news reader/poster: GNUS."
        (hypermedia  news)
        "lisp/hyperbole/")
    ("hhist.el"
        "Maintains history of Hyperbole buttons selected."
        (hypermedia)
        "lisp/hyperbole/")
    ("hib-doc-id.el"
        "Implicit button type for document id index entries."
        (docs  extensions  hypermedia)
        "lisp/hyperbole/")
    ("hib-kbd.el"
        "Implicit button type for key sequences delimited with {}."
        (extensions  hypermedia)
        "lisp/hyperbole/")
    ("hibtypes.el"
        "Hyperbole System Implicit Button Types."
        (extensions  hypermedia)
        "lisp/hyperbole/")
    ("hinit.el"
        "Standard initializations for Hyperbole hypertext system."
        (hypermedia)
        "lisp/hyperbole/")
    ("hlvar.el"
        "Permits use of Hyperbole variables in local variable lists."
        (extensions  hypermedia)
        "lisp/hyperbole/")
    ("hmail.el"
        "Support for Hyperbole buttons embedded in e-mail messages."
        (hypermedia  mail)
        "lisp/hyperbole/")
    ("hmh.el"
        "Support for Hyperbole buttons in mail reader: Mh."
        (hypermedia  mail)
        "lisp/hyperbole/")
    ("hmoccur.el"
        "Multi-buffer or multi-file regexp occurrence location."
        (hypermedia  matching)
        "lisp/hyperbole/")
    ("hmous-info.el"
        "Walks through Info networks using one key."
        (docs  help  hypermedia  mouse)
        "lisp/hyperbole/")
    ("hmouse-drv.el"
        "Smart Key/Mouse driver functions."
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hmouse-key.el"
        "Load \"hmouse-sh.el\" or \"hmouse-reg.el\" for Smart Key bindings."
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hmouse-mod.el"
        "Action Key acts as CONTROL modifier and Assist Key as META modifier."
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hmouse-reg.el"
        "System-dependent Smart Mouse Key bindings (no shift key)."
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hmouse-sh.el"
        "System-dependent Smart Mouse Key bindings (using shift key)."
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hmouse-tag.el"
        "Smart Key support of programming language tags location."
        (c  hypermedia  mouse  oop  tools)
        "lisp/hyperbole/")
    ("hpath.el"
        "Hyperbole support routines for handling UNIX paths.  "
        (comm  hypermedia  unix)
        "lisp/hyperbole/")
    ("hrmail.el"
        "Support for Hyperbole buttons in mail reader: Rmail."
        (hypermedia  mail)
        "lisp/hyperbole/")
    ("hsite-ex.el"
        "Site-specific setup for Hyperbole"
        (hypermedia  local)
        "lisp/hyperbole/")
    ("hsite.el"
        "Site-specific setup for Hyperbole"
        (hypermedia  local)
        "lisp/hyperbole/")
    ("hsmail.el"
        "Support for Hyperbole buttons in mail composer: mail and mh-letter."
        (hypermedia  mail)
        "lisp/hyperbole/")
    ("hsys-hbase.el"
        "Hyperbole support for the Hyperbase system."
        (comm  hypermedia)
        "lisp/hyperbole/")
    ("hsys-w3.el"
        "Hyperbole support for Emacs W3 World-Wide Web (WWW) browsing."
        (comm  help  hypermedia)
        "lisp/hyperbole/")
    ("hsys-wais.el"
        "Hyperbole support for WAIS browsing."
        (comm  help  hypermedia)
        "lisp/hyperbole/")
    ("hsys-www.el"
        "Hyperbole support for old CERN command line WWW browsing."
        (comm  help  hypermedia)
        "lisp/hyperbole/")
    ("htz.el"
        "Timezone-based time and date support for Hyperbole."
        (calendar  hypermedia)
        "lisp/hyperbole/")
    ("hui-em19-b.el"
        "GNU Emacs V19 button highlighting and flashing support."
        (faces  hypermedia)
        "lisp/hyperbole/")
    ("hui-ep-but.el"
        "Support for highlighting/flashing buttons under Epoch."
        (faces  hypermedia)
        "lisp/hyperbole/")
    ("hui-epV4-b.el"
        "Support color and flashing of hyper-buttons under Epoch V4"
        (faces  hypermedia)
        "lisp/hyperbole/")
    ("hui-menu.el"
        "InfoDock/Emacs menubar menu of Hyperbole commands."
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hui-menus.el"
        "One line command menus for Hyperbole"
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hui-mouse.el"
        "Use key or mouse key for many functions, e.g. Hypb menus."
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hui-window.el"
        "Smart Mouse Key window and modeline depress/release actions."
        (hypermedia  mouse)
        "lisp/hyperbole/")
    ("hui-xe-but.el"
        "XEmacs button highlighting and flashing support."
        (faces  hypermedia)
        "lisp/hyperbole/")
    ("hui.el"
        "GNU Emacs User Interface to Hyperbole"
        (hypermedia)
        "lisp/hyperbole/")
    ("hvar.el"
        "Variable manipulation routines for Hyperbole."
        (extensions  hypermedia)
        "lisp/hyperbole/")
    ("hversion.el"
        "Hyperbole version, system and load path information."
        (hypermedia)
        "lisp/hyperbole/")
    ("hvm.el"
        "Support Hyperbole buttons in mail reader: Vm."
        (hypermedia  mail)
        "lisp/hyperbole/")
    ("hypb.el"
        "Miscellaneous Hyperbole support features."
        (extensions  hypermedia)
        "lisp/hyperbole/")
    ("hyperbole.el"
        "Sets up Hyperbole for autoloading and use."
        (hypermedia)
        "lisp/hyperbole/")
    ("set.el"
        "Provide general mathematical operators on unordered sets."
        (extensions  tools)
        "lisp/hyperbole/")
    ("wconfig.el"
        "Saves and yanks from save ring of window configurations."
        (frames  hypermedia)
        "lisp/hyperbole/")
    ("wrolo-logic.el"
        "Performs logical retrievals on rolodex files"
        (hypermedia  matching)
        "lisp/hyperbole/")
    ("wrolo-menu.el"
        "Pulldown and popup menus of Hyperbole rolodex commands."
        (hypermedia  matching  mouse)
        "lisp/hyperbole/")
    ("wrolo.el"
        "Hierarchical, multi-file, easy to use rolodex system"
        (hypermedia  matching)
        "lisp/hyperbole/")
    ("kfile.el"
        "Save and restore kotls from files."
        (outlines  wp)
        "lisp/hyperbole/kotl/")
    ("kfill.el"
        "Fill and justify koutline cells (adapted from Kyle Jones' filladapt)."
        (outlines  wp)
        "lisp/hyperbole/kotl/")
    ("kimport.el"
        "Convert and insert other outline file formats into koutlines."
        (data  outlines  wp)
        "lisp/hyperbole/kotl/")
    ("klabel.el"
        "Display label handling for koutlines."
        (outlines  wp)
        "lisp/hyperbole/kotl/")
    ("klink.el"
        "Implicit reference to a kcell action type, for use in koutlines."
        (extensions  hypermedia  outlines  wp)
        "lisp/hyperbole/kotl/")
    ("kmenu.el"
        "Pulldown and popup menus for kotl-mode, the Hyperbole Outliner."
        (mouse  outlines  wp)
        "lisp/hyperbole/kotl/")
    ("knode.el"
        "Generic nodes for use as elements in data structures."
        (extensions  hypermedia  outlines)
        "lisp/hyperbole/kotl/")
    ("kotl-mode.el"
        "Major mode for editing koutlines and associated commands."
        (data  hypermedia  outlines  wp)
        "lisp/hyperbole/kotl/")
    ("kotl.el"
        "Internal representation of outline kcells used by kviews."
        (outlines  wp)
        "lisp/hyperbole/kotl/")
    ("kprop-em19.el"
        "Koutline text property handling under Emacs 19."
        (outlines  wp)
        "lisp/hyperbole/kotl/")
    ("kprop-xe.el"
        "Koutline text property handling under XEmacs."
        (outlines  wp)
        "lisp/hyperbole/kotl/")
    ("kproperty.el"
        "Wrapper for koutline text property implementations."
        (outlines  wp)
        "lisp/hyperbole/kotl/")
    ("kview.el"
        "Display handling of koutlines."
        (outlines  wp)
        "lisp/hyperbole/kotl/")
    ("iso-ascii.el"
        "set up char tables for ISO 8859/1 on ASCII terminals."
        (i18n)
        "lisp/iso/")
    ("iso-insert.el"
        "insert functions for ISO 8859/1."
        (i18n)
        "lisp/iso/")
    ("iso-swed.el"
        "set up char tables for ISO 8859/1 for Swedish/Finnish ttys"
        (i18n)
        "lisp/iso/")
    ("iso-syntax.el"
        "set up case-conversion and syntax tables for ISO 8859/1"
        (i18n)
        "lisp/iso/")
    ("swedish.el"
        "miscellaneous functions for dealing with Swedish."
        (i18n)
        "lisp/iso/")
    ("mh-comp.el"
        "mh-e functions for composing messages"
        nil
        "lisp/mh-e/")
    ("mh-e.el"
        "GNU Emacs interface to the MH mail system"
        (mail)
        "lisp/mh-e/")
    ("mh-funcs.el"
        "mh-e functions not everyone will use right away"
        nil
        "lisp/mh-e/")
    ("mh-mime.el"
        "mh-e support for composing MIME messages"
        nil
        "lisp/mh-e/")
    ("mh-pick.el"
        "make a search pattern and search for a message in mh-e"
        nil
        "lisp/mh-e/")
    ("mh-seq.el"
        "mh-e sequences support"
        nil
        "lisp/mh-e/")
    ("mh-utils.el"
        "mh-e code needed for both sending and reading"
        nil
        "lisp/mh-e/")
    ("abbrev.el"
        "abbrev mode commands for Emacs"
        (internal  abbrev)
        "lisp/modes/")
    ("ada.el"
        "Ada editing support package in GNUlisp.  v1.0"
        (languages)
        "lisp/modes/")
    ("arc-mode.el"
        "simple editing of archives"
        (archives msdog editing major-mode)
        "lisp/modes/")
    ("asm-mode.el"
        "mode for editing assembler code"
        (tools  languages)
        "lisp/modes/")
    ("awk-mode.el"
        "AWK code editing commands for Emacs"
        (unix  languages)
        "lisp/modes/")
    ("bib-mode.el"
        "bib-mode, major mode for editing bib files."
        (bib  wp)
        "lisp/modes/")
    ("bibtex.el"
        "BibTeX mode for GNU Emacs"
        (tex  bib)
        "lisp/modes/")
    ("c-comment.el"
        "edit C comments"
        (c)
        "lisp/modes/")
    ("cc-compat.el"
        "cc-mode compatibility with c-mode.el confusion"
        (c languages oop)
        "lisp/modes/")
    ("cc-guess.el"
        "guess indentation values by scanning existing code"
        (c languages oop)
        "lisp/modes/")
    ("cc-lobotomy.el"
        "excise portions of cc-mode's brain... for speed"
        (c languages oop)
        "lisp/modes/")
    ("cc-mode.el"
        "major mode for editing C, C++, and Objective-C code"
        (c languages oop)
        "lisp/modes/")
    ("cmacexp.el"
        "expand C macros in a region"
        (c)
        "lisp/modes/")
    ("fortran-misc.el"
        "Routines than can be used with fortran mode."
        (languages)
        "lisp/modes/")
    ("fortran.el"
        "Fortran mode for GNU Emacs"
        (languages)
        "lisp/modes/")
    ("hideif.el"
        "hides selected code within ifdef."
        (c)
        "lisp/modes/")
    ("hideshow.el"
        "minor mode cmds to selectively display blocks of code"
        nil
        "lisp/modes/")
    ("icon.el"
        "mode for editing Icon code"
        (languages)
        "lisp/modes/")
    ("lisp-mnt.el"
        "minor mode for Emacs Lisp maintainers"
        (docs)
        "lisp/modes/")
    ("lisp-mode.el"
        "Lisp mode, and its idiosyncratic commands."
        (lisp  languages)
        "lisp/modes/")
    ("makefile.el"
        "makefile editing commands for Emacs"
        (unix  tools)
        "lisp/modes/")
    ("mim-mode.el"
        "Mim (MDL in MDL) mode."
        (languages)
        "lisp/modes/")
    ("mim-syntax.el"
        "syntax checker for Mim (MDL)."
        (languages)
        "lisp/modes/")
    ("modula2.el"
        "Modula-2 editing support package"
        (languages)
        "lisp/modes/")
    ("nroff-mode.el"
        "GNU Emacs major mode for editing nroff source"
        (wp)
        "lisp/modes/")
    ("old-c++-mode.el"
        "major mode for editing C++ (and C) code"
        (c)
        "lisp/modes/")
    ("old-c-mode.el"
        "C code editing commands for Emacs"
        (c)
        "lisp/modes/")
    ("outl-mouse.el"
        "outline mode mouse commands for Emacs"
        (outlines  mouse)
        "lisp/modes/")
    ("outline.el"
        "outline mode commands for Emacs"
        (outlines)
        "lisp/modes/")
    ("perl-mode.el"
        "Perl code editing commands for GNU Emacs"
        (languages)
        "lisp/modes/")
    ("picture.el"
        "\"Picture mode\" -- editing using quarter-plane screen model."
        nil
        "lisp/modes/")
    ("postscript.el"
        "major mode for editing PostScript programs"
        (langauges)
        "lisp/modes/")
    ("prolog.el"
        "major mode for editing and running Prolog under Emacs"
        (languages)
        "lisp/modes/")
    ("rexx-mode.el"
        "major mode for editing REXX program files"
        (languages)
        "lisp/modes/")
    ("rsz-minibuf.el"
        "dynamically resize minibuffer to display entire contents"
        nil
        "lisp/modes/")
    ("scheme.el"
        "Scheme mode, and its idiosyncratic commands."
        (languages  lisp)
        "lisp/modes/")
    ("scribe.el"
        "scribe mode, and its idiosyncratic commands."
        (wp)
        "lisp/modes/")
    ("sendmail.el"
        "mail sending commands for Emacs."
        (mail)
        "lisp/modes/")
    ("sgml-mode.el"
        "SGML-editing mode"
        (wp)
        "lisp/modes/")
    ("simula.el"
        "SIMULA 87 code editing commands for Emacs"
        (languages)
        "lisp/modes/")
    ("tex-mode.el"
        "TeX, LaTeX, and SliTeX mode commands."
        nil
        "lisp/modes/")
    ("text-mode.el"
        "text mode, and its idiosyncratic commands."
        nil
        "lisp/modes/")
    ("two-column.el"
        "minor mode for editing of two-column text"
        nil
        "lisp/modes/")
    ("view-less.el"
        "Minor mode for browsing files with keybindings like `less'"
        nil
        "lisp/modes/")
    ("view.el"
        "peruse file or buffer without editing."
        (wp unix)
        "lisp/modes/")
    ("br-c++-ft.el"
        "C++ OO-Browser class and member functions."
        (c  oop  tools)
        "lisp/oobr/")
    ("br-c++.el"
        "Support routines for C++ inheritance browsing."
        (c  oop  tools)
        "lisp/oobr/")
    ("br-c-ft.el"
        "OO-Browser C construct handling."
        (c  tools)
        "lisp/oobr/")
    ("br-clos-ft.el"
        "CLOS OO-Browser class and element functions."
        (lisp  oop  tools)
        "lisp/oobr/")
    ("br-clos.el"
        "Support routines for CLOS inheritance browsing."
        (lisp  oop  tools)
        "lisp/oobr/")
    ("br-compl.el"
        "Most functions for performing completion on OO constructs."
        (matching  oop  tools)
        "lisp/oobr/")
    ("br-eif-ft.el"
        "Eiffel OO-Browser class and feature functions."
        (oop  tools)
        "lisp/oobr/")
    ("br-eif.el"
        "Support routines for Eiffel inheritance browsing and error parsing."
        (oop  tools)
        "lisp/oobr/")
    ("br-env.el"
        "OO-Browser Environment support functions."
        (oop  tools)
        "lisp/oobr/")
    ("br-ftr.el"
        "OO-Browser feature browsing support."
        (oop  tools)
        "lisp/oobr/")
    ("br-info.el"
        "Support routines for Info file hierarchy browsing."
        (docs  help  hypermedia)
        "lisp/oobr/")
    ("br-init.el"
        "OO-Browser per Emacs session initialization."
        (oop  tools)
        "lisp/oobr/")
    ("br-lib.el"
        "OO-Browser support functions."
        (oop  tools)
        "lisp/oobr/")
    ("br-menu.el"
        "Pulldown and popup menus for the OO-Browser."
        (mouse  oop  tools)
        "lisp/oobr/")
    ("br-objc-ft.el"
        "Objective-C OO-Browser class and feature functions."
        (c  oop  tools)
        "lisp/oobr/")
    ("br-objc.el"
        "Support routines for Objective-C inheritance browsing."
        (c  oop  tools)
        "lisp/oobr/")
    ("br-site.el"
        "Site OO-Browser per Emacs session initialization."
        (local  oop  tools)
        "lisp/oobr/")
    ("br-smt.el"
        "Support routines for Smalltalk inheritance browsing and error parsing."
        (oop  tools)
        "lisp/oobr/")
    ("br-start.el"
        "Select language and invoke OO-Browser."
        (oop  tools)
        "lisp/oobr/")
    ("br-tree.el"
        "Interface between textual and graphical OO-Browsers."
        (mouse  oop  tools)
        "lisp/oobr/")
    ("br-vers.el"
        "OO-Browser revision number as 'br-version' variable."
        (oop  tools)
        "lisp/oobr/")
    ("br.el"
        "Browse object-oriented code."
        (matching  oop  tools)
        "lisp/oobr/")
    ("c++-browse.el"
        "C++ source code browser."
        (c  oop  tools)
        "lisp/oobr/")
    ("clos-brows.el"
        "Common Lisp/CLOS source code browser."
        (lisp  oop  tools)
        "lisp/oobr/")
    ("eif-browse.el"
        "Eiffel source code browser."
        (oop  tools)
        "lisp/oobr/")
    ("eif-calls.el"
        "Produce first level static call tree for Eiffel class."
        (oop  tools)
        "lisp/oobr/")
    ("eif-ise-er.el"
        "Parses ISE's Eiffel error messages; compiles Eiffel classes."
        (oop  tools)
        "lisp/oobr/")
    ("hash-test.el"
        "Interactively test functions from hasht.el."
        (extensions  maint  tools)
        "lisp/oobr/")
    ("hasht.el"
        "Create hash tables from lists and operate on them."
        (extensions  tools)
        "lisp/oobr/")
    ("hmouse-br.el"
        "Hyperbole Key control for the OO-Browser."
        (mouse  oop  tools)
        "lisp/oobr/")
    ("info-brows.el"
        "Support routines for Info inheritance browsing and error parsing."
        (docs  help  hypermedia)
        "lisp/oobr/")
    ("objc-brows.el"
        "Objective-C source code browser."
        (c  oop  tools)
        "lisp/oobr/")
    ("smt-browse.el"
        "Smalltalk source code browser."
        (oop  tools)
        "lisp/oobr/")
    ("add-log.el"
        "change log maintenance commands for Emacs"
        (maint)
        "lisp/packages/")
    ("apropos.el"
        "faster apropos commands."
        (help)
        "lisp/packages/")
    ("array.el"
        "array editing commands for XEmacs"
        (extensions)
        "lisp/packages/")
    ("auto-save.el"
        "safer auto saving with support for ange-ftp and /tmp"
        nil
        "lisp/packages/")
    ("autoinsert.el"
        "automatic mode-dependent insertion of text into new files"
        nil
        "lisp/packages/")
    ("avoid.el"
        "make mouse pointer stay out of the way of editing."
        (mouse)
        "lisp/packages/")
    ("blink-paren.el"
        "blink the matching paren, just like Zmacs"
        (faces)
        "lisp/packages/")
    ("bookmark.el"
        "set bookmarks, maybe annotate them, jump to them later."
        (bookmarks  placeholders  annotations)
        "lisp/packages/")
    ("buff-menu.el"
        "buffer menu main function and support functions."
        nil
        "lisp/packages/")
    ("chistory.el"
        "list command history"
        nil
        "lisp/packages/")
    ("cmuscheme.el"
        "Scheme process in a buffer. Adapted from tea.el."
        (processes  lisp)
        "lisp/packages/")
    ("column.el"
        "display line and column in the mode line"
        nil
        "lisp/packages/")
    ("compare-w.el"
        "compare text between windows for Emacs."
        nil
        "lisp/packages/")
    ("compile.el"
        "run compiler as inferior of Emacs, parse error messages."
        (tools  processes)
        "lisp/packages/")
    ("completion.el"
        "dynamic word-completion code"
        (abbrev)
        "lisp/packages/")
    ("crypt.el"
        "code for handling all sorts of compressed and encrypted files"
        (extensions)
        "lisp/packages/")
    ("dabbrev.el"
        "dynamic abbreviation package"
        (abbrev expand completion)
        "lisp/packages/")
    ("desktop.el"
        "save partial status of Emacs when killed"
        (customization)
        "lisp/packages/")
    ("detexinfo.el"
        "remove Texinfo commands from a Texinfo source file"
        (tex  docs)
        "lisp/packages/")
    ("diff.el"
        "Run `diff' in compilation-mode."
        (unix  tools)
        "lisp/packages/")
    ("doctex.el"
        "grind GNU Emacs DOC file into LaTeX input"
        (tex  docs)
        "lisp/packages/")
    ("emacsbug.el"
        "command to report Emacs bugs to appropriate mailing list."
        (maint)
        "lisp/packages/")
    ("emerge.el"
        "merge diffs under Emacs control"
        (unix  tools)
        "lisp/packages/")
    ("etags.el"
        "etags facility for Emacs"
        (tools)
        "lisp/packages/")
    ("fast-lock.el"
        "Automagic text properties caching for fast Font Lock mode."
        (faces files)
        "lisp/packages/")
    ("feedmail.el"
        "outbound mail handling"
        (mail)
        "lisp/packages/")
    ("file-part.el"
        "treat a section of a buffer as a separate file"
        (extensions  tools)
        "lisp/packages/")
    ("filladapt.el"
        "adaptive fill; replacement for fill commands"
        (wp)
        "lisp/packages/")
    ("font-lock.el"
        "decorating source files with fonts/colors based on syntax"
        (languages  faces)
        "lisp/packages/")
    ("generic-sc.el"
        "generic interface to source control systems"
        (tools  unix)
        "lisp/packages/")
    ("gopher.el"
        "an emacs gopher client"
        (gopher  comm)
        "lisp/packages/")
    ("hexl.el"
        "edit a file in a hex dump format using the hexl filter."
        (data)
        "lisp/packages/")
    ("hyper-apropos.el"
        "Hypertext emacs lisp documentation interface."
        (lisp  tools  help  docs  matching)
        "lisp/packages/")
    ("icomplete.el"
        "minibuffer completion with incremental feedback"
        nil
        "lisp/packages/")
    ("info.el"
        "info package for Emacs."
        (help)
        "lisp/packages/")
    ("informat.el"
        "info support functions package for Emacs"
        (help)
        "lisp/packages/")
    ("lazy-lock.el"
        "Lazy demand-driven fontification for fast font-lock mode."
        (faces files)
        "lisp/packages/")
    ("ledit.el"
        "Emacs side of ledit interface"
        nil
        "lisp/packages/")
    ("lispm-fonts.el"
        "quick hack to parse LISPM-style font-shift codes"
        (faces)
        "lisp/packages/")
    ("lpr.el"
        "print Emacs buffer on line printer."
        (unix)
        "lisp/packages/")
    ("makesum.el"
        "generate key binding summary for Emacs"
        (help)
        "lisp/packages/")
    ("man.el"
        "browse UNIX manual pages"
        (help)
        "lisp/packages/")
    ("medit.el"
        "front-end to the MEDIT package for editing MDL"
        (languages)
        "lisp/packages/")
    ("metamail.el"
        "Metamail interface for GNU Emacs"
        (mail  news  mime  multimedia)
        "lisp/packages/")
    ("mime-compose.el"
        "mime-compose.el ---"
        nil
        "lisp/packages/")
    ("netunam.el"
        "HP-UX RFA Commands"
        (comm)
        "lisp/packages/")
    ("page-ext.el"
        "extended page handling commands"
        nil
        "lisp/packages/")
    ("paren.el"
        "highlight (un)matching parens and whole expressions"
        (languages  faces)
        "lisp/packages/")
    ("ps-print.el"
        "Jim's Pretty-Good PostScript Generator for Emacs 19."
        (print  postscript)
        "lisp/packages/")
    ("recent-files.el"
        "Maintain menu of recently opened files."
        (menu  file)
        "lisp/packages/")
    ("refbib.el"
        "convert refer-style references to ones usable by Latex bib"
        (bib  tex)
        "lisp/packages/")
    ("resume.el"
        "process command line args from within a suspended Emacs job"
        (processes)
        "lisp/packages/")
    ("rnews.el"
        "USENET news reader for gnu emacs"
        (news)
        "lisp/packages/")
    ("rnewspost.el"
        "USENET news poster/mailer for GNU Emacs"
        (mail  news)
        "lisp/packages/")
    ("saveplace.el"
        "automatically save place in files."
        (bookmarks  placeholders)
        "lisp/packages/")
    ("server.el"
        "Lisp code for GNU Emacs running as server process."
        (processes)
        "lisp/packages/")
    ("spell.el"
        "spelling correction interface for Emacs."
        (wp  unix)
        "lisp/packages/")
    ("supercite.el"
        "minor mode for citing mail and news replies"
        (citation attribution mail news article reply followup)
        "lisp/packages/")
    ("tar-mode.el"
        "simple editing of tar files from GNU emacs"
        (unix)
        "lisp/packages/")
    ("terminal.el"
        "terminal emulator for GNU Emacs."
        (comm  terminals)
        "lisp/packages/")
    ("time-stamp.el"
        "Maintain last change time stamps in files edited by Emacs"
        (tools)
        "lisp/packages/")
    ("time.el"
        "display time and load in mode line of Emacs."
        (extensions)
        "lisp/packages/")
    ("uncompress.el"
        "auto-decompression hook for visiting .Z files"
        (unix extensions)
        "lisp/packages/")
    ("underline.el"
        "insert/remove underlining (done by overstriking) in Emacs."
        (wp)
        "lisp/packages/")
    ("upd-copyr.el"
        "update the copyright notice in a GNU Emacs Lisp file"
        (maint)
        "lisp/packages/")
    ("vc-hooks.el"
        "resident support for version-control"
        nil
        "lisp/packages/")
    ("vc.el"
        "drive a version-control system from within Emacs"
        nil
        "lisp/packages/")
    ("xscheme.el"
        "run Scheme under Emacs"
        (languages  lisp)
        "lisp/packages/")
    ("about.el"
        "the About The Authors page (shameless self promotion)."
        nil
        "lisp/prim/")
    ("backquote.el"
        "Full backquote support for elisp.  Reverse compatible too."
        (extensions)
        "lisp/prim/")
    ("case-table.el"
        "code to extend the character set and support case tables."
        (i18n)
        "lisp/prim/")
    ("cmdloop.el"
        "support functions for the top-level command loop."
        nil
        "lisp/prim/")
    ("debug.el"
        "debuggers and related commands for XEmacs"
        nil
        "lisp/prim/")
    ("device.el"
        "miscellaneous device functions not written in C"
        (internal)
        "lisp/prim/")
    ("disp-table.el"
        "functions for dealing with char tables."
        (i18n)
        "lisp/prim/")
    ("env.el"
        "functions to manipulate environment variables."
        (processes  unix)
        "lisp/prim/")
    ("extents.el"
        "miscellaneous extent functions not written in C"
        (internal)
        "lisp/prim/")
    ("faces.el"
        "Lisp interface to the C \"face\" structure"
        (faces internal)
        "lisp/prim/")
    ("files.el"
        "file input and output commands for XEmacs."
        nil
        "lisp/prim/")
    ("fill.el"
        "fill commands for XEmacs."
        (wp)
        "lisp/prim/")
    ("float-sup.el"
        "detect absence of floating-point support in XEmacs runtime"
        (internal)
        "lisp/prim/")
    ("frame.el"
        "multi-frame management independent of window systems."
        (internal)
        "lisp/prim/")
    ("glyphs.el"
        "Lisp interface to C glyphs"
        (glyphs internal)
        "lisp/prim/")
    ("help.el"
        "help commands for XEmacs."
        nil
        "lisp/prim/")
    ("inc-vers.el"
        "load this to increment the recorded XEmacs version number."
        (internal)
        "lisp/prim/")
    ("indent.el"
        "indentation commands for XEmacs"
        (lisp languages tools)
        "lisp/prim/")
    ("lisp.el"
        "Lisp editing commands for XEmacs"
        (lisp  languages)
        "lisp/prim/")
    ("loaddefs.el"
        "define standard autoloads of other files"
        (internal)
        "lisp/prim/")
    ("loadup.el"
        "load up standardly loaded Lisp files for XEmacs."
        (internal)
        "lisp/prim/")
    ("macros.el"
        "non-primitive commands for keyboard macros."
        (abbrev)
        "lisp/prim/")
    ("misc.el"
        "miscellaneous functions for XEmacs"
        nil
        "lisp/prim/")
    ("mouse.el"
        "window system-independent mouse support."
        (hardware)
        "lisp/prim/")
    ("novice.el"
        "handling of disabled commands (\"novice mode\") for XEmacs."
        (internal  help)
        "lisp/prim/")
    ("objects.el"
        "Lisp interface to C window-system objects"
        (faces internal)
        "lisp/prim/")
    ("obsolete.el"
        "obsoleteness support."
        (internal)
        "lisp/prim/")
    ("options.el"
        "edit Options command for XEmacs."
        nil
        "lisp/prim/")
    ("page.el"
        "page motion commands for emacs."
        nil
        "lisp/prim/")
    ("paragraphs.el"
        "paragraph and sentence parsing."
        (wp)
        "lisp/prim/")
    ("process.el"
        "commands for subprocesses; split out of simple.el"
        nil
        "lisp/prim/")
    ("rect.el"
        "rectangle functions for XEmacs."
        (internal)
        "lisp/prim/")
    ("register.el"
        "register commands for XEmacs."
        (internal)
        "lisp/prim/")
    ("replace.el"
        "search and replace commands for XEmacs."
        nil
        "lisp/prim/")
    ("reposition.el"
        "center a Lisp function or comment on the screen"
        nil
        "lisp/prim/")
    ("simple.el"
        "basic editing commands for XEmacs"
        nil
        "lisp/prim/")
    ("sort.el"
        "commands to sort text in an XEmacs buffer."
        (unix)
        "lisp/prim/")
    ("sound.el"
        "Loading sound files in XEmacs"
        nil
        "lisp/prim/")
    ("specifier.el"
        "Lisp interface to specifiers"
        (internal)
        "lisp/prim/")
    ("startup.el"
        "process XEmacs shell arguments"
        (internal)
        "lisp/prim/")
    ("subr.el"
        "basic lisp subroutines for XEmacs"
        nil
        "lisp/prim/")
    ("tabify.el"
        "tab conversion commands for XEmacs"
        nil
        "lisp/prim/")
    ("userlock.el"
        "handle file access contention between multiple users"
        (internal)
        "lisp/prim/")
    ("window.el"
        "XEmacs window commands aside from those written in C."
        (extensions)
        "lisp/prim/")
    ("rmail.el"
        "main code of \"RMAIL\" mail reader for Emacs."
        (mail)
        "lisp/rmail/")
    ("rmailedit.el"
        "\"RMAIL edit mode\"  Edit the current message."
        (mail)
        "lisp/rmail/")
    ("rmailkwd.el"
        "part of the \"RMAIL\" mail reader for Emacs."
        (mail)
        "lisp/rmail/")
    ("rmailmsc.el"
        "miscellaneous support functions for the RMAIL mail reader"
        (mail)
        "lisp/rmail/")
    ("rmailout.el"
        "\"RMAIL\" mail reader for Emacs: output message to a file."
        (mail)
        "lisp/rmail/")
    ("rmailsort.el"
        "Rmail: sort messages."
        (mail)
        "lisp/rmail/")
    ("rmailsum.el"
        "make summary buffers for the mail reader"
        (mail)
        "lisp/rmail/")
    ("undigest.el"
        "digest-cracking support for the RMAIL mail reader"
        (mail)
        "lisp/rmail/")
    ("unrmail.el"
        "convert Rmail files to mailbox files."
        (mail)
        "lisp/rmail/")
    ("sunpro-keys.el"
        "SunPro-specific key bindings"
        nil
        "lisp/sunpro/")
    ("sunpro-menubar.el"
        "Initialize the SunPro menubar"
        (sunpro menubar initialization)
        "lisp/sunpro/")
    ("sunpro-sparcworks.el"
        "support SPARCworks manager ToolTalk messages"
        (sparcworks  tooltalk  messages)
        "lisp/sunpro/")
    ("generic-win.el"
        "generic window function initializtion"
        (terminals)
        "lisp/term/")
    ("ns-win.el"
        "runtime initialization for the NeXTstep window system"
        (terminals)
        "lisp/term/")
    ("post-tty-win.el"
        "second phase of runtime initialization for tty's"
        nil
        "lisp/term/")
    ("post-x-win.el"
        "second phase of runtime initialization for X windows"
        (terminals)
        "lisp/term/")
    ("pre-tty-win.el"
        "first phase of runtime initialization for tty's"
        nil
        "lisp/term/")
    ("pre-x-win.el"
        "first phase of runtime initialization for X windows"
        (terminals)
        "lisp/term/")
    ("tty-win.el"
        "runtime initialization for tty's if initial window system"
        nil
        "lisp/term/")
    ("vt-control.el"
        "Common VTxxx control functions"
        (terminals)
        "lisp/term/")
    ("vt100-led.el"
        "functions for LED control on VT-100 terminals & clones."
        (hardware)
        "lisp/term/")
    ("x-win-sun.el"
        "runtime initialization for Sun X servers and keyboards"
        (terminals)
        "lisp/term/")
    ("x-win-xfree86.el"
        "runtime initialization for XFree86 servers"
        (terminals)
        "lisp/term/")
    ("x-win.el"
        "runtime initialization for X windows if initial window system"
        (terminals)
        "lisp/term/")
    ("abbrevlist.el"
        "list one abbrev table alphabetically ordered."
        (abbrev)
        "lisp/utils/")
    ("advice.el"
        "an overloading mechanism for Emacs Lisp functions"
        (extensions  lisp  tools)
        "lisp/utils/")
    ("annotations.el"
        "interface to marginal annotations"
        (extensions  hypermedia  outlining)
        "lisp/utils/")
    ("assoc.el"
        "insert/delete/sort functions on association lists"
        (extensions)
        "lisp/utils/")
    ("atomic-extents.el"
        "treat regions of text as a single object"
        (extensions)
        "lisp/utils/")
    ("autoload.el"
        "maintain autoloads in loaddefs.el."
        (maint)
        "lisp/utils/")
    ("blessmail.el"
        "Decide whether movemail needs special privileges."
        (internal)
        "lisp/utils/")
    ("cl-compat.el"
        "Common Lisp extensions for GNU Emacs Lisp (compatibility)"
        (extensions)
        "lisp/utils/")
    ("cl-extra.el"
        "Common Lisp extensions for GNU Emacs Lisp (part two)"
        (extensions)
        "lisp/utils/")
    ("cl-macs.el"
        "Common Lisp extensions for GNU Emacs Lisp (part four)"
        (extensions)
        "lisp/utils/")
    ("cl-seq.el"
        "Common Lisp extensions for GNU Emacs Lisp (part three)"
        (extensions)
        "lisp/utils/")
    ("cl.el"
        "Common Lisp extensions for GNU Emacs Lisp"
        (extensions  lisp)
        "lisp/utils/")
    ("delbackspace.el"
        "rebind backspace and delete to be correct"
        (terminals)
        "lisp/utils/")
    ("derived.el"
        "allow inheritance of major modes."
        (extensions)
        "lisp/utils/")
    ("elp.el"
        "Emacs Lisp Profiler"
        (debugging lisp tools)
        "lisp/utils/")
    ("find-gc.el"
        "detect functions that call the garbage collector"
        (maint)
        "lisp/utils/")
    ("finder-inf.el"
        "keyword-to-package mapping"
        (help)
        "lisp/utils/")
    ("finder.el"
        "topic & keyword-based code finder"
        (help)
        "lisp/utils/")
    ("flow-ctrl.el"
        "help for lusers on cu(1) or ttys with wired-in ^S/^Q flow control"
        (hardware)
        "lisp/utils/")
    ("foldout.el"
        "Folding extensions for outline-mode and outline-minor-mode."
        (outlining)
        "lisp/utils/")
    ("forms-d2.el"
        "demo forms-mode"
        (extensions)
        "lisp/utils/")
    ("forms-pass.el"
        "demo for forms-mode"
        (extensions)
        "lisp/utils/")
    ("forms.el"
        "Forms mode: edit a file as a form to fill in."
        (extensions)
        "lisp/utils/")
    ("highlight-headers.el"
        "highlighting message headers."
        (mail  news)
        "lisp/utils/")
    ("loadhist.el"
        "lisp functions for working with feature groups"
        (internal)
        "lisp/utils/")
    ("mail-extr.el"
        "extract full name and address from RFC 822 mail header."
        (mail)
        "lisp/utils/")
    ("mail-utils.el"
        "Utility functions used both by rmail and rnews"
        (mail  news  internal)
        "lisp/utils/")
    ("mailpost.el"
        "RMAIL coupler to /usr/uci/post mailer"
        (mail)
        "lisp/utils/")
    ("map-ynp.el"
        "General-purpose boolean question-asker"
        (extensions)
        "lisp/utils/")
    ("meese.el"
        "protect the impressionable young minds of America"
        (games)
        "lisp/utils/")
    ("passwd.el"
        "Prompting for passwords semi-securely"
        (comm  extensions)
        "lisp/utils/")
    ("regi.el"
        "REGular expression Interpreting engine"
        (extensions  matching  wp)
        "lisp/utils/")
    ("reporter.el"
        "customizable bug reporting of lisp programs"
        (mail  lisp)
        "lisp/utils/")
    ("rfc822.el"
        "hairy rfc822 parser for mail and news and suchlike"
        (mail)
        "lisp/utils/")
    ("ring.el"
        "handle rings of items"
        (extensions)
        "lisp/utils/")
    ("symbol-syntax.el"
        "find chars with symbol syntax"
        (matching)
        "lisp/utils/")
    ("sysdep.el"
        "consolidate Emacs-version dependencies in one file."
        (lisp  tools)
        "lisp/utils/")
    ("text-props.el"
        "implements properties of characters"
        (extensions  wp  faces)
        "lisp/utils/")
    ("thing.el"
        "find language-specific contiguous pieces of text"
        (extensions  languages)
        "lisp/utils/")
    ("timezone.el"
        "timezone package for GNU Emacs"
        (internal extensions news)
        "lisp/utils/")
    ("tq.el"
        "utility to maintain a transaction queue"
        (extensions)
        "lisp/utils/")
    ("trace.el"
        "tracing facility for Emacs Lisp functions"
        (lisp  tools  debugging)
        "lisp/utils/")
    ("with-timeout.el"
        "timeout hackery"
        (extensions)
        "lisp/utils/")
    ("viper-util.el"
        "Utilities used by viper.el"
        nil
        "lisp/viper/")
    ("viper.el"
        "A full-featured Vi emulator for GNU Emacs 19 and XEmacs 19,"
        nil
        "lisp/viper/")
    ("vm-easymenu.el"
        "support the easymenu interface for defining a menu."
        (emulations)
        "lisp/vm/")
    ("vms-patch.el"
        "override parts of files.el for VMS."
        (vms)
        "lisp/vms/")
    ("vmsproc.el"
        "run asynchronous VMS subprocesses under Emacs"
        (vms)
        "lisp/vms/")
    ("vmsx.el"
        "run asynchronous VMS subprocesses under Emacs"
        (vms)
        "lisp/vms/")
    ("base64.el"
        "Base64 encoding functions"
        (extensions)
        "lisp/w3/")
    ("md5.el"
        "MD5 functionality for emacsen without it builtin"
        (mail  news  tools  hypermedia)
        "lisp/w3/")
    ("mm.el"
        "Mailcap parsing routines, and MIME handling"
        (mail  news  hypermedia)
        "lisp/w3/")
    ("ssl.el"
        "ssl functions for emacsen without them builtin"
        (comm)
        "lisp/w3/")
    ("url.el"
        "Uniform Resource Locator retrieval tool"
        (comm  data  processes  hypermedia)
        "lisp/w3/")
    ("urlauth.el"
        "Uniform Resource Locator authorization modules"
        (comm  data  processes  hypermedia)
        "lisp/w3/")
    ("w3-10646.el"
        "ISO 10646 Entities for Emacs-w3"
        (i18n)
        "lisp/w3/")
    ("w3-about.el"
        "About pages for emacs-w3"
        (hypermedia)
        "lisp/w3/")
    ("w3-beta.el"
        "Misc functions for emacs-w3's new display engine"
        (help  hypermedia  comm)
        "lisp/w3/")
    ("w3-draw.el"
        "Emacs-W3 drawing functions for new display engine"
        (faces  help  hypermedia)
        "lisp/w3/")
    ("w3-e19.el"
        "Emacs 19.xx specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3-emacs.el"
        "Emacs 18.xx specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3-epoch.el"
        "Epoch 4.x specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3-mac.el"
        "Macintosh specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3-mule.el"
        "MULE 18/19 specific functions for emacs-w3"
        (faces  help  i18n  mouse  hypermedia)
        "lisp/w3/")
    ("w3-next.el"
        "NeXTStep specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3-parse.el"
        "Generalized html/sgml parsing support for emacs-w3"
        (faces  help  hypermedia)
        "lisp/w3/")
    ("w3-print.el"
        "Printing support for emacs-w3"
        (faces  help  printing  hypermedia)
        "lisp/w3/")
    ("w3-srch.el"
        "Searching functions for emacs-w3"
        (matching  help  comm  hypermedia)
        "lisp/w3/")
    ("w3-style.el"
        "Emacs-W3 binding style sheet mechanism"
        (faces  hypermedia)
        "lisp/w3/")
    ("w3-sysdp.el"
        "consolidate Emacs-version dependencies in one file."
        (lisp  tools)
        "lisp/w3/")
    ("w3-vars.el"
        "All variable definitions for emacs-w3"
        (comm  help  hypermedia)
        "lisp/w3/")
    ("w3-wemac.el"
        "WinEmacs specific functions for emacs-w3"
        (faces  help  hypermedia  mouse)
        "lisp/w3/")
    ("w3-xemac.el"
        "XEmacs specific functions for emacs-w3"
        (faces  help  mouse  hypermedia)
        "lisp/w3/")
    ("w3.el"
        "Main functions for emacs-w3 on all platforms/versions"
        (faces  help  comm  news  mail  processes  mouse  hypermedia)
        "lisp/w3/")
    ("x-faces.el"
        "X-specific face frobnication, aka black magic."
        nil
        "lisp/x11/")
    ("x-menubar.el"
        "Menubar and popup-menu support for X."
        nil
        "lisp/x11/")
    ("x-misc.el"
        "miscellaneous X functions."
        nil
        "lisp/x11/")
    ("x-scrollbar.el"
        "scrollbar resourcing and such."
        nil
        "lisp/x11/")
))

(provide 'finder-inf)

;;; finder-inf.el ends here
