;;; inc-vers.el --- load this to increment the recorded XEmacs version number.

;; Copyright (C) 1985, 1986, 1993 Free Software Foundation, Inc.

;; Maintainer: FSF
;; Keywords: internal

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the 
;; Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Synched up with: Not in FSF.

;;; Code:

(insert-file-contents "../lisp/version.el")

(re-search-forward 
  "emacs-version \"[^\"0-9]*[0-9]+\\.[0-9]+\\(\\.\\([0-9]+\\)\\|\\)\\( (.*)\\)?\"")
(let ((version (if (= (match-beginning 1) (match-end 1))
		   (forward-char -1)
		 (goto-char (match-beginning 2))
		 (read (current-buffer)))))
  (if (null version)
      (insert ".1")
    (delete-region (match-beginning 2) (match-end 2))
    (prin1 (1+ version) (current-buffer))))
(skip-chars-backward "^\"")
(message "New XEmacs version will be %s"
	 (buffer-substring (point)
			   (progn (skip-chars-forward "^\"") (point))))


(if (and (file-accessible-directory-p "../lisp/")
	 (null (file-writable-p "../lisp/version.el")))
    (delete-file "../lisp/version.el"))
(write-region (point-min) (point-max) "../lisp/version.el" nil 'nomsg)
(erase-buffer)
(set-buffer-modified-p nil)

(kill-emacs)

;;; inc-vers.el ends here
